/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MinWatchPbLong;
import org.sat4j.pb.constraints.pb.WatchPbLong;
import org.sat4j.specs.ContradictionException;

public class MinWatchPbLongLimit
extends WatchPbLong {
    private static final long serialVersionUID = 1L;
    protected long watchCumul = 0L;
    protected long compWatchCumul = 0L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;

    protected MinWatchPbLongLimit(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected MinWatchPbLongLimit(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul == 0L);
        assert (this.watchingCount == 0);
        for (int i = 0; i < this.lits.length && this.watchCumulMinusValueIsLessThanDegree(this.coefs[0]); ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watching[this.watchingCount++] = i;
            this.watched[i] = true;
            this.addToWC(this.coefs[i]);
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.nbOfWatched() == this.watchingCount);
    }

    private void watchMoreForLearntConstraint() {
        int n = 1;
        while (this.watchCumulMinusValueIsLessThanDegree(this.coefs[0]) && n > 0) {
            n = 0;
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < this.lits.length; ++i) {
                if (!this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                ++n;
                int n4 = this.voc.getLevel(this.lits[i]);
                if (n4 <= n2) continue;
                n3 = i;
                n2 = n4;
            }
            if (n <= 0) continue;
            assert (n3 >= 0);
            this.voc.watch(this.lits[n3] ^ 1, this);
            this.watching[this.watchingCount++] = n3;
            this.watched[n3] = true;
            this.addToWC(this.coefs[n3]);
            assert (--n >= 0);
        }
        assert (this.lits.length == 1 || this.watchingCount > 1);
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.lits.length && this.watchCumulMinusValueIsLessThanDegree(this.coefs[this.watching[i]]); ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    public static MinWatchPbLongLimit normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MinWatchPbLongLimit minWatchPbLongLimit = new MinWatchPbLongLimit(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (minWatchPbLongLimit.degree <= 0L) {
            return null;
        }
        minWatchPbLongLimit.computeWatches();
        minWatchPbLongLimit.computePropagation(unitPropagationListener);
        return minWatchPbLongLimit;
    }

    protected int nbOfWatched() {
        int n = 0;
        for (int i = 0; i < this.watched.length; ++i) {
            for (int j = 0; j < this.watchingCount; ++j) {
                if (this.watching[j] == i) assert (this.watched[i]);
            }
            n += this.watched[i] ? 1 : 0;
        }
        return n;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        assert (this.nbOfWatched() == this.watchingCount);
        assert (this.watchingCount > 1);
        for (n2 = 0; n2 < this.watchingCount && (this.lits[this.watching[n2]] ^ 1) != n; ++n2) {
        }
        int n3 = this.watching[n2];
        assert (n == (this.lits[n3] ^ 1));
        assert (this.watched[n3]);
        long l = this.maximalCoefficient(n3);
        l = this.updateWatched(l, n3);
        assert (this.nbOfWatched() == this.watchingCount);
        if (this.watchCumulMinusValueIsLessThanDegree(this.coefs[n3])) {
            this.voc.watch(n, this);
            assert (this.watched[n3]);
            assert (!this.isSatisfiable());
            return false;
        }
        assert (Long.MAX_VALUE - this.coefs[n3] > l);
        if (this.watchCumulMinusValueIsLessThanDegree(this.coefs[n3] + l)) {
            assert (this.watchingCount != 0);
            for (int i = 0; i < this.watchingCount; ++i) {
                assert (Long.MAX_VALUE - this.coefs[n3] > this.coefs[this.watching[i]]);
                if (!this.watchCumulMinusValueIsLessThanDegree(this.coefs[n3] + this.coefs[this.watching[i]]) || i == n2 || this.voc.isSatisfied(this.lits[this.watching[i]]) || unitPropagationListener.enqueue(this.lits[this.watching[i]], this)) continue;
                this.voc.watch(n, this);
                assert (!this.isSatisfiable());
                return false;
            }
        }
        this.voc.undos(n).push(this);
        this.watched[n3] = false;
        this.substractToWC(this.coefs[n3]);
        this.watching[n2] = this.watching[--this.watchingCount];
        assert (this.watchingCount != 0);
        assert (this.nbOfWatched() == this.watchingCount);
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n;
        for (n = 0; n < this.watchingCount; ++n) {
            this.voc.watches(this.lits[this.watching[n]] ^ 1).remove(this);
            this.watched[this.watching[n]] = false;
        }
        this.watchingCount = 0;
        assert (this.nbOfWatched() == this.watchingCount);
        for (n = 0; n < this.coefs.length && this.watchCumulMinusValueIsLessThanDegree(this.coefs[n]); ++n) {
            unitPropagationListener.unset(this.lits[n]);
        }
    }

    public void undo(int n) {
        this.voc.watch(n, this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        assert (n2 < this.lits.length);
        this.addToWC(this.coefs[n2]);
        assert (this.watchingCount == this.nbOfWatched());
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
        assert (this.watchingCount == this.nbOfWatched());
    }

    public static WatchPbLong normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MinWatchPbLong(iLits, iDataStructurePB);
    }

    protected long maximalCoefficient(int n) {
        long l = 0L;
        for (int i = 0; i < this.watchingCount; ++i) {
            if (this.coefs[this.watching[i]] <= l || this.watching[i] == n) continue;
            l = this.coefs[this.watching[i]];
        }
        assert (this.learnt || l != 0L);
        return l;
    }

    protected long updateWatched(long l, int n) {
        long l2 = l;
        if (this.watchingCount < this.size()) {
            long l3 = 0L;
            long l4 = 0L;
            if (this.compWatchCumul > 0L) {
                assert (this.watchCumul == Long.MAX_VALUE);
                l4 = this.compWatchCumul - this.coefs[n];
                if (l4 < 0L) {
                    l3 = Long.MAX_VALUE - l4;
                    l4 = 0L;
                }
            } else {
                l3 = this.watchCumul - this.coefs[n];
            }
            long l5 = 0L;
            long l6 = 0L;
            if (Long.MAX_VALUE - this.degree < l2) {
                l5 = Long.MAX_VALUE;
                l6 = l2 - (Long.MAX_VALUE - this.degree);
            } else {
                l5 = this.degree + l2;
            }
            for (int i = 0; !(i >= this.lits.length || l4 == 0L && l6 == 0L && l3 >= l5 || l4 > l6 || l4 == l6 && l3 == l5); ++i) {
                if (this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                if (Long.MAX_VALUE - this.coefs[i] >= l3) {
                    l3 += this.coefs[i];
                } else {
                    l4 = this.coefs[i] - (Long.MAX_VALUE - l3);
                    l3 = Long.MAX_VALUE;
                }
                this.watched[i] = true;
                assert (this.watchingCount < this.size());
                this.watching[this.watchingCount++] = i;
                this.voc.watch(this.lits[i] ^ 1, this);
                if (this.coefs[i] <= l2) continue;
                l2 = this.coefs[i];
                l6 = 0L;
                if (Long.MAX_VALUE - this.degree < l2) {
                    l5 = Long.MAX_VALUE;
                    l6 = l2 - (Long.MAX_VALUE - this.degree);
                    continue;
                }
                l5 = this.degree + l2;
            }
            this.watchCumul = l3;
            this.compWatchCumul = l4;
            this.addToWC(this.coefs[n]);
        }
        return l2;
    }

    private boolean watchCumulMinusValueIsLessThanDegree(long l) {
        return this.watchCumul - l < this.degree && this.watchCumul != Long.MAX_VALUE || this.compWatchCumul - l > 0L || this.watchCumul - l + this.compWatchCumul < this.degree;
    }

    private void addToWC(long l) {
        if (Long.MAX_VALUE - l >= this.watchCumul) {
            this.watchCumul += l;
        } else {
            this.compWatchCumul = l - (Long.MAX_VALUE - this.watchCumul);
            this.watchCumul = Long.MAX_VALUE;
        }
    }

    private void substractToWC(long l) {
        if (this.compWatchCumul == 0L) {
            this.watchCumul -= l;
        } else {
            this.compWatchCumul -= l;
            if (this.compWatchCumul < 0L) {
                this.watchCumul -= this.compWatchCumul;
                this.compWatchCumul = 0L;
            }
        }
    }
}

