/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.ImplicationNamer;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisjunctionRHS<T, C> {
    private final IVecInt literals;
    private final DependencyHelper<T, C> helper;
    private final IVec<IConstr> toName = new Vec<IConstr>();

    public DisjunctionRHS(DependencyHelper<T, C> dependencyHelper, IVecInt iVecInt) {
        this.literals = iVecInt;
        this.helper = dependencyHelper;
    }

    public ImplicationNamer<T, C> implies(T ... TArray) throws ContradictionException {
        VecInt vecInt = new VecInt();
        for (T t : TArray) {
            vecInt.push(this.helper.getIntValue(t));
        }
        IteratorInt iteratorInt = this.literals.iterator();
        while (iteratorInt.hasNext()) {
            int n = iteratorInt.next();
            vecInt.push(n);
            IConstr iConstr = this.helper.solver.addClause(vecInt);
            if (iConstr == null) {
                throw new IllegalStateException("Constraints are not supposed to be null when using the helper");
            }
            this.toName.push(iConstr);
            vecInt.remove(n);
        }
        return new ImplicationNamer<T, C>(this.helper, this.toName);
    }
}

