/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.maxsat.MinCostDecorator;
import org.sat4j.maxsat.SolverFactory;
import org.sat4j.maxsat.WeightedMaxSatDecorator;
import org.sat4j.maxsat.reader.P2DimacsReader;
import org.sat4j.maxsat.reader.WDimacsReader;
import org.sat4j.opt.MaxSatDecorator;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.SolverDecorator;

public class GenericOptLauncher
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Options createCLIOptions() {
        Options options = new Options();
        options.addOption("t", "timeout", true, "specifies the timeout (in seconds)");
        options.addOption("T", "timeoutms", true, "specifies the timeout (in milliseconds)");
        options.addOption("k", "kind", true, "kind of problem: minone, maxsat, etc.");
        return options;
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("This software uses some libraries from the Jakarta Commons project. See jakarta.apache.org for details.");
    }

    public void usage() {
        System.out.println("java -jar sat4j-maxsat.jar instance-name");
    }

    protected Reader createReader(ISolver iSolver, String string) {
        if (string.endsWith(".wcnf")) {
            return new WDimacsReader((IPBSolver)iSolver);
        }
        if (string.endsWith("p2cnf")) {
            return new P2DimacsReader((MinCostDecorator)iSolver);
        }
        return new DimacsReader(iSolver);
    }

    protected String getInstanceName(String[] stringArray) {
        return stringArray[stringArray.length - 1];
    }

    protected ISolver configureSolver(String[] stringArray) {
        SolverDecorator solverDecorator = null;
        Options options = this.createCLIOptions();
        if (stringArray.length == 0) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("java -jar sat4j-maxsat.jar", options, true);
        } else {
            try {
                CommandLine commandLine = new PosixParser().parse(options, stringArray);
                int n = stringArray.length - 1;
                String string = commandLine.getOptionValue("k");
                if (string == null) {
                    string = "maxsat";
                }
                if ("minone".equalsIgnoreCase(string)) {
                    solverDecorator = new MinOneDecorator(SolverFactory.newLight());
                } else if ("mincost".equalsIgnoreCase(string) || stringArray[n].endsWith(".p2cnf")) {
                    solverDecorator = new MinCostDecorator(SolverFactory.newLight());
                } else {
                    if (!$assertionsDisabled && !"maxsat".equalsIgnoreCase(string)) {
                        throw new AssertionError();
                    }
                    solverDecorator = stringArray[n].endsWith(".wcnf") ? new WeightedMaxSatDecorator(SolverFactory.newLight()) : new MaxSatDecorator(SolverFactory.newMiniMaxSAT());
                }
                String string2 = commandLine.getOptionValue("t");
                if (string2 == null) {
                    string2 = commandLine.getOptionValue("T");
                    if (string2 != null) {
                        solverDecorator.setTimeoutMs(Long.parseLong(string2));
                    }
                } else {
                    solverDecorator.setTimeout(Integer.parseInt(string2));
                }
                this.log(solverDecorator.toString("c "));
            }
            catch (ParseException parseException) {
                HelpFormatter helpFormatter = new HelpFormatter();
                helpFormatter.printHelp("java -jar sat4jopt.jar", options, true);
            }
        }
        return solverDecorator;
    }

    public static void main(String[] stringArray) {
        GenericOptLauncher genericOptLauncher = new GenericOptLauncher();
        genericOptLauncher.run(stringArray);
    }

    static {
        $assertionsDisabled = !GenericOptLauncher.class.desiredAssertionStatus();
    }
}

