/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import org.sat4j.core.Vec;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.constraints.pb.ConflictMap;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolver;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PBSolverCP<L extends ILits>
extends PBSolver<L> {
    private static final long serialVersionUID = 1L;
    private IVec<String> conflictVariables = new Vec<String>();
    private IVec<String> conflictConstraints = new Vec<String>();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$core$PBSolverCP;

    public PBSolverCP(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy<L, PBDataStructureFactory<L>> learningStrategy, PBDataStructureFactory<L> pBDataStructureFactory, IOrder<L> iOrder) {
        super(assertingClauseGenerator, learningStrategy, pBDataStructureFactory, new SearchParams(1.5, 100), iOrder, (RestartStrategy)new MiniSATRestarts());
    }

    public PBSolverCP(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy<L, PBDataStructureFactory<L>> learningStrategy, PBDataStructureFactory<L> pBDataStructureFactory, SearchParams searchParams, IOrder<L> iOrder, RestartStrategy restartStrategy) {
        super(assertingClauseGenerator, learningStrategy, pBDataStructureFactory, searchParams, iOrder, restartStrategy);
    }

    public PBSolverCP(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy<L, PBDataStructureFactory<L>> learningStrategy, PBDataStructureFactory<L> pBDataStructureFactory, SearchParams searchParams, IOrder<L> iOrder) {
        super(assertingClauseGenerator, learningStrategy, pBDataStructureFactory, searchParams, iOrder, (RestartStrategy)new MiniSATRestarts());
    }

    @Override
    public void analyze(Constr constr, Pair pair) {
        PBConstr pBConstr;
        int n = this.trail.last();
        int n2 = this.voc.getLevel(n);
        IConflict iConflict = this.chooseConflict((PBConstr)constr, n2);
        this.initExplanation();
        this.buildExplanation(n, constr);
        if (!$assertionsDisabled && iConflict.slackConflict().signum() >= 0) {
            throw new AssertionError();
        }
        while (!iConflict.isAssertive(n2)) {
            pBConstr = (PBConstr)this.voc.getReason(n);
            this.buildExplanation(n, pBConstr);
            iConflict.resolve(pBConstr, n, this);
            if (!$assertionsDisabled && iConflict.slackConflict().signum() > 0) {
                throw new AssertionError();
            }
            if (this.trail.size() == 1) break;
            this.undoOne();
            if (this.decisionLevel() == 0) break;
            n = this.trail.last();
            if (this.voc.getLevel(n) != n2) {
                this.trailLim.pop();
                iConflict.updateSlack(this.voc.getLevel(n));
            }
            if (!$assertionsDisabled && this.voc.getLevel(n) > n2) {
                throw new AssertionError();
            }
            n2 = this.voc.getLevel(n);
            if (!$assertionsDisabled && !iConflict.slackIsCorrect(n2)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n2 != this.decisionLevel()) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n <= 1) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && !iConflict.isAssertive(n2) && this.trail.size() != 1 && this.decisionLevel() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n2 != this.decisionLevel()) {
            throw new AssertionError();
        }
        this.undoOne();
        if (iConflict.size() == 0 || (this.decisionLevel() == 0 || this.trail.size() == 0) && iConflict.slackConflict().signum() < 0) {
            pair.reason = null;
            pair.backtrackLevel = -1;
            return;
        }
        pBConstr = (PBConstr)((PBDataStructureFactory)this.dsfactory).createUnregisteredPseudoBooleanConstraint(iConflict);
        pair.reason = pBConstr;
        pair.backtrackLevel = this.decisionLevel() == 0 || this.trail.size() == 0 ? -1 : iConflict.getBacktrackLevel(n2);
    }

    @Override
    protected void analyzeAtRootLevel(Constr constr) {
        int n = this.trail.last();
        this.initExplanation();
        this.buildExplanation(n, constr);
        while (!this.trail.isEmpty()) {
            PBConstr pBConstr = (PBConstr)this.voc.getReason(n);
            if (pBConstr != null) {
                this.buildExplanation(n, pBConstr);
            }
            this.trail.pop();
            if (this.trail.isEmpty()) continue;
            n = this.trail.last();
        }
    }

    IConflict chooseConflict(PBConstr pBConstr, int n) {
        return ConflictMap.createConflict(pBConstr, n);
    }

    @Override
    public String toString(String string) {
        return new StringBuffer().append(string).append("Cutting planes based inference (").append(this.getClass().getName()).append(")\n").append(super.toString(string)).toString();
    }

    void initExplanation() {
        this.conflictVariables.clear();
        this.conflictConstraints.clear();
    }

    void buildExplanation(int n, Constr constr) {
        if (this.listOfVariables != null && this.listOfVariables.contains(n >> 1)) {
            this.conflictVariables.push(Lits.toString(n));
            this.conflictConstraints.push(constr.toString());
        }
    }

    @Override
    public String getExplanation() {
        if (!this.conflictVariables.isEmpty()) {
            if (!$assertionsDisabled && this.conflictVariables.size() != this.conflictConstraints.size()) {
                throw new AssertionError();
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Variables and constraints involved in unsatisfiability : \n");
            for (int i = 0; i < this.conflictVariables.size(); ++i) {
                stringBuffer.append(new StringBuffer().append("Var : ").append(this.conflictVariables.get(i)).toString());
                stringBuffer.append(new StringBuffer().append(" - Constr : ").append(this.conflictConstraints.get(i)).toString());
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }
        return "";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$core$PBSolverCP == null ? (class$org$sat4j$pb$core$PBSolverCP = PBSolverCP.class$("org.sat4j.pb.core.PBSolverCP")) : class$org$sat4j$pb$core$PBSolverCP).desiredAssertionStatus();
    }
}

