/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.ExitCode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;

public abstract class AbstractLauncher
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SOLUTION_PREFIX = "v ";
    public static final String ANSWER_PREFIX = "s ";
    public static final String COMMENT_PREFIX = "c ";
    protected long beginTime;
    protected ExitCode exitCode = ExitCode.UNKNOWN;
    protected Reader reader;
    protected transient PrintWriter out = new PrintWriter(System.out, true);
    protected transient Thread shutdownHook = new Thread(){

        public void run() {
            AbstractLauncher.this.displayResult();
        }
    };
    protected ISolver solver;
    private boolean silent = false;

    protected AbstractLauncher() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected void displayResult() {
        if (this.solver != null) {
            System.out.flush();
            this.out.flush();
            double d = (double)(System.currentTimeMillis() - this.beginTime) / 1000.0;
            this.solver.printStat(this.out, COMMENT_PREFIX);
            this.solver.printInfos(this.out, COMMENT_PREFIX);
            this.out.println(ANSWER_PREFIX + this.exitCode);
            if (this.exitCode == ExitCode.SATISFIABLE) {
                int[] nArray = this.solver.model();
                this.out.print(SOLUTION_PREFIX);
                this.reader.decode(nArray, this.out);
                this.out.println();
            }
            this.log("Total wall clock time (in seconds) : " + d);
        }
    }

    public abstract void usage();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void displayHeader() {
        block14: {
            this.displayLicense();
            try {
                v0 = Class.forName("org.sat4j.AbstractLauncher");
            }
            catch (ClassNotFoundException v1) {
                throw new NoClassDefFoundError(v1.getMessage());
            }
            var1_1 = v0.getResource("/sat4j.version");
            if (var1_1 == null) {
                this.log("no version file found!!!");
            } else {
                var2_2 = null;
                try {
                    try {
                        var2_2 = new BufferedReader(new InputStreamReader(var1_1.openStream()));
                        this.log("version " + var2_2.readLine());
                    }
                    catch (IOException var3_3) {
                        this.log("c ERROR: " + var3_3.getMessage());
                    }
                }
                catch (Throwable var5_5) {
                    var4_7 = null;
                    if (var2_2 == null) throw var5_5;
                    try {
                        var2_2.close();
                        throw var5_5;
                    }
                    catch (IOException var6_11) {
                        this.log("c ERROR: " + var6_11.getMessage());
                    }
                    throw var5_5;
                }
                {
                    var4_8 = null;
                    if (var2_2 == null) break block14;
                }
                ** try [egrp 3[TRYBLOCK] [4 : 131->138)] { 
lbl33:
                // 1 sources

                var2_2.close();
            }
            break block14;
lbl35:
            // 1 sources

            catch (IOException var6_12) {
                this.log("c ERROR: " + var6_12.getMessage());
            }
        }
        var2_2 = System.getProperties();
        var3_4 = new String[]{"java.runtime.name", "java.vm.name", "java.vm.version", "java.vm.vendor", "sun.arch.data.model", "java.version", "os.name", "os.version", "os.arch"};
        var4_9 = 0;
        while (true) {
            if (var4_9 >= var3_4.length) {
                var4_10 = Runtime.getRuntime();
                this.log("Free memory \t\t" + var4_10.freeMemory());
                this.log("Max memory \t\t" + var4_10.maxMemory());
                this.log("Total memory \t\t" + var4_10.totalMemory());
                this.log("Number of processors \t" + var4_10.availableProcessors());
                return;
            }
            var5_6 = var3_4[var4_9];
            this.log(String.valueOf(var5_6) + (var5_6.length() < 14 ? "\t\t" : "\t") + var2_2.getProperty(var5_6));
            ++var4_9;
        }
    }

    public void displayLicense() {
        this.log("SAT4J: a SATisfiability library for Java (c) 2004-2010 Daniel Le Berre");
        this.log("This is free software under the dual EPL/GNU LGPL licenses.");
        this.log("See www.sat4j.org for details.");
    }

    protected IProblem readProblem(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        this.log("solving " + string);
        this.log("reading problem ... ");
        this.reader = this.createReader(this.solver, string);
        IProblem iProblem = this.reader.parseInstance(string);
        this.log("... done. Wall clock time " + (double)(System.currentTimeMillis() - this.beginTime) / 1000.0 + "s.");
        this.log("#vars     " + iProblem.nVars());
        this.log("#constraints  " + iProblem.nConstraints());
        iProblem.printInfos(this.out, COMMENT_PREFIX);
        return iProblem;
    }

    protected abstract Reader createReader(ISolver var1, String var2);

    public void run(String[] stringArray) {
        try {
            String string;
            this.displayHeader();
            this.solver = this.configureSolver(stringArray);
            if (this.solver == null) {
                this.usage();
                return;
            }
            if (!this.silent) {
                this.solver.setVerbose(true);
            }
            if ((string = this.getInstanceName(stringArray)) == null) {
                this.usage();
                return;
            }
            this.beginTime = System.currentTimeMillis();
            IProblem iProblem = this.readProblem(string);
            try {
                this.solve(iProblem);
            }
            catch (TimeoutException timeoutException) {
                this.log("timeout");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("FATAL " + fileNotFoundException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            System.err.println("FATAL " + iOException.getLocalizedMessage());
        }
        catch (ContradictionException contradictionException) {
            this.exitCode = ExitCode.UNSATISFIABLE;
            this.log("(trivial inconsistency)");
        }
        catch (ParseFormatException parseFormatException) {
            System.err.println("FATAL " + parseFormatException.getLocalizedMessage());
        }
    }

    protected abstract String getInstanceName(String[] var1);

    protected abstract ISolver configureSolver(String[] var1);

    public void log(String string) {
        if (!this.silent) {
            this.out.println(COMMENT_PREFIX + string);
        }
    }

    protected void solve(IProblem iProblem) throws TimeoutException {
        this.exitCode = iProblem.isSatisfiable() ? ExitCode.SATISFIABLE : ExitCode.UNSATISFIABLE;
    }

    public final void setExitCode(ExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public final ExitCode getExitCode() {
        return this.exitCode;
    }

    public final long getBeginTime() {
        return this.beginTime;
    }

    public final Reader getReader() {
        return this.reader;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    protected void setSilent(boolean bl) {
        this.silent = bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.out = new PrintWriter(System.out, true);
        this.shutdownHook = new Thread(){

            public void run() {
                AbstractLauncher.this.displayResult();
            }
        };
    }

    protected void showAvailableSolvers(ASolverFactory aSolverFactory) {
        if (aSolverFactory != null) {
            this.log("Available solvers: ");
            String[] stringArray = aSolverFactory.solverNames();
            int n = 0;
            while (n < stringArray.length) {
                this.log(stringArray[n]);
                ++n;
            }
        }
    }
}

