/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractLauncher;
import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.reader.InstanceReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class BasicLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    private final ASolverFactory factory;

    public BasicLauncher(ASolverFactory aSolverFactory) {
        this.factory = aSolverFactory;
    }

    public static void main(String[] stringArray) {
        BasicLauncher basicLauncher = new BasicLauncher(SolverFactory.instance());
        if (stringArray.length != 1) {
            basicLauncher.usage();
            return;
        }
        basicLauncher.run(stringArray);
        System.exit(basicLauncher.getExitCode().value());
    }

    protected ISolver configureSolver(String[] stringArray) {
        ISolver iSolver = this.factory.defaultSolver();
        iSolver.setTimeout(Integer.MAX_VALUE);
        iSolver.setDBSimplificationAllowed(true);
        this.getLogWriter().println(iSolver.toString("c "));
        return iSolver;
    }

    protected Reader createReader(ISolver iSolver, String string) {
        return new InstanceReader(iSolver);
    }

    public void usage() {
        this.log("java -jar org.sat4j.core.jar <cnffile>");
    }

    protected String getInstanceName(String[] stringArray) {
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[0];
    }
}

