/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.sat4j.specs.ISolver;

public abstract class ASolverFactory
implements Serializable {
    private static final long serialVersionUID = 1L;

    public String[] solverNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Method[] methodArray = this.getClass().getDeclaredMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getParameterTypes().length == 0 && methodArray[n].getName().startsWith("new")) {
                arrayList.add(methodArray[n].getName().substring(3));
            }
            ++n;
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public ISolver createSolverByName(String string) {
        try {
            Class[] classArray = new Class[]{};
            Method method = this.getClass().getMethod("new" + string, classArray);
            return (ISolver)method.invoke(null, null);
        }
        catch (SecurityException securityException) {
            System.err.println(securityException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getLocalizedMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException.getLocalizedMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException.getLocalizedMessage());
        }
        return null;
    }

    public abstract ISolver defaultSolver();

    public abstract ISolver lightSolver();
}

