/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sat4j.specs.IVec;

public final class Vec
implements IVec {
    private static final long serialVersionUID = 1L;
    private int nbelem;
    private Object[] myarray;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.core.Vec");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Vec() {
        this(5);
    }

    public Vec(Object[] objectArray) {
        this.myarray = objectArray;
        this.nbelem = objectArray.length;
    }

    public Vec(int n) {
        this.myarray = new Object[n];
    }

    public Vec(int n, Object object) {
        this.myarray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            this.myarray[n2] = object;
            ++n2;
        }
        this.nbelem = n;
    }

    public int size() {
        return this.nbelem;
    }

    public void shrink(int n) {
        while (n-- > 0) {
            this.myarray[--this.nbelem] = null;
        }
    }

    public void shrinkTo(int n) {
        int n2 = this.nbelem;
        while (n2 > n) {
            this.myarray[n2 - 1] = null;
            --n2;
        }
        this.nbelem = n;
    }

    public void pop() {
        this.myarray[--this.nbelem] = null;
    }

    public void growTo(int n, Object object) {
        this.ensure(n);
        int n2 = this.nbelem;
        while (n2 < n) {
            this.myarray[n2] = object;
            ++n2;
        }
        this.nbelem = n;
    }

    public void ensure(int n) {
        if (n >= this.myarray.length) {
            Object[] objectArray = new Object[Math.max(n, this.nbelem * 2)];
            System.arraycopy(this.myarray, 0, objectArray, 0, this.nbelem);
            this.myarray = objectArray;
        }
    }

    public IVec push(Object object) {
        this.ensure(this.nbelem + 1);
        this.myarray[this.nbelem++] = object;
        return this;
    }

    public void unsafePush(Object object) {
        this.myarray[this.nbelem++] = object;
    }

    public void insertFirst(Object object) {
        if (this.nbelem > 0) {
            this.push(this.myarray[0]);
            this.myarray[0] = object;
            return;
        }
        this.push(object);
    }

    public void insertFirstWithShifting(Object object) {
        if (this.nbelem > 0) {
            this.ensure(this.nbelem + 1);
            int n = this.nbelem;
            while (n > 0) {
                this.myarray[n] = this.myarray[n - 1];
                --n;
            }
            this.myarray[0] = object;
            ++this.nbelem;
            return;
        }
        this.push(object);
    }

    public void clear() {
        Arrays.fill(this.myarray, 0, this.nbelem, null);
        this.nbelem = 0;
    }

    public Object last() {
        return this.myarray[this.nbelem - 1];
    }

    public Object get(int n) {
        return this.myarray[n];
    }

    public void set(int n, Object object) {
        this.myarray[n] = object;
    }

    public void remove(Object object) {
        int n = 0;
        while (this.myarray[n] != object) {
            if (!$assertionsDisabled && n >= this.size()) {
                throw new AssertionError();
            }
            ++n;
        }
        System.arraycopy(this.myarray, n + 1, this.myarray, n, this.size() - n - 1);
        this.myarray[--this.nbelem] = null;
    }

    public Object delete(int n) {
        Object object = this.myarray[n];
        this.myarray[n] = this.myarray[--this.nbelem];
        this.myarray[this.nbelem] = null;
        return object;
    }

    public void copyTo(IVec iVec) {
        Vec vec = (Vec)iVec;
        int n = this.nbelem + vec.nbelem;
        iVec.ensure(n);
        System.arraycopy(this.myarray, 0, vec.myarray, vec.nbelem, this.nbelem);
        vec.nbelem = n;
    }

    public void copyTo(Object[] objectArray) {
        System.arraycopy(this.myarray, 0, objectArray, 0, this.nbelem);
    }

    public void moveTo(IVec iVec) {
        this.copyTo(iVec);
        this.clear();
    }

    public void moveTo(int n, int n2) {
        if (n != n2) {
            this.myarray[n] = this.myarray[n2];
            this.myarray[n2] = null;
        }
    }

    public Object[] toArray() {
        return this.myarray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.nbelem - 1) {
            stringBuffer.append(this.myarray[n]);
            stringBuffer.append(",");
            ++n;
        }
        if (this.nbelem > 0) {
            stringBuffer.append(this.myarray[this.nbelem - 1]);
        }
        return stringBuffer.toString();
    }

    void selectionSort(int n, int n2, Comparator comparator) {
        int n3 = n;
        while (n3 < n2 - 1) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n2) {
                if (comparator.compare(this.myarray[n5], this.myarray[n4]) < 0) {
                    n4 = n5;
                }
                ++n5;
            }
            Object object = this.myarray[n3];
            this.myarray[n3] = this.myarray[n4];
            this.myarray[n4] = object;
            ++n3;
        }
    }

    void sort(int n, int n2, Comparator comparator) {
        int n3 = n2 - n;
        if (n3 <= 15) {
            this.selectionSort(n, n2, comparator);
        } else {
            Object object = this.myarray[n3 / 2 + n];
            int n4 = n - 1;
            int n5 = n2;
            while (true) {
                if (comparator.compare(this.myarray[++n4], object) < 0) {
                    continue;
                }
                while (comparator.compare(object, this.myarray[--n5]) < 0) {
                }
                if (n4 >= n5) break;
                Object object2 = this.myarray[n4];
                this.myarray[n4] = this.myarray[n5];
                this.myarray[n5] = object2;
            }
            this.sort(n, n4, comparator);
            this.sort(n4, n2, comparator);
        }
    }

    public void sort(Comparator comparator) {
        this.sort(0, this.nbelem, comparator);
    }

    public void sortUnique(Comparator comparator) {
        if (this.nbelem == 0) {
            return;
        }
        this.sort(0, this.nbelem, comparator);
        int n = 1;
        Object object = this.myarray[0];
        int n2 = 1;
        while (n2 < this.nbelem) {
            if (comparator.compare(object, this.myarray[n2]) < 0) {
                object = this.myarray[n] = this.myarray[n2];
                ++n;
            }
            ++n2;
        }
        this.nbelem = n;
    }

    public boolean equals(Object object) {
        if (object instanceof IVec) {
            IVec iVec = (IVec)object;
            if (iVec.size() != this.size()) {
                return false;
            }
            int n = 0;
            while (n < this.size()) {
                if (!iVec.get(n).equals(this.get(n))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.nbelem) {
            n += this.myarray[n2].hashCode() / this.nbelem;
            ++n2;
        }
        return n;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int i = 0;

            public boolean hasNext() {
                return this.i < Vec.this.nbelem;
            }

            public Object next() {
                if (this.i == Vec.this.nbelem) {
                    throw new NoSuchElementException();
                }
                return Vec.this.myarray[this.i++];
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isEmpty() {
        return this.nbelem == 0;
    }

    public boolean contains(Object object) {
        int n = 0;
        while (n < this.nbelem) {
            if (this.myarray[n].equals(object)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public int indexOf(Object object) {
        int n = 0;
        while (n < this.nbelem) {
            if (this.myarray[n].equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

