/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import java.io.Serializable;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public abstract class AbstractDataStructureFactory
implements DataStructureFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    protected ILits lits;
    private final IVec tmp = new Vec();
    protected UnitPropagationListener solver;
    protected Learner learner;

    public void conflictDetectedInWatchesFor(int n, int n2) {
        int n3 = n2 + 1;
        while (n3 < this.tmp.size()) {
            this.lits.watch(n, (Propagatable)this.tmp.get(n3));
            ++n3;
        }
    }

    public IVec getWatchesFor(int n) {
        this.tmp.clear();
        this.lits.watches(n).moveTo(this.tmp);
        return this.tmp;
    }

    protected AbstractDataStructureFactory() {
        this.lits = this.createLits();
    }

    protected abstract ILits createLits();

    public ILits getVocabulary() {
        return this.lits;
    }

    public void setUnitPropagationListener(UnitPropagationListener unitPropagationListener) {
        this.solver = unitPropagationListener;
    }

    public void setLearner(Learner learner) {
        this.learner = learner;
    }

    public void reset() {
    }

    public void learnConstraint(Constr constr) {
        this.learner.learn(constr);
    }

    public Constr createCardinalityConstraint(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }
}

