/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.specs.IVec;

public final class Lits
implements Serializable,
ILits {
    private static final int DEFAULT_INIT_SIZE = 128;
    private static final long serialVersionUID = 1L;
    private boolean[] pool = new boolean[1];
    private int realnVars = 0;
    private IVec[] watches = new IVec[0];
    private int[] level = new int[0];
    private Constr[] reason = new Constr[0];
    private int maxvarid = 0;
    private IVec[] undos = new IVec[0];
    private boolean[] falsified = new boolean[0];
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.minisat.constraints.cnf.Lits");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Lits() {
        this.init(128);
    }

    public final void init(int n) {
        if (n < this.pool.length) {
            return;
        }
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        int n2 = n + 1;
        boolean[] blArray = new boolean[n2];
        System.arraycopy(this.pool, 0, blArray, 0, this.pool.length);
        this.pool = blArray;
        int[] nArray = new int[n2];
        System.arraycopy(this.level, 0, nArray, 0, this.level.length);
        this.level = nArray;
        IVec[] iVecArray = new IVec[2 * n2];
        System.arraycopy(this.watches, 0, iVecArray, 0, this.watches.length);
        this.watches = iVecArray;
        IVec[] iVecArray2 = new IVec[n2];
        System.arraycopy(this.undos, 0, iVecArray2, 0, this.undos.length);
        this.undos = iVecArray2;
        Constr[] constrArray = new Constr[n2];
        System.arraycopy(this.reason, 0, constrArray, 0, this.reason.length);
        this.reason = constrArray;
        boolean[] blArray2 = new boolean[2 * n2];
        System.arraycopy(this.falsified, 0, blArray2, 0, this.falsified.length);
        this.falsified = blArray2;
    }

    public int getFromPool(int n) {
        int n2 = Math.abs(n);
        if (n2 >= this.pool.length) {
            this.init(Math.max(n2, this.pool.length << 1));
        }
        if (!$assertionsDisabled && n2 >= this.pool.length) {
            throw new AssertionError();
        }
        if (n2 > this.maxvarid) {
            this.maxvarid = n2;
        }
        int n3 = LiteralsUtils.toInternal(n);
        if (!$assertionsDisabled && n3 <= 1) {
            throw new AssertionError();
        }
        if (!this.pool[n2]) {
            ++this.realnVars;
            this.pool[n2] = true;
            this.watches[n2 << 1] = new Vec();
            this.watches[n2 << 1 | 1] = new Vec();
            this.undos[n2] = new Vec();
            this.level[n2] = -1;
            this.falsified[n2 << 1] = false;
            this.falsified[n2 << 1 | 1] = false;
        }
        return n3;
    }

    public boolean belongsToPool(int n) {
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (n >= this.pool.length) {
            return false;
        }
        return this.pool[n];
    }

    public void resetPool() {
        int n = 0;
        while (n < this.pool.length) {
            if (this.pool[n]) {
                this.reset(n << 1);
            }
            ++n;
        }
    }

    public void ensurePool(int n) {
        if (n >= this.pool.length) {
            this.init(Math.max(n, this.pool.length << 1));
        }
        this.maxvarid = n;
    }

    public void unassign(int n) {
        if (!($assertionsDisabled || this.falsified[n] || this.falsified[n ^ 1])) {
            throw new AssertionError();
        }
        this.falsified[n] = false;
        this.falsified[n ^ 1] = false;
    }

    public void satisfies(int n) {
        if (!$assertionsDisabled && (this.falsified[n] || this.falsified[n ^ 1])) {
            throw new AssertionError();
        }
        this.falsified[n] = false;
        this.falsified[n ^ 1] = true;
    }

    public boolean isSatisfied(int n) {
        return this.falsified[n ^ 1];
    }

    public final boolean isFalsified(int n) {
        return this.falsified[n];
    }

    public boolean isUnassigned(int n) {
        return !this.falsified[n] && !this.falsified[n ^ 1];
    }

    public String valueToString(int n) {
        if (this.isUnassigned(n)) {
            return "?";
        }
        if (this.isSatisfied(n)) {
            return "T";
        }
        return "F";
    }

    public int nVars() {
        return this.maxvarid;
    }

    public int not(int n) {
        return n ^ 1;
    }

    public static String toString(int n) {
        return String.valueOf((n & 1) == 0 ? "" : "-") + (n >> 1);
    }

    public void reset(int n) {
        this.watches[n].clear();
        this.watches[n ^ 1].clear();
        this.level[n >> 1] = -1;
        this.reason[n >> 1] = null;
        this.undos[n >> 1].clear();
        this.falsified[n] = false;
        this.falsified[n ^ 1] = false;
    }

    public int getLevel(int n) {
        return this.level[n >> 1];
    }

    public void setLevel(int n, int n2) {
        this.level[n >> 1] = n2;
    }

    public Constr getReason(int n) {
        return this.reason[n >> 1];
    }

    public void setReason(int n, Constr constr) {
        this.reason[n >> 1] = constr;
    }

    public IVec undos(int n) {
        return this.undos[n >> 1];
    }

    public void watch(int n, Propagatable propagatable) {
        this.watches[n].push(propagatable);
    }

    public IVec watches(int n) {
        return this.watches[n];
    }

    public boolean isImplied(int n) {
        int n2 = n >> 1;
        if (!($assertionsDisabled || this.reason[n2] == null || this.falsified[n] || this.falsified[n ^ 1])) {
            throw new AssertionError();
        }
        return this.pool[n2] && (this.reason[n2] != null || this.level[n2] == 0);
    }

    public int realnVars() {
        return this.realnVars;
    }

    protected int capacity() {
        return this.pool.length - 1;
    }

    public int nextFreeVarId(boolean bl) {
        if (bl) {
            this.ensurePool(this.maxvarid + 1);
            return this.maxvarid;
        }
        return this.maxvarid + 1;
    }
}

