/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.learning;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;

public abstract class LimitedLearning
implements LearningStrategy {
    private static final long serialVersionUID = 1L;
    private final NoLearningButHeuristics none = new NoLearningButHeuristics();
    private final MiniSATLearning all = new MiniSATLearning();
    protected ILits lits;
    private SolverStats stats;

    public void setSolver(Solver solver) {
        this.lits = solver.getVocabulary();
        this.setVarActivityListener(solver);
        this.all.setDataStructureFactory(solver.getDSFactory());
        this.stats = solver.getStats();
    }

    public void learns(Constr constr) {
        if (this.learningCondition(constr)) {
            this.all.learns(constr);
        } else {
            this.none.learns(constr);
            ++this.stats.ignoredclauses;
        }
    }

    protected abstract boolean learningCondition(Constr var1);

    public void init() {
        this.all.init();
        this.none.init();
    }

    public void setVarActivityListener(VarActivityListener varActivityListener) {
        this.none.setVarActivityListener(varActivityListener);
        this.all.setVarActivityListener(varActivityListener);
    }
}

