/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public final class MinOneDecorator
extends SolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] prevmodel;
    private boolean isSolutionOptimal;
    private int counter;
    private final IVecInt literals = new VecInt();
    private IConstr previousConstr;

    public MinOneDecorator(ISolver iSolver) {
        super(iSolver);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        this.isSolutionOptimal = false;
        boolean bl = this.isSatisfiable(iVecInt, true);
        if (bl) {
            this.prevmodel = super.model();
            this.calculateObjectiveValue();
        } else {
            this.isSolutionOptimal = true;
        }
        return bl;
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        this.calculateObjectiveValue();
        return new Integer(this.counter);
    }

    private void calculateObjectiveValue() {
        this.counter = 0;
        int[] nArray = this.prevmodel;
        int n = this.prevmodel.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 > 0) {
                ++this.counter;
            }
            ++n2;
        }
    }

    public void discardCurrentSolution() throws ContradictionException {
        if (this.literals.isEmpty()) {
            int n = 1;
            while (n <= this.nVars()) {
                this.literals.push(n);
                ++n;
            }
        }
        if (this.previousConstr != null) {
            super.removeConstr(this.previousConstr);
        }
        this.previousConstr = this.addAtMost(this.literals, this.counter - 1);
    }

    public int[] model() {
        return this.prevmodel;
    }

    public void reset() {
        this.literals.clear();
        this.previousConstr = null;
        super.reset();
    }

    public Number getObjectiveValue() {
        return new Integer(this.counter);
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        try {
            this.addAtMost(this.literals, number.intValue());
        }
        catch (ContradictionException contradictionException) {
            this.isSolutionOptimal = true;
            throw contradictionException;
        }
    }

    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }
}

