/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.reader.ParseFormatException;

public class EfficientScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TAILLE_BUF = 16384;
    private final transient BufferedInputStream in;
    private static final char EOF = '\uffff';
    private final char commentChar;

    public EfficientScanner(InputStream inputStream, char c) {
        this.in = new BufferedInputStream(inputStream, 16384);
        this.commentChar = c;
    }

    public EfficientScanner(InputStream inputStream) {
        this(inputStream, 'c');
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void skipComments() throws IOException {
        char c;
        while ((c = this.currentChar()) == this.commentChar) {
            this.skipRestOfLine();
            if (c != '\uffff') continue;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextInt() throws IOException, ParseFormatException {
        int n;
        int n2 = 0;
        boolean bl = false;
        char c = this.skipSpaces();
        if (c == '-') {
            bl = true;
            c = (char)this.in.read();
        } else if (c == '+') {
            c = (char)this.in.read();
        } else {
            if (c < '0') throw new ParseFormatException("Unknown character " + c);
            if (c > '9') throw new ParseFormatException("Unknown character " + c);
            n2 = c - 48;
            c = (char)this.in.read();
        }
        while (c >= '0' && c <= '9') {
            n2 = n2 * 10 + c - 48;
            c = (char)this.in.read();
        }
        if (c == '\r') {
            this.in.read();
        }
        if (bl) {
            n = -n2;
            return n;
        }
        n = n2;
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger nextBigInteger() throws IOException, ParseFormatException {
        block3: {
            block2: {
                block1: {
                    var1_1 = new StringBuffer();
                    var2_2 = this.skipSpaces();
                    if (var2_2 != '-') break block1;
                    var1_1.append(var2_2);
                    var2_2 = (char)this.in.read();
                    ** GOTO lbl24
                }
                if (var2_2 != '+') break block2;
                var2_2 = (char)this.in.read();
                ** GOTO lbl24
            }
            if (var2_2 < '0' || var2_2 > '9') break block3;
            var1_1.append(var2_2);
            var2_2 = (char)this.in.read();
            if (true) ** GOTO lbl24
        }
        throw new ParseFormatException("Unknown character " + var2_2);
        do {
            var1_1.append(var2_2);
            var2_2 = (char)this.in.read();
lbl24:
            // 4 sources

        } while (var2_2 >= '0' && var2_2 <= '9');
        return new BigInteger(var1_1.toString());
    }

    public String next() throws IOException, ParseFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        char c = this.skipSpaces();
        while (c != ' ' && c != '\n') {
            stringBuffer.append(c);
            c = (char)this.in.read();
        }
        return stringBuffer.toString();
    }

    public char skipSpaces() throws IOException {
        char c;
        while ((c = (char)this.in.read()) == ' ' || c == '\n') {
        }
        return c;
    }

    public String nextLine() throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            c = (char)this.in.read();
            stringBuffer.append(c);
        } while (c != '\n' && c != '\uffff');
        return stringBuffer.toString();
    }

    public void skipRestOfLine() throws IOException {
        char c;
        while ((c = (char)this.in.read()) != '\n' && c != '\uffff') {
        }
    }

    public boolean eof() throws IOException {
        return this.currentChar() == '\uffff';
    }

    public char currentChar() throws IOException {
        this.in.mark(10);
        char c = (char)this.in.read();
        this.in.reset();
        return c;
    }
}

