/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import org.sat4j.core.Vec;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;

public class DotSearchTracing
implements SearchListener {
    private static final long serialVersionUID = 1L;
    private final Vec pile = new Vec();
    private String currentNodeName = null;
    private transient Writer out;
    private boolean estOrange = false;
    private final Map mapping;

    public DotSearchTracing(String string, Map map) {
        this.mapping = map;
        try {
            this.out = new FileWriter(string);
        }
        catch (IOException iOException) {
            System.err.println("Problem when created file.");
        }
    }

    private String node(int n) {
        int n2;
        Object v;
        if (this.mapping != null && (v = this.mapping.get(new Integer(n2 = Math.abs(n)))) != null) {
            if (n > 0) {
                return v.toString();
            }
            return "-" + v.toString();
        }
        return Integer.toString(n);
    }

    public final void assuming(int n) {
        String string;
        int n2 = Math.abs(n);
        if (this.currentNodeName == null) {
            string = "" + n2;
            this.pile.push(string);
            this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + this.node(n) + "\", shape=circle, color=blue, style=filled]"));
        } else {
            string = this.currentNodeName;
            this.pile.push(string);
            this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + this.node(n) + "\", shape=circle, color=blue, style=filled]"));
        }
        this.currentNodeName = string;
    }

    public final void propagating(int n, IConstr iConstr) {
        String string = String.valueOf(this.currentNodeName) + "." + n;
        if (this.currentNodeName == null) {
            this.saveLine(this.lineTab("\"null\" [label=\"\", shape=point]"));
        }
        String string2 = this.estOrange ? "orange" : "green";
        this.saveLine(this.lineTab("\"" + string + "\"" + "[label=\"" + this.node(n) + "\",shape=point, color=black]"));
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\"" + " -- " + "\"" + string + "\"" + "[label=" + "\" " + this.node(n) + "\", fontcolor =" + string2 + ", color = " + string2 + ", style = bold]"));
        this.currentNodeName = string;
        this.estOrange = false;
    }

    public final void backtracking(int n) {
        String string = (String)this.pile.last();
        this.pile.pop();
        this.saveLine("\"" + string + "\"" + "--" + "\"" + this.currentNodeName + "\"" + "[label=\"\", color=red, style=dotted]");
        this.currentNodeName = string;
    }

    public final void adding(int n) {
        this.estOrange = true;
    }

    public final void learn(IConstr iConstr) {
    }

    public final void delete(int[] nArray) {
    }

    public final void conflictFound(IConstr iConstr, int n, int n2) {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"red\", style=filled]"));
    }

    public final void conflictFound(int n) {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"red\", style=filled]"));
    }

    public final void solutionFound() {
        this.saveLine(this.lineTab("\"" + this.currentNodeName + "\" [label=\"\", shape=box, color=\"green\", style=filled]"));
    }

    public final void beginLoop() {
    }

    public final void start() {
        this.saveLine("graph G {");
    }

    public final void end(Lbool lbool) {
        this.saveLine("}");
    }

    private final String lineTab(String string) {
        return "\t" + string;
    }

    private final void saveLine(String string) {
        try {
            this.out.write(String.valueOf(string) + '\n');
            if ("}".equals(string)) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.out = new PrintWriter(System.out);
    }

    public void restarting() {
    }

    public void backjump(int n) {
    }
}

