/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.SolverDecorator;

public class GateTranslator
extends SolverDecorator {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.GateTranslator");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public GateTranslator(ISolver iSolver) {
        super(iSolver);
    }

    public IConstr gateFalse(int n) throws ContradictionException {
        VecInt vecInt = new VecInt(2);
        vecInt.push(-n);
        return this.processClause(vecInt);
    }

    public IConstr gateTrue(int n) throws ContradictionException {
        VecInt vecInt = new VecInt(2);
        vecInt.push(n);
        return this.processClause(vecInt);
    }

    public IConstr[] ite(int n, int n2, int n3, int n4) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[6];
        VecInt vecInt = new VecInt(5);
        vecInt.push(-n).push(-n2).push(n3);
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n).push(n2).push(n4);
        iConstrArray[1] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n3).push(n);
        iConstrArray[2] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(-n4).push(n);
        iConstrArray[3] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n3).push(-n4).push(n);
        iConstrArray[4] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n).push(n3).push(n4);
        iConstrArray[5] = this.processClause(vecInt);
        return iConstrArray;
    }

    public IConstr[] and(int n, IVecInt iVecInt) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[iVecInt.size() + 1];
        VecInt vecInt = new VecInt(iVecInt.size() + 2);
        vecInt.push(n);
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            vecInt.push(-iVecInt.get(n2));
            ++n2;
        }
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        n2 = 0;
        while (n2 < iVecInt.size()) {
            vecInt.clear();
            vecInt.push(-n);
            vecInt.push(iVecInt.get(n2));
            iConstrArray[n2 + 1] = this.processClause(vecInt);
            ++n2;
        }
        return iConstrArray;
    }

    public IConstr[] and(int n, int n2, int n3) throws ContradictionException {
        VecInt vecInt = new VecInt(4);
        IConstr[] iConstrArray = new IConstr[3];
        vecInt.push(-n);
        vecInt.push(n2);
        iConstrArray[0] = this.addClause(vecInt);
        vecInt.clear();
        vecInt.push(-n);
        vecInt.push(n3);
        iConstrArray[1] = this.addClause(vecInt);
        vecInt.clear();
        vecInt.push(n);
        vecInt.push(-n2);
        vecInt.push(-n3);
        iConstrArray[2] = this.addClause(vecInt);
        return iConstrArray;
    }

    public IConstr[] or(int n, IVecInt iVecInt) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[iVecInt.size() + 1];
        VecInt vecInt = new VecInt(iVecInt.size() + 2);
        iVecInt.copyTo(vecInt);
        vecInt.push(-n);
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            vecInt.clear();
            vecInt.push(n);
            vecInt.push(-iVecInt.get(n2));
            iConstrArray[n2 + 1] = this.processClause(vecInt);
            ++n2;
        }
        return iConstrArray;
    }

    public IConstr[] halfOr(int n, IVecInt iVecInt) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[iVecInt.size()];
        VecInt vecInt = new VecInt(iVecInt.size() + 2);
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            vecInt.clear();
            vecInt.push(n);
            vecInt.push(-iVecInt.get(n2));
            iConstrArray[n2] = this.processClause(vecInt);
            ++n2;
        }
        return iConstrArray;
    }

    private IConstr processClause(IVecInt iVecInt) throws ContradictionException {
        return this.addClause(iVecInt);
    }

    public IConstr[] not(int n, int n2) throws ContradictionException {
        IConstr[] iConstrArray = new IConstr[2];
        VecInt vecInt = new VecInt(3);
        vecInt.push(-n).push(-n2);
        iConstrArray[0] = this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n).push(n2);
        iConstrArray[1] = this.processClause(vecInt);
        return iConstrArray;
    }

    public IConstr[] xor(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(-n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        Vec vec = new Vec();
        this.xor2Clause(nArray, 0, false, vec);
        Object[] objectArray = new IConstr[vec.size()];
        vec.copyTo(objectArray);
        return objectArray;
    }

    public IConstr[] iff(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        Vec vec = new Vec();
        this.iff2Clause(nArray, 0, false, vec);
        Object[] objectArray = new IConstr[vec.size()];
        vec.copyTo(objectArray);
        return objectArray;
    }

    public void xor(int n, int n2, int n3) throws ContradictionException {
        VecInt vecInt = new VecInt(3);
        vecInt.push(-n2).push(n3).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(-n3).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n3).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(n3).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
    }

    private void xor2Clause(int[] nArray, int n, boolean bl, IVec iVec) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length + 1);
            int n2 = 0;
            while (n2 < nArray.length - 1) {
                vecInt.push(nArray[n2]);
                ++n2;
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            iVec.push(this.processClause(vecInt));
            return;
        }
        if (bl) {
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true, iVec);
        } else {
            this.xor2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true, iVec);
            nArray[n] = -nArray[n];
        }
    }

    private void iff2Clause(int[] nArray, int n, boolean bl, IVec iVec) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length + 1);
            int n2 = 0;
            while (n2 < nArray.length - 1) {
                vecInt.push(nArray[n2]);
                ++n2;
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            this.processClause(vecInt);
            return;
        }
        if (bl) {
            this.iff2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true, iVec);
            nArray[n] = -nArray[n];
        } else {
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, false, iVec);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true, iVec);
        }
    }

    public void fullAdderSum(int n, int n2, int n3, int n4) throws ContradictionException {
        VecInt vecInt = new VecInt(4);
        vecInt.push(n2).push(n3).push(n4).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(-n3).push(-n4).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(n3).push(-n4).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n3).push(n4).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n3).push(-n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(n3).push(n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(-n3).push(n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(n3).push(-n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
    }

    public void fullAdderCarry(int n, int n2, int n3, int n4) throws ContradictionException {
        VecInt vecInt = new VecInt(3);
        vecInt.push(-n3).push(-n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n4).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n2).push(-n3).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n3).push(n4).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(n4).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n2).push(n3).push(-n);
        this.processClause(vecInt);
        vecInt.clear();
    }

    public void additionalFullAdderConstraints(int n, int n2, int n3, int n4, int n5) throws ContradictionException {
        VecInt vecInt = new VecInt(3);
        vecInt.push(-n).push(-n2).push(n3);
        this.processClause(vecInt);
        vecInt.push(-n).push(-n2).push(n4);
        this.processClause(vecInt);
        vecInt.push(-n).push(-n2).push(n5);
        this.processClause(vecInt);
        vecInt.push(n).push(n2).push(-n3);
        this.processClause(vecInt);
        vecInt.push(n).push(n2).push(-n4);
        this.processClause(vecInt);
        vecInt.push(n).push(n2).push(-n5);
        this.processClause(vecInt);
    }

    public void halfAdderSum(int n, int n2, int n3) throws ContradictionException {
        this.xor(n, n2, n3);
    }

    public void halfAdderCarry(int n, int n2, int n3) throws ContradictionException {
        this.and(n, n2, n3);
    }

    public void optimisationFunction(IVecInt iVecInt, IVec iVec, IVecInt iVecInt2) throws ContradictionException {
        IVecInt iVecInt3;
        int n;
        int n2;
        Vec vec = new Vec();
        int n3 = 0;
        while (n3 < iVecInt.size()) {
            n2 = iVecInt.get(n3);
            BigInteger bigInteger = (BigInteger)iVec.get(n3);
            n = 0;
            while (n < bigInteger.bitLength()) {
                iVecInt3 = this.createIfNull(vec, n);
                if (bigInteger.testBit(n)) {
                    iVecInt3.push(n2);
                }
                ++n;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < vec.size()) {
            int n5;
            iVecInt3 = (IVecInt)vec.get(n4);
            while (iVecInt3.size() >= 3) {
                n3 = iVecInt3.get(0);
                n2 = iVecInt3.get(1);
                int n6 = iVecInt3.get(2);
                iVecInt3.remove(n3);
                iVecInt3.remove(n2);
                iVecInt3.remove(n6);
                n = this.nextFreeVarId(true);
                n5 = this.nextFreeVarId(true);
                this.fullAdderSum(n, n3, n2, n6);
                this.fullAdderCarry(n5, n3, n2, n6);
                this.additionalFullAdderConstraints(n5, n, n3, n2, n6);
                iVecInt3.push(n);
                this.createIfNull(vec, n4 + 1).push(n5);
            }
            while (iVecInt3.size() == 2) {
                n3 = iVecInt3.get(0);
                n2 = iVecInt3.get(1);
                iVecInt3.remove(n3);
                iVecInt3.remove(n2);
                n = this.nextFreeVarId(true);
                n5 = this.nextFreeVarId(true);
                this.halfAdderSum(n, n3, n2);
                this.halfAdderCarry(n5, n3, n2);
                iVecInt3.push(n);
                this.createIfNull(vec, n4 + 1).push(n5);
            }
            if (!$assertionsDisabled && iVecInt3.size() != 1) {
                throw new AssertionError();
            }
            iVecInt2.push(iVecInt3.last());
            iVecInt3.pop();
            if (!$assertionsDisabled && !iVecInt3.isEmpty()) {
                throw new AssertionError();
            }
            ++n4;
        }
    }

    private IVecInt createIfNull(IVec iVec, int n) {
        IVecInt iVecInt = (IVecInt)iVec.get(n);
        if (iVecInt == null) {
            iVecInt = new VecInt();
            iVec.push(iVecInt);
            if (!$assertionsDisabled && iVec.get(n) != iVecInt) {
                throw new AssertionError();
            }
        }
        return iVecInt;
    }
}

