/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class LexicoDecorator
extends SolverDecorator
implements IOptimizationProblem {
    protected final List criteria = new ArrayList();
    protected int currentCriterion = 0;
    private IConstr prevConstr;
    private int currentValue = -1;
    protected int[] prevfullmodel;
    protected boolean[] prevboolmodel;
    private boolean isSolutionOptimal;
    private static final long serialVersionUID = 1L;

    public LexicoDecorator(ISolver iSolver) {
        super(iSolver);
    }

    public void addCriterion(IVecInt iVecInt) {
        VecInt vecInt = new VecInt(iVecInt.size());
        iVecInt.copyTo(vecInt);
        this.criteria.add(vecInt);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        this.isSolutionOptimal = false;
        if (this.decorated().isSatisfiable(iVecInt, true)) {
            this.prevboolmodel = new boolean[this.nVars()];
            int n = 0;
            while (n < this.nVars()) {
                this.prevboolmodel[n] = this.decorated().model(n + 1);
                ++n;
            }
            this.calculateObjective();
            this.prevfullmodel = this.decorated().model();
            return true;
        }
        return this.manageUnsatCase();
    }

    private boolean manageUnsatCase() {
        if (this.currentCriterion < this.criteria.size() - 1) {
            if (this.prevConstr != null) {
                super.removeConstr(this.prevConstr);
                this.prevConstr = null;
            }
            try {
                super.addAtMost((IVecInt)this.criteria.get(this.currentCriterion), this.currentValue);
                super.addAtLeast((IVecInt)this.criteria.get(this.currentCriterion), this.currentValue);
            }
            catch (ContradictionException contradictionException) {
                throw new IllegalStateException(contradictionException);
            }
            if (this.isVerbose()) {
                System.out.println(String.valueOf(this.getLogPrefix()) + "Found optimal criterion number " + (this.currentCriterion + 1));
            }
            ++this.currentCriterion;
            this.calculateObjective();
            return true;
        }
        if (this.isVerbose()) {
            System.out.println(String.valueOf(this.getLogPrefix()) + "Found optimal solution for the last criterion ");
        }
        this.isSolutionOptimal = true;
        if (this.prevConstr != null) {
            super.removeConstr(this.prevConstr);
            this.prevConstr = null;
        }
        return false;
    }

    public int[] model() {
        return this.prevfullmodel;
    }

    public boolean model(int n) {
        return this.prevboolmodel[n - 1];
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        this.currentValue = this.evaluate();
        return new Integer(this.currentValue);
    }

    public Number getObjectiveValue() {
        return new Integer(this.currentValue);
    }

    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    public void discardCurrentSolution() throws ContradictionException {
        block3: {
            if (this.prevConstr != null) {
                super.removeSubsumedConstr(this.prevConstr);
            }
            try {
                this.prevConstr = super.addAtMost((IVecInt)this.criteria.get(this.currentCriterion), this.currentValue - 1);
            }
            catch (ContradictionException contradictionException) {
                this.prevConstr = null;
                if (this.manageUnsatCase()) break block3;
                throw contradictionException;
            }
        }
    }

    private int evaluate() {
        int n = 0;
        IteratorInt iteratorInt = ((IVecInt)this.criteria.get(this.currentCriterion)).iterator();
        while (iteratorInt.hasNext()) {
            int n2 = iteratorInt.next();
            if ((n2 <= 0 || !this.prevboolmodel[n2 - 1]) && (n2 >= 0 || this.prevboolmodel[-n2 - 1])) continue;
            ++n;
        }
        return n;
    }

    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }
}

