/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.ConstrGroup;
import org.sat4j.tools.OutcomeListener;
import org.sat4j.tools.RunnableSolver;

public class ManyCore
implements ISolver,
OutcomeListener {
    private static final long MINIMAL_MEMORY_REQUIREMENT = 500000000L;
    private static final int NORMAL_SLEEP = 500;
    private static final int FAST_SLEEP = 50;
    private static final long serialVersionUID = 1L;
    private final String[] availableSolvers;
    protected final List solvers;
    protected final int numberOfSolvers;
    private int winnerId;
    private boolean resultFound;
    private volatile int remainingSolvers;
    private volatile int sleepTime;
    private volatile boolean solved;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.ManyCore");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ManyCore(ASolverFactory aSolverFactory, String[] stringArray) {
        this.availableSolvers = stringArray;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        int n = runtime.availableProcessors();
        this.numberOfSolvers = l > 500000000L ? (stringArray.length < n ? stringArray.length : n) : 1;
        this.solvers = new ArrayList(this.numberOfSolvers);
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            this.solvers.add(aSolverFactory.createSolverByName(this.availableSolvers[n2]));
            ++n2;
        }
    }

    public void addAllClauses(IVec iVec) throws ContradictionException {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).addAllClauses(iVec);
            ++n;
        }
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup();
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n2)).addAtLeast(iVecInt, n));
            ++n2;
        }
        return constrGroup;
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup();
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n2)).addAtMost(iVecInt, n));
            ++n2;
        }
        return constrGroup;
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup();
        int n = 0;
        while (n < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n)).addClause(iVecInt));
            ++n;
        }
        return constrGroup;
    }

    public void clearLearntClauses() {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).clearLearntClauses();
            ++n;
        }
    }

    public void expireTimeout() {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).expireTimeout();
            ++n;
        }
        this.sleepTime = 50;
    }

    public Map getStat() {
        return ((ISolver)this.solvers.get(this.winnerId)).getStat();
    }

    public int getTimeout() {
        return ((ISolver)this.solvers.get(0)).getTimeout();
    }

    public long getTimeoutMs() {
        return ((ISolver)this.solvers.get(0)).getTimeoutMs();
    }

    public int newVar() {
        throw new UnsupportedOperationException();
    }

    public int newVar(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numberOfSolvers) {
            n2 = ((ISolver)this.solvers.get(n3)).newVar(n);
            ++n3;
        }
        return n2;
    }

    public void printStat(PrintStream printStream, String string) {
        ((ISolver)this.solvers.get(this.winnerId)).printStat(printStream, string);
    }

    public void printStat(PrintWriter printWriter, String string) {
        ((ISolver)this.solvers.get(this.winnerId)).printStat(printWriter, string);
    }

    public boolean removeConstr(IConstr iConstr) {
        if (iConstr instanceof ConstrGroup) {
            ConstrGroup constrGroup = (ConstrGroup)iConstr;
            boolean bl = true;
            int n = 0;
            while (n < this.numberOfSolvers) {
                bl &= ((ISolver)this.solvers.get(n)).removeConstr(constrGroup.getConstr(n));
                ++n;
            }
            return bl;
        }
        throw new IllegalArgumentException("Can only remove a group of constraints!");
    }

    public void reset() {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).reset();
            ++n;
        }
    }

    public void setExpectedNumberOfClauses(int n) {
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n2)).setExpectedNumberOfClauses(n);
            ++n2;
        }
    }

    public void setTimeout(int n) {
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n2)).setTimeout(n);
            ++n2;
        }
    }

    public void setTimeoutMs(long l) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setTimeoutMs(l);
            ++n;
        }
    }

    public void setTimeoutOnConflicts(int n) {
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n2)).setTimeoutOnConflicts(n);
            ++n2;
        }
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("ManyCore solver with ");
        stringBuffer.append(this.numberOfSolvers);
        stringBuffer.append(" solvers running in parallel");
        stringBuffer.append("\n");
        int n = 0;
        while (n < this.numberOfSolvers) {
            stringBuffer.append(((ISolver)this.solvers.get(n)).toString(string));
            if (n < this.numberOfSolvers - 1) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public int[] findModel() throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, false);
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.remainingSolvers = this.numberOfSolvers;
        this.solved = false;
        int n = 0;
        while (n < this.numberOfSolvers) {
            new Thread(new RunnableSolver(n, (ISolver)this.solvers.get(n), iVecInt, bl, this)).start();
            ++n;
        }
        try {
            this.sleepTime = 500;
            do {
                Thread.sleep(this.sleepTime);
            } while (this.remainingSolvers > 0);
        }
        catch (InterruptedException interruptedException) {}
        if (!this.solved) {
            if (!$assertionsDisabled && this.remainingSolvers != 0) {
                throw new AssertionError();
            }
            throw new TimeoutException();
        }
        return this.resultFound;
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    public int[] model() {
        return ((ISolver)this.solvers.get(this.winnerId)).model();
    }

    public boolean model(int n) {
        return ((ISolver)this.solvers.get(this.winnerId)).model(n);
    }

    public int nConstraints() {
        return ((ISolver)this.solvers.get(0)).nConstraints();
    }

    public int nVars() {
        return ((ISolver)this.solvers.get(0)).nVars();
    }

    public void printInfos(PrintWriter printWriter, String string) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).printInfos(printWriter, string);
            ++n;
        }
    }

    public synchronized void onFinishWithAnswer(boolean bl, boolean bl2, int n) {
        if (bl && !this.solved) {
            this.winnerId = n;
            this.solved = true;
            this.resultFound = bl2;
            int n2 = 0;
            while (n2 < this.numberOfSolvers) {
                if (n2 != this.winnerId) {
                    ((ISolver)this.solvers.get(n2)).expireTimeout();
                }
                ++n2;
            }
            this.sleepTime = 50;
            System.out.println(String.valueOf(this.getLogPrefix()) + " And the winner is " + this.availableSolvers[this.winnerId]);
        }
        --this.remainingSolvers;
    }

    public boolean isDBSimplificationAllowed() {
        return ((ISolver)this.solvers.get(0)).isDBSimplificationAllowed();
    }

    public void setDBSimplificationAllowed(boolean bl) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(0)).setDBSimplificationAllowed(bl);
            ++n;
        }
    }

    public void setSearchListener(SearchListener searchListener) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setSearchListener(searchListener);
            ++n;
        }
    }

    public SearchListener getSearchListener() {
        return ((ISolver)this.solvers.get(0)).getSearchListener();
    }

    public int nextFreeVarId(boolean bl) {
        return ((ISolver)this.solvers.get(0)).nextFreeVarId(bl);
    }

    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n = 0;
        while (n < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n)).addBlockingClause(iVecInt));
            ++n;
        }
        return constrGroup;
    }

    public boolean removeSubsumedConstr(IConstr iConstr) {
        if (iConstr instanceof ConstrGroup) {
            ConstrGroup constrGroup = (ConstrGroup)iConstr;
            boolean bl = true;
            int n = 0;
            while (n < this.numberOfSolvers) {
                bl &= ((ISolver)this.solvers.get(n)).removeSubsumedConstr(constrGroup.getConstr(n));
                ++n;
            }
            return bl;
        }
        throw new IllegalArgumentException("Can only remove a group of constraints!");
    }

    public boolean isVerbose() {
        return ((ISolver)this.solvers.get(0)).isVerbose();
    }

    public void setVerbose(boolean bl) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setVerbose(bl);
            ++n;
        }
    }

    public void setLogPrefix(String string) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setLogPrefix(string);
            ++n;
        }
    }

    public String getLogPrefix() {
        return ((ISolver)this.solvers.get(0)).getLogPrefix();
    }

    public IVecInt unsatExplanation() {
        return ((ISolver)this.solvers.get(0)).unsatExplanation();
    }
}

