/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class ModelIterator
extends SolverDecorator {
    private static final long serialVersionUID = 1L;
    private boolean trivialfalsity = false;
    private final int bound;
    private int nbModelFound = 0;

    public ModelIterator(ISolver iSolver) {
        this(iSolver, Integer.MAX_VALUE);
    }

    public ModelIterator(ISolver iSolver, int n) {
        super(iSolver);
        this.bound = n;
    }

    public int[] model() {
        int[] nArray = super.model();
        ++this.nbModelFound;
        VecInt vecInt = new VecInt(nArray.length);
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            vecInt.push(-n3);
            ++n2;
        }
        try {
            this.addBlockingClause(vecInt);
        }
        catch (ContradictionException contradictionException) {
            this.trivialfalsity = true;
        }
        return nArray;
    }

    public boolean isSatisfiable() throws TimeoutException {
        if (this.trivialfalsity || this.nbModelFound >= this.bound) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(true);
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        if (this.trivialfalsity || this.nbModelFound >= this.bound) {
            return false;
        }
        this.trivialfalsity = false;
        return super.isSatisfiable(iVecInt, true);
    }

    public void reset() {
        this.trivialfalsity = false;
        this.nbModelFound = 0;
        super.reset();
    }
}

