/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.DeletionStrategy;
import org.sat4j.tools.xplain.Explainer;
import org.sat4j.tools.xplain.MinimizationStrategy;

public class HighLevelXplain
extends SolverDecorator
implements Explainer {
    protected Map constrs = new HashMap();
    protected IVecInt assump;
    private int lastCreatedVar;
    private boolean pooledVarId = false;
    private MinimizationStrategy xplainStrategy = new DeletionStrategy();
    private final Map highLevelToVar = new HashMap();
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.xplain.HighLevelXplain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public HighLevelXplain(ISolver iSolver) {
        super(iSolver);
    }

    public IConstr addClause(IVecInt iVecInt, int n) throws ContradictionException {
        if (n == 0) {
            return this.addClause(iVecInt);
        }
        Integer n2 = (Integer)this.highLevelToVar.get(new Integer(n));
        if (n2 == null) {
            n2 = new Integer(this.createNewVar(iVecInt));
            this.highLevelToVar.put(new Integer(n), n2);
            this.constrs.put(n2, new Integer(n));
        }
        iVecInt.push(n2);
        IConstr iConstr = super.addClause(iVecInt);
        return iConstr;
    }

    protected int createNewVar(IVecInt iVecInt) {
        if (this.pooledVarId) {
            this.pooledVarId = false;
            return this.lastCreatedVar;
        }
        this.lastCreatedVar = this.nextFreeVarId(true);
        return this.lastCreatedVar;
    }

    protected void discardLastestVar() {
        this.pooledVarId = true;
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    private IVecInt explanationKeys() throws TimeoutException {
        if (!$assertionsDisabled && this.isSatisfiable(this.assump)) {
            throw new AssertionError();
        }
        ISolver iSolver = this.decorated();
        if (iSolver instanceof SolverDecorator) {
            iSolver = ((SolverDecorator)iSolver).decorated();
        }
        return this.xplainStrategy.explain(iSolver, this.constrs, this.assump);
    }

    public int[] minimalExplanation() throws TimeoutException {
        Collection collection = this.explain();
        int[] nArray = new int[collection.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            nArray[n++] = n2;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    public Collection explain() throws TimeoutException {
        IVecInt iVecInt = this.explanationKeys();
        HashSet<Integer> hashSet = new HashSet<Integer>(iVecInt.size());
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            hashSet.add((Integer)this.constrs.get(new Integer(iteratorInt.next())));
        }
        return hashSet;
    }

    public void cancelExplanation() {
        this.xplainStrategy.cancelExplanationComputation();
    }

    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    public int[] model() {
        int[] nArray = super.model();
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length - this.constrs.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (this.constrs.get(new Integer(Math.abs(nArray[n2]))) == null) {
                nArray2[n++] = nArray[n2];
            }
            ++n2;
        }
        return nArray2;
    }

    public String toString(String string) {
        System.out.println(String.valueOf(string) + "High Level Explanation (MUS) enabled solver");
        System.out.println(String.valueOf(string) + this.xplainStrategy);
        return super.toString(string);
    }

    public void setMinimizationStrategy(MinimizationStrategy minimizationStrategy) {
        this.xplainStrategy = minimizationStrategy;
    }
}

