/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.Explainer;
import org.sat4j.tools.xplain.MinimizationStrategy;
import org.sat4j.tools.xplain.QuickXplainStrategy;

public class Xplain
extends SolverDecorator
implements Explainer {
    protected Map constrs = new HashMap();
    protected IVecInt assump;
    private int lastCreatedVar;
    private boolean pooledVarId = false;
    private final IVecInt lastClause = new VecInt();
    private MinimizationStrategy xplainStrategy = new QuickXplainStrategy();
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.tools.xplain.Xplain");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Xplain(ISolver iSolver) {
        super(iSolver);
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        if (iVecInt.equals(this.lastClause)) {
            return null;
        }
        this.lastClause.clear();
        iVecInt.copyTo(this.lastClause);
        int n = this.createNewVar(iVecInt);
        iVecInt.push(n);
        IConstr iConstr = super.addClause(iVecInt);
        if (iConstr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(new Integer(n), iConstr);
        }
        return iConstr;
    }

    protected int createNewVar(IVecInt iVecInt) {
        if (this.pooledVarId) {
            this.pooledVarId = false;
            return this.lastCreatedVar;
        }
        this.lastCreatedVar = this.nextFreeVarId(true);
        return this.lastCreatedVar;
    }

    protected void discardLastestVar() {
        this.pooledVarId = true;
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    private IVecInt explanationKeys() throws TimeoutException {
        if (!$assertionsDisabled && this.isSatisfiable(this.assump)) {
            throw new AssertionError();
        }
        ISolver iSolver = this.decorated();
        if (iSolver instanceof SolverDecorator) {
            iSolver = ((SolverDecorator)iSolver).decorated();
        }
        return this.xplainStrategy.explain(iSolver, this.constrs, this.assump);
    }

    public int[] minimalExplanation() throws TimeoutException {
        IVecInt iVecInt = this.explanationKeys();
        iVecInt.sort();
        ArrayList arrayList = new ArrayList(this.constrs.keySet());
        Collections.sort(arrayList);
        int[] nArray = new int[iVecInt.size()];
        int n = 0;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            nArray[n++] = arrayList.indexOf(new Integer(iteratorInt.next())) + 1;
        }
        return nArray;
    }

    public Collection explain() throws TimeoutException {
        IVecInt iVecInt = this.explanationKeys();
        ArrayList<IConstr> arrayList = new ArrayList<IConstr>(iVecInt.size());
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            arrayList.add((IConstr)this.constrs.get(new Integer(iteratorInt.next())));
        }
        return arrayList;
    }

    public void cancelExplanation() {
        this.xplainStrategy.cancelExplanationComputation();
    }

    public Collection getConstraints() {
        return this.constrs.values();
    }

    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.findModel(vecInt);
    }

    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        VecInt vecInt = new VecInt();
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt);
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.assump = iVecInt;
        VecInt vecInt = new VecInt();
        iVecInt.copyTo(vecInt);
        Iterator iterator = this.constrs.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            vecInt.push(-n.intValue());
        }
        return super.isSatisfiable(vecInt, bl);
    }

    public int[] model() {
        int[] nArray = super.model();
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length - this.constrs.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (this.constrs.get(new Integer(Math.abs(nArray[n2]))) == null) {
                nArray2[n++] = nArray[n2];
            }
            ++n2;
        }
        return nArray2;
    }

    public String toString(String string) {
        System.out.println(String.valueOf(string) + "Explanation (MUS) enabled solver");
        System.out.println(String.valueOf(string) + this.xplainStrategy);
        return super.toString(string);
    }

    public void setMinimizationStrategy(MinimizationStrategy minimizationStrategy) {
        this.xplainStrategy = minimizationStrategy;
    }
}

