/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.ConflictTimerContainer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Counter;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.ICDCLLogger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.ISimplifier;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.VoidTracing;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver<D extends DataStructureFactory>
implements ISolverService,
ICDCL<D> {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    protected ICDCLLogger out;
    protected final IVec<Constr> constrs = new Vec<Constr>();
    protected final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected ILits voc;
    private IOrder order;
    private final ActivityComparator comparator = new ActivityComparator();
    private SolverStats stats = new SolverStats();
    private LearningStrategy<D> learner;
    protected volatile boolean undertimeout;
    private long timeout = Integer.MAX_VALUE;
    private boolean timeBasedTimeout = true;
    protected D dsfactory;
    private SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    protected SearchListener slistener = new VoidTracing();
    private RestartStrategy restarter;
    private final Map<String, Counter> constrTypes = new HashMap<String, Counter>();
    private boolean isDBSimplificationAllowed = false;
    private final IVecInt learnedLiterals = new VecInt();
    private boolean verbose = false;
    private boolean keepHot = false;
    private String prefix = "c ";
    private int declaredMaxVarId = 0;
    private boolean[] mseen = new boolean[0];
    private final IVecInt mpreason = new VecInt();
    private final IVecInt moutLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
        }

        public String toString() {
            return "No reason simplification";
        }
    };
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.simpleSimplification(iVecInt);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.expensiveSimplification(iVecInt);
        }

        public String toString() {
            return "Expensive reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION_WLONLY = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.expensiveSimplificationWLOnly(iVecInt);
        }

        public String toString() {
            return "Expensive reason simplification specific for WL data structure";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final IVecInt analyzetoclear = new VecInt();
    private final IVecInt analyzestack = new VecInt();
    private final IVec<Propagatable> watched = new Vec<Propagatable>();
    private final Pair analysisResult = new Pair();
    private boolean[] userbooleanmodel;
    private IVecInt unsatExplanationInTermsOfAssumptions;
    private final IVecInt implied = new VecInt();
    private final IVecInt decisions = new VecInt();
    private int[] fullmodel;
    private int[] prime;
    private double timebegin = 0.0;
    private boolean needToReduceDB;
    private ConflictTimerContainer conflictCount;
    private transient Timer timer;
    private final ConflictTimer memoryTimer = new ConflictTimerAdapter(500){
        private static final long serialVersionUID = 1L;
        final long memorybound;
        {
            this.memorybound = Runtime.getRuntime().freeMemory() / 10L;
        }

        public void run() {
            long l = Runtime.getRuntime().freeMemory();
            if (l < this.memorybound) {
                Solver.this.needToReduceDB = true;
            }
        }
    };
    public final LearnedConstraintsDeletionStrategy memory_based = this.activityBased(this.memoryTimer);
    private final ConflictTimer lbdTimer = new ConflictTimerAdapter(1000){
        private static final long serialVersionUID = 1L;
        private int nbconflict;
        private static final int MAX_CLAUSE = 5000;
        private static final int INC_CLAUSE = 1000;
        private int nextbound;
        {
            this.nbconflict = 0;
            this.nextbound = 5000;
        }

        public void run() {
            this.nbconflict += this.bound();
            if (this.nbconflict >= this.nextbound) {
                this.nextbound += 1000;
                this.nbconflict = 0;
                Solver.this.needToReduceDB = true;
            }
        }

        public void reset() {
            super.reset();
            this.nextbound = 5000;
            if (this.nbconflict >= this.nextbound) {
                this.nbconflict = 0;
                Solver.this.needToReduceDB = true;
            }
        }
    };
    public final LearnedConstraintsDeletionStrategy glucose;
    protected LearnedConstraintsDeletionStrategy learnedConstraintsDeletionStrategy = this.glucose = new Glucose2LCDS(this.lbdTimer);
    private boolean lastConflictMeansUnsat;
    private Constr sharedConflict;

    protected IVecInt dimacs2internal(IVecInt iVecInt) {
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(iVecInt.size());
        for (int i = 0; i < iVecInt.size(); ++i) {
            int n = iVecInt.get(i);
            if (n == 0) {
                throw new IllegalArgumentException("0 is not a valid variable identifier");
            }
            this.__dimacs_out.unsafePush(this.voc.getFromPool(n));
        }
        return this.__dimacs_out;
    }

    @Override
    public void registerLiteral(int n) {
        this.voc.getFromPool(n);
    }

    public Solver(LearningStrategy<D> learningStrategy, D d, IOrder iOrder, RestartStrategy restartStrategy) {
        this(learningStrategy, d, new SearchParams(), iOrder, restartStrategy);
    }

    public Solver(LearningStrategy<D> learningStrategy, D d, SearchParams searchParams, IOrder iOrder, RestartStrategy restartStrategy) {
        this(learningStrategy, d, searchParams, iOrder, restartStrategy, ICDCLLogger.CONSOLE);
    }

    public Solver(LearningStrategy<D> learningStrategy, D d, SearchParams searchParams, IOrder iOrder, RestartStrategy restartStrategy, ICDCLLogger iCDCLLogger) {
        this.learner = learningStrategy;
        this.order = iOrder;
        this.params = searchParams;
        this.setDataStructureFactory(d);
        this.restarter = restartStrategy;
        this.out = iCDCLLogger;
    }

    @Override
    public final void setDataStructureFactory(D d) {
        this.dsfactory = d;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.voc = d.getVocabulary();
        this.order.setLits(this.voc);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public <S extends ISolverService> void setSearchListener(SearchListener<S> searchListener) {
        this.slistener = searchListener;
    }

    @Override
    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        return this.slistener;
    }

    @Override
    public void setLearner(LearningStrategy<D> learningStrategy) {
        this.learner = learningStrategy;
    }

    @Override
    public void setTimeout(int n) {
        this.timeout = (long)n * 1000L;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutMs(long l) {
        this.timeout = l;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
        this.timeout = n;
        this.timeBasedTimeout = false;
    }

    @Override
    public void setSearchParams(SearchParams searchParams) {
        this.params = searchParams;
    }

    @Override
    public void setRestartStrategy(RestartStrategy restartStrategy) {
        this.restarter = restartStrategy;
    }

    @Override
    public RestartStrategy getRestartStrategy() {
        return this.restarter;
    }

    @Override
    public void expireTimeout() {
        this.undertimeout = false;
        if (this.timeBasedTimeout) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        } else if (this.conflictCount != null) {
            this.conflictCount = null;
        }
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size();
    }

    @Override
    public void learn(Constr constr) {
        this.slistener.learn(constr);
        this.learnts.push(constr);
        constr.setLearnt();
        constr.register();
        ++this.stats.learnedclauses;
        switch (constr.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
                break;
            }
        }
    }

    public final int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    @Deprecated
    public int newVar() {
        int n = this.voc.nVars() + 1;
        this.voc.ensurePool(n);
        return n;
    }

    @Override
    public int newVar(int n) {
        this.voc.ensurePool(n);
        this.declaredMaxVarId = n;
        return n;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createClause(iVecInt2));
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        if (iConstr == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        Constr constr = (Constr)iConstr;
        constr.remove(this);
        this.constrs.remove(constr);
        this.clearLearntClauses();
        String string = constr.getClass().getName();
        this.constrTypes.get(string).dec();
        return true;
    }

    @Override
    public boolean removeSubsumedConstr(IConstr iConstr) {
        if (iConstr == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        if (this.constrs.last() != iConstr) {
            throw new IllegalArgumentException("Can only remove latest added constraint!!!");
        }
        Constr constr = (Constr)iConstr;
        constr.remove(this);
        this.constrs.pop();
        String string = constr.getClass().getName();
        this.constrTypes.get(string).dec();
        return true;
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        Iterator<IVecInt> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            this.addClause(iterator.next());
        }
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        int n2 = iVecInt.size();
        VecInt vecInt = new VecInt(n2);
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            vecInt.push(-iteratorInt.next());
        }
        return this.addAtLeast(vecInt, n2 - n);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(iVecInt2, n));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        constrGroup.add(this.addAtMost(iVecInt, n));
        constrGroup.add(this.addAtLeast(iVecInt, n));
        return constrGroup;
    }

    public boolean simplifyDB() {
        IVec[] iVecArray = new IVec[]{this.constrs, this.learnts};
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (int j = 0; j < iVecArray[i].size(); ++j) {
                if (((Constr)iVecArray[i].get(j)).simplify()) {
                    ((Constr)iVecArray[i].get(j)).remove(this);
                    continue;
                }
                iVecArray[i].moveTo(n++, j);
            }
            iVecArray[i].shrinkTo(n);
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nArray = new int[this.model.length];
        System.arraycopy(this.model, 0, nArray, 0, this.model.length);
        return nArray;
    }

    @Override
    public boolean enqueue(int n) {
        return this.enqueue(n, null);
    }

    @Override
    public boolean enqueue(int n, Constr constr) {
        assert (n > 1);
        if (this.voc.isSatisfied(n)) {
            return true;
        }
        if (this.voc.isFalsified(n)) {
            return false;
        }
        this.voc.satisfies(n);
        this.voc.setLevel(n, this.decisionLevel());
        this.voc.setReason(n, constr);
        this.trail.push(n);
        if (constr != null && constr.learnt()) {
            this.learnedConstraintsDeletionStrategy.onPropagation(constr);
        }
        return true;
    }

    public void analyze(Constr constr, Pair pair) throws TimeoutException {
        int n;
        assert (constr != null);
        boolean[] blArray = this.mseen;
        IVecInt iVecInt = this.moutLearnt;
        IVecInt iVecInt2 = this.mpreason;
        iVecInt.clear();
        assert (iVecInt.size() == 0);
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        n = 0;
        int n2 = -1;
        iVecInt.push(-1);
        int n3 = 0;
        Constr constr2 = null;
        do {
            iVecInt2.clear();
            assert (constr != null);
            if (constr2 != constr) {
                constr.calcReason(n2, iVecInt2);
                this.learnedConstraintsDeletionStrategy.onConflictAnalysis(constr);
                for (int i = 0; i < iVecInt2.size(); ++i) {
                    int n4 = iVecInt2.get(i);
                    this.order.updateVar(n4);
                    if (blArray[n4 >> 1]) continue;
                    blArray[n4 >> 1] = true;
                    if (this.voc.getLevel(n4) == this.decisionLevel()) {
                        ++n;
                        this.order.updateVarAtDecisionLevel(n4);
                        continue;
                    }
                    if (this.voc.getLevel(n4) <= 0) continue;
                    iVecInt.push(n4 ^ 1);
                    n3 = Math.max(n3, this.voc.getLevel(n4));
                }
            }
            constr2 = constr;
            do {
                n2 = this.trail.last();
                constr = this.voc.getReason(n2);
                this.undoOne();
            } while (!blArray[n2 >> 1]);
        } while (--n > 0);
        iVecInt.set(0, n2 ^ 1);
        this.simplifier.simplify(iVecInt);
        Constr constr3 = this.dsfactory.createUnregisteredClause(iVecInt);
        this.learnedConstraintsDeletionStrategy.onClauseLearning(constr3);
        pair.reason = constr3;
        assert (n3 > -1);
        pair.backtrackLevel = n3;
    }

    public IVecInt analyzeFinalConflictInTermsOfAssumptions(Constr constr, IVecInt iVecInt, int n) {
        int n2;
        if (iVecInt.size() == 0) {
            return null;
        }
        while (!this.trailLim.isEmpty() && this.trailLim.last() == this.trail.size()) {
            this.trailLim.pop();
        }
        boolean[] blArray = this.mseen;
        IVecInt iVecInt2 = this.moutLearnt;
        IVecInt iVecInt3 = this.mpreason;
        iVecInt2.clear();
        if (this.trailLim.size() == 0) {
            return iVecInt2;
        }
        assert (iVecInt2.size() == 0);
        for (n2 = 0; n2 < blArray.length; ++n2) {
            blArray[n2] = false;
        }
        if (constr == null) {
            blArray[n >> 1] = true;
        }
        n2 = -1;
        while (constr == null && this.trail.size() > 0 && this.trailLim.size() > 0) {
            n2 = this.trail.last();
            constr = this.voc.getReason(n2);
            this.undoOne();
            if (constr == null && n2 == (n ^ 1)) {
                iVecInt2.push(LiteralsUtils.toDimacs(n2));
            }
            if (this.trail.size() > this.trailLim.last()) continue;
            this.trailLim.pop();
        }
        if (constr == null) {
            return iVecInt2;
        }
        do {
            iVecInt3.clear();
            constr.calcReason(n2, iVecInt3);
            for (int i = 0; i < iVecInt3.size(); ++i) {
                int n3 = iVecInt3.get(i);
                if (blArray[n3 >> 1]) continue;
                blArray[n3 >> 1] = true;
                if (this.voc.getReason(n3) != null || this.voc.getLevel(n3) <= 0) continue;
                assert (iVecInt.contains(LiteralsUtils.toDimacs(n3)));
                iVecInt2.push(LiteralsUtils.toDimacs(n3));
            }
            do {
                n2 = this.trail.last();
                constr = this.voc.getReason(n2);
                this.undoOne();
                if (this.decisionLevel() <= 0 || this.trail.size() > this.trailLim.last()) continue;
                this.trailLim.pop();
            } while (this.trail.size() > 0 && this.decisionLevel() > 0 && (!blArray[n2 >> 1] || constr == null));
        } while (this.decisionLevel() > 0);
        return iVecInt2;
    }

    @Override
    public void setSimplifier(SimplificationType simplificationType) {
        try {
            Field field = Solver.class.getDeclaredField(simplificationType.toString());
            this.simplifier = (ISimplifier)field.get(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.simplifier = NO_SIMPLIFICATION;
        }
    }

    @Override
    public void setSimplifier(ISimplifier iSimplifier) {
        this.simplifier = iSimplifier;
    }

    @Override
    public ISimplifier getSimplifier() {
        return this.simplifier;
    }

    private void simpleSimplification(IVecInt iVecInt) {
        int n;
        boolean[] blArray = this.mseen;
        int n2 = 1;
        block0: for (n = 1; n < iVecInt.size(); ++n) {
            Constr constr = this.voc.getReason(iVecInt.get(n));
            if (constr == null || constr.canBePropagatedMultipleTimes()) {
                iVecInt.moveTo(n2++, n);
                continue;
            }
            for (int i = 0; i < constr.size(); ++i) {
                int n3 = constr.get(i);
                if (blArray[n3 >> 1] || !this.voc.isFalsified(n3) || this.voc.getLevel(n3) == 0) continue;
                iVecInt.moveTo(n2++, n);
                continue block0;
            }
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    private void expensiveSimplification(IVecInt iVecInt) {
        int n;
        this.analyzetoclear.clear();
        iVecInt.copyTo(this.analyzetoclear);
        int n2 = 1;
        for (n = 1; n < iVecInt.size(); ++n) {
            if (this.voc.getReason(iVecInt.get(n)) != null && this.analyzeRemovable(iVecInt.get(n))) continue;
            iVecInt.moveTo(n2++, n);
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    private boolean analyzeRemovable(int n) {
        assert (this.voc.getReason(n) != null);
        ILits iLits = this.voc;
        IVecInt iVecInt = this.analyzestack;
        IVecInt iVecInt2 = this.analyzetoclear;
        iVecInt.clear();
        iVecInt.push(n);
        boolean[] blArray = this.mseen;
        int n2 = iVecInt2.size();
        while (iVecInt.size() > 0) {
            int n3;
            int n4 = iVecInt.last();
            assert (iLits.getReason(n4) != null);
            Constr constr = iLits.getReason(n4);
            iVecInt.pop();
            if (constr.canBePropagatedMultipleTimes()) {
                for (n3 = n2; n3 < iVecInt2.size(); ++n3) {
                    blArray[iVecInt2.get((int)n3) >> 1] = false;
                }
                iVecInt2.shrink(iVecInt2.size() - n2);
                return false;
            }
            for (n3 = 0; n3 < constr.size(); ++n3) {
                int n5 = constr.get(n3);
                if (blArray[LiteralsUtils.var(n5)] || !iLits.isFalsified(n5) || iLits.getLevel(n5) == 0) continue;
                if (iLits.getReason(n5) == null) {
                    for (int i = n2; i < iVecInt2.size(); ++i) {
                        blArray[iVecInt2.get((int)i) >> 1] = false;
                    }
                    iVecInt2.shrink(iVecInt2.size() - n2);
                    return false;
                }
                blArray[n5 >> 1] = true;
                iVecInt.push(n5);
                iVecInt2.push(n5);
            }
        }
        return true;
    }

    private void expensiveSimplificationWLOnly(IVecInt iVecInt) {
        int n;
        this.analyzetoclear.clear();
        iVecInt.copyTo(this.analyzetoclear);
        int n2 = 1;
        for (n = 1; n < iVecInt.size(); ++n) {
            if (this.voc.getReason(iVecInt.get(n)) != null && this.analyzeRemovableWLOnly(iVecInt.get(n))) continue;
            iVecInt.moveTo(n2++, n);
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    private boolean analyzeRemovableWLOnly(int n) {
        assert (this.voc.getReason(n) != null);
        this.analyzestack.clear();
        this.analyzestack.push(n);
        boolean[] blArray = this.mseen;
        int n2 = this.analyzetoclear.size();
        while (this.analyzestack.size() > 0) {
            int n3 = this.analyzestack.last();
            assert (this.voc.getReason(n3) != null);
            Constr constr = this.voc.getReason(n3);
            this.analyzestack.pop();
            for (int i = 1; i < constr.size(); ++i) {
                int n4 = constr.get(i);
                if (blArray[LiteralsUtils.var(n4)] || this.voc.getLevel(n4) == 0) continue;
                if (this.voc.getReason(n4) == null) {
                    for (int j = n2; j < this.analyzetoclear.size(); ++j) {
                        blArray[this.analyzetoclear.get((int)j) >> 1] = false;
                    }
                    this.analyzetoclear.shrink(this.analyzetoclear.size() - n2);
                    return false;
                }
                blArray[n4 >> 1] = true;
                this.analyzestack.push(n4);
                this.analyzetoclear.push(n4);
            }
        }
        return true;
    }

    protected void undoOne() {
        int n = this.trail.last();
        assert (n > 1);
        assert (this.voc.getLevel(n) >= 0);
        int n2 = n >> 1;
        this.voc.unassign(n);
        this.voc.setReason(n, null);
        this.voc.setLevel(n, -1);
        this.order.undo(n2);
        this.trail.pop();
        IVec<Undoable> iVec = this.voc.undos(n);
        assert (iVec != null);
        for (int i = iVec.size(); i > 0; --i) {
            iVec.last().undo(n);
            iVec.pop();
        }
    }

    @Override
    public void claBumpActivity(Constr constr) {
        constr.incActivity(this.claInc);
        if (constr.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int n) {
        this.order.updateVar(n);
    }

    private void claRescalActivity() {
        for (int i = 0; i < this.learnts.size(); ++i) {
            this.learnts.get(i).rescaleBy(1.0E-20);
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        IVecInt iVecInt = this.trail;
        ILits iLits = this.voc;
        SolverStats solverStats = this.stats;
        IOrder iOrder = this.order;
        SearchListener searchListener = this.slistener;
        while (this.qhead < iVecInt.size()) {
            ++solverStats.propagations;
            int n = iVecInt.get(this.qhead++);
            searchListener.propagating(LiteralsUtils.toDimacs(n), null);
            iOrder.assignLiteral(n);
            Constr constr = this.reduceClausesForFalsifiedLiteral(n);
            if (constr == null) continue;
            return constr;
        }
        return null;
    }

    private Constr reduceClausesForFalsifiedLiteral(int n) {
        assert (n > 1);
        IVec<Propagatable> iVec = this.watched;
        iVec.clear();
        this.voc.watches(n).moveTo(iVec);
        int n2 = iVec.size();
        for (int i = 0; i < n2; ++i) {
            ++this.stats.inspects;
            if (iVec.get(i).propagate(this, n)) continue;
            int n3 = iVec.size();
            for (int j = i + 1; j < n3; ++j) {
                this.voc.watch(n, iVec.get(j));
            }
            this.qhead = this.trail.size();
            return iVec.get(i).toConstraint();
        }
        return null;
    }

    void record(Constr constr) {
        constr.assertConstraint(this);
        this.slistener.adding(LiteralsUtils.toDimacs(constr.get(0)));
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int n) {
        assert (this.trail.size() == this.qhead);
        assert (!this.trailLim.contains(this.trail.size()));
        this.trailLim.push(this.trail.size());
        return this.enqueue(n);
    }

    private void cancel() {
        int n = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(LiteralsUtils.toDimacs(n));
        for (int i = this.trail.size() - this.trailLim.last(); i > 0; --i) {
            this.undoOne();
        }
        this.trailLim.pop();
        this.qhead = this.trail.size();
    }

    private void cancelLearntLiterals(int n) {
        this.learnedLiterals.clear();
        while (this.trail.size() > n) {
            this.learnedLiterals.push(this.trail.last());
            this.undoOne();
        }
    }

    protected void cancelUntil(int n) {
        while (this.decisionLevel() > n) {
            this.cancel();
        }
    }

    Lbool search(IVecInt iVecInt) {
        assert (this.rootLevel == this.decisionLevel());
        ++this.stats.starts;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            int n;
            this.slistener.beginLoop();
            Constr constr = this.propagate();
            assert (this.trail.size() == this.qhead);
            if (constr == null) {
                if (this.decisionLevel() == 0 && this.isDBSimplificationAllowed) {
                    ++this.stats.rootSimplifications;
                    n = this.simplifyDB();
                    assert (n != 0);
                }
                assert (this.nAssigns() <= this.voc.realnVars());
                if (this.nAssigns() == this.voc.realnVars()) {
                    this.modelFound();
                    this.slistener.solutionFound(this.model);
                    if (this.sharedConflict == null) {
                        this.cancelUntil(this.rootLevel);
                        return Lbool.TRUE;
                    }
                    constr = this.sharedConflict;
                    this.sharedConflict = null;
                } else {
                    if (this.restarter.shouldRestart()) {
                        this.cancelUntil(this.rootLevel);
                        return Lbool.UNDEFINED;
                    }
                    if (this.needToReduceDB) {
                        this.reduceDB();
                        this.needToReduceDB = false;
                    }
                    if (this.sharedConflict == null) {
                        ++this.stats.decisions;
                        n = this.order.select();
                        if (n == -1) {
                            constr = this.preventTheSameDecisionsToBeMade();
                            this.lastConflictMeansUnsat = false;
                        } else {
                            assert (n > 1);
                            this.slistener.assuming(LiteralsUtils.toDimacs(n));
                            boolean bl = this.assume(n);
                            assert (bl);
                        }
                    } else {
                        constr = this.sharedConflict;
                        this.sharedConflict = null;
                    }
                }
            }
            if (constr == null) continue;
            ++this.stats.conflicts;
            this.slistener.conflictFound(constr, this.decisionLevel(), this.trail.size());
            this.conflictCount.newConflict();
            if (this.decisionLevel() == this.rootLevel) {
                if (this.lastConflictMeansUnsat) {
                    this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(constr, iVecInt, -1);
                    return Lbool.FALSE;
                }
                return Lbool.UNDEFINED;
            }
            n = this.trail.size();
            try {
                this.analyze(constr, this.analysisResult);
            }
            catch (TimeoutException timeoutException) {
                return Lbool.UNDEFINED;
            }
            assert (this.analysisResult.backtrackLevel < this.decisionLevel());
            int n2 = Math.max(this.analysisResult.backtrackLevel, this.rootLevel);
            this.slistener.backjump(n2);
            this.cancelUntil(n2);
            if (n2 == this.rootLevel) {
                this.restarter.onBackjumpToRootLevel();
            }
            assert (this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= this.analysisResult.backtrackLevel);
            if (this.analysisResult.reason == null) {
                return Lbool.FALSE;
            }
            this.record(this.analysisResult.reason);
            this.restarter.newLearnedClause(this.analysisResult.reason, n);
            this.analysisResult.reason = null;
            this.decayActivities();
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    private Constr preventTheSameDecisionsToBeMade() {
        VecInt vecInt = new VecInt(this.nVars());
        for (int i = this.trail.size() - 1; i >= this.rootLevel; --i) {
            int n = this.trail.get(i);
            if (this.voc.getReason(n) != null) continue;
            vecInt.push(n ^ 1);
        }
        return this.dsfactory.createUnregisteredClause(vecInt);
    }

    protected void analyzeAtRootLevel(Constr constr) {
    }

    void modelFound() {
        int n;
        int n2;
        VecInt vecInt = new VecInt(this.nVars());
        this.userbooleanmodel = new boolean[this.realNumberOfVariables()];
        this.fullmodel = null;
        for (n2 = 1; n2 <= this.nVars(); ++n2) {
            if (!this.voc.belongsToPool(n2) || this.voc.isUnassigned(n = this.voc.getFromPool(n2))) continue;
            vecInt.push(this.voc.isSatisfied(n) ? n2 : -n2);
            this.userbooleanmodel[n2 - 1] = this.voc.isSatisfied(n);
            if (this.voc.getReason(n) == null) {
                this.decisions.push(vecInt.last());
                continue;
            }
            this.implied.push(vecInt.last());
        }
        this.model = new int[vecInt.size()];
        vecInt.copyTo(this.model);
        if (this.realNumberOfVariables() > this.nVars()) {
            for (n2 = this.nVars() + 1; n2 <= this.realNumberOfVariables(); ++n2) {
                if (!this.voc.belongsToPool(n2) || this.voc.isUnassigned(n = this.voc.getFromPool(n2))) continue;
                vecInt.push(this.voc.isSatisfied(n) ? n2 : -n2);
                this.userbooleanmodel[n2 - 1] = this.voc.isSatisfied(n);
                if (this.voc.getReason(n) == null) {
                    this.decisions.push(vecInt.last());
                    continue;
                }
                this.implied.push(vecInt.last());
            }
            this.fullmodel = new int[vecInt.size()];
            vecInt.moveTo(this.fullmodel);
        }
    }

    private Constr forget(int n) {
        this.voc.forgets(n);
        Constr constr = this.reduceClausesForFalsifiedLiteral(LiteralsUtils.toInternal(n));
        if (constr != null) {
            return constr;
        }
        constr = this.reduceClausesForFalsifiedLiteral(LiteralsUtils.toInternal(-n));
        return constr;
    }

    private boolean setAndPropagate(int n) {
        return this.assume(n) && this.propagate() == null;
    }

    @Override
    public int[] primeImplicant() {
        int n;
        assert (this.qhead == this.trail.size() || this.qhead == this.learnedLiterals.size());
        if (this.learnedLiterals.size() > 0) {
            this.qhead = 0;
        }
        this.prime = new int[this.implied.size() + this.decisions.size() + 1];
        for (int i = 0; i < this.prime.length; ++i) {
            this.prime[i] = 0;
        }
        IteratorInt iteratorInt = this.implied.iterator();
        while (iteratorInt.hasNext()) {
            int n2;
            this.prime[Math.abs((int)n2)] = n2 = iteratorInt.next();
            this.setAndPropagate(LiteralsUtils.toInternal(n2));
        }
        int n3 = 0;
        for (int i = 0; i < this.decisions.size(); ++i) {
            int n4 = this.decisions.get(i);
            if (this.voc.isSatisfied(LiteralsUtils.toInternal(n4))) {
                this.prime[Math.abs((int)n4)] = n4;
                continue;
            }
            if (this.setAndPropagate(LiteralsUtils.toInternal(-n4))) {
                boolean bl = true;
                int n5 = this.currentDecisionLevel();
                for (n = i + 1; n < this.decisions.size(); ++n) {
                    if (this.setAndPropagate(LiteralsUtils.toInternal(this.decisions.get(n)))) continue;
                    bl = false;
                    break;
                }
                this.cancelUntil(n5);
                if (bl) {
                    this.forget(Math.abs(n4));
                    ++n3;
                    continue;
                }
                this.prime[Math.abs((int)n4)] = n4;
                this.cancel();
                this.setAndPropagate(LiteralsUtils.toInternal(n4));
                continue;
            }
            this.prime[Math.abs((int)n4)] = n4;
            this.cancel();
            this.setAndPropagate(LiteralsUtils.toInternal(n4));
        }
        this.cancelUntil(0);
        int[] nArray = new int[this.prime.length - n3 - 1];
        n = 0;
        for (int n6 : this.prime) {
            if (n6 == 0) continue;
            nArray[n++] = n6;
        }
        return nArray;
    }

    @Override
    public boolean primeImplicant(int n) {
        if (n == 0 || Math.abs(n) > this.realNumberOfVariables()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.prime == null) {
            throw new UnsupportedOperationException("Call the primeImplicant method first!!!");
        }
        return this.prime[Math.abs(n)] == n;
    }

    @Override
    public boolean model(int n) {
        if (n <= 0 || n > this.realNumberOfVariables()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.userbooleanmodel == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        return this.userbooleanmodel[n - 1];
    }

    @Override
    public void clearLearntClauses() {
        Iterator<Constr> iterator = this.learnts.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove(this);
        }
        this.learnts.clear();
        this.learnedLiterals.clear();
    }

    protected void reduceDB() {
        ++this.stats.reduceddb;
        this.slistener.cleaning();
        this.learnedConstraintsDeletionStrategy.reduce(this.learnts);
        System.gc();
    }

    protected void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.isSatisfiable(iVecInt, false);
    }

    public final LearnedConstraintsDeletionStrategy fixedSize(final int n) {
        return new LearnedConstraintsDeletionStrategy(){
            private static final long serialVersionUID = 1L;
            private final ConflictTimer aTimer;
            {
                this.aTimer = new ConflictTimerAdapter(n){
                    private static final long serialVersionUID = 1L;

                    public void run() {
                        Solver.this.needToReduceDB = true;
                    }
                };
            }

            @Override
            public void reduce(IVec<Constr> iVec) {
                int n4;
                int n2 = 0;
                int n3 = 0;
                for (n4 = 0; n4 < Solver.this.learnts.size() && Solver.this.learnts.size() - n2 > n; ++n4) {
                    Constr constr = Solver.this.learnts.get(n4);
                    if (constr.locked() || constr.size() == 2) {
                        Solver.this.learnts.set(n3++, Solver.this.learnts.get(n4));
                        continue;
                    }
                    constr.remove(Solver.this);
                    ++n2;
                }
                while (n4 < Solver.this.learnts.size()) {
                    Solver.this.learnts.set(n3++, Solver.this.learnts.get(n4));
                    ++n4;
                }
                if (Solver.this.verbose) {
                    Solver.this.out.log(Solver.this.getLogPrefix() + "cleaning " + (Solver.this.learnts.size() - n3) + " clauses out of " + Solver.this.learnts.size());
                }
                Solver.this.learnts.shrinkTo(n3);
            }

            @Override
            public void onConflictAnalysis(Constr constr) {
            }

            @Override
            public void onClauseLearning(Constr constr) {
            }

            public String toString() {
                return "Fixed size (" + n + ") learned constraints deletion strategy";
            }

            @Override
            public void init() {
            }

            @Override
            public ConflictTimer getTimer() {
                return this.aTimer;
            }

            @Override
            public void onPropagation(Constr constr) {
            }
        };
    }

    private LearnedConstraintsDeletionStrategy activityBased(final ConflictTimer conflictTimer) {
        return new LearnedConstraintsDeletionStrategy(){
            private static final long serialVersionUID = 1L;
            private final ConflictTimer freeMem;
            {
                this.freeMem = conflictTimer;
            }

            @Override
            public void reduce(IVec<Constr> iVec) {
                int n;
                Solver.this.sortOnActivity();
                int n2 = 0;
                for (n = 0; n < Solver.this.learnts.size() / 2; ++n) {
                    Constr constr = Solver.this.learnts.get(n);
                    if (constr.locked() || constr.size() == 2) {
                        Solver.this.learnts.set(n2++, Solver.this.learnts.get(n));
                        continue;
                    }
                    constr.remove(Solver.this);
                }
                while (n < Solver.this.learnts.size()) {
                    Solver.this.learnts.set(n2++, Solver.this.learnts.get(n));
                    ++n;
                }
                if (Solver.this.verbose) {
                    Solver.this.out.log(Solver.this.getLogPrefix() + "cleaning " + (Solver.this.learnts.size() - n2) + " clauses out of " + Solver.this.learnts.size());
                }
                Solver.this.learnts.shrinkTo(n2);
            }

            @Override
            public ConflictTimer getTimer() {
                return this.freeMem;
            }

            public String toString() {
                return "Memory based learned constraints deletion strategy";
            }

            @Override
            public void init() {
            }

            @Override
            public void onClauseLearning(Constr constr) {
            }

            @Override
            public void onConflictAnalysis(Constr constr) {
                if (constr.learnt()) {
                    Solver.this.claBumpActivity(constr);
                }
            }

            @Override
            public void onPropagation(Constr constr) {
            }
        };
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(LearnedConstraintsDeletionStrategy learnedConstraintsDeletionStrategy) {
        if (this.conflictCount != null) {
            this.conflictCount.add(learnedConstraintsDeletionStrategy.getTimer());
            assert (this.learnedConstraintsDeletionStrategy != null);
            this.conflictCount.remove(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        this.learnedConstraintsDeletionStrategy = learnedConstraintsDeletionStrategy;
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        int n;
        Lbool lbool = Lbool.UNDEFINED;
        boolean bl2 = this.conflictCount != null;
        int n2 = this.voc.nVars();
        if (this.mseen.length <= n2) {
            this.mseen = new boolean[n2 + 1];
        }
        this.trail.ensure(n2);
        this.trailLim.ensure(n2);
        this.learnedLiterals.ensure(n2);
        this.decisions.clear();
        this.implied.clear();
        this.slistener.init(this);
        this.slistener.start();
        this.model = null;
        this.userbooleanmodel = null;
        this.prime = null;
        this.unsatExplanationInTermsOfAssumptions = null;
        if (!bl2 || !this.keepHot) {
            this.order.init();
        }
        this.learnedConstraintsDeletionStrategy.init();
        int n3 = this.trail.size();
        this.qhead = 0;
        for (int i = n3 - 1; i >= 0; --i) {
            int n4 = this.trail.get(i);
            IVec<Undoable> iVec = this.voc.undos(n4);
            assert (iVec != null);
            for (n = iVec.size(); n > 0; --n) {
                iVec.last().undo(n4);
                iVec.pop();
            }
        }
        Object object = this.learnedLiterals.iterator();
        while (object.hasNext()) {
            this.enqueue(object.next());
        }
        object = this.propagate();
        if (object != null) {
            this.analyzeAtRootLevel((Constr)object);
            this.slistener.conflictFound((IConstr)object, 0, 0);
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(n3);
            return false;
        }
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n5 = iteratorInt.next();
            n = this.voc.getFromPool(n5);
            if ((this.voc.isSatisfied(n) || this.assume(n)) && (object = this.propagate()) == null) continue;
            if (object == null) {
                this.slistener.conflictFound(n);
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(null, iVecInt, n);
                this.unsatExplanationInTermsOfAssumptions.push(n5);
            } else {
                this.slistener.conflictFound((IConstr)object, this.decisionLevel(), this.trail.size());
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions((Constr)object, iVecInt, -1);
            }
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(n3);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        if (!bl2 || !this.keepHot) {
            this.order.init();
        }
        this.learner.init();
        if (!bl2) {
            this.conflictCount = new ConflictTimerContainer();
            this.conflictCount.add(this.restarter);
            this.conflictCount.add(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        boolean bl3 = false;
        if (this.timeBasedTimeout) {
            if (!bl || this.timer == null) {
                bl3 = true;
                this.undertimeout = true;
                TimerTask timerTask = new TimerTask(){

                    public void run() {
                        Solver.this.undertimeout = false;
                    }
                };
                this.timer = new Timer(true);
                this.timer.schedule(timerTask, this.timeout);
            }
        } else if (!bl || !bl2) {
            bl3 = true;
            this.undertimeout = true;
            ConflictTimerAdapter conflictTimerAdapter = new ConflictTimerAdapter((int)this.timeout){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Solver.this.undertimeout = false;
                }
            };
            this.conflictCount.add(conflictTimerAdapter);
        }
        if (!bl || bl3) {
            this.restarter.init(this.params);
            this.timebegin = System.currentTimeMillis();
        }
        this.needToReduceDB = false;
        this.lastConflictMeansUnsat = true;
        while (lbool == Lbool.UNDEFINED && this.undertimeout && this.lastConflictMeansUnsat) {
            lbool = this.search(iVecInt);
            if (lbool != Lbool.UNDEFINED) continue;
            this.restarter.onRestart();
            this.slistener.restarting();
        }
        this.cancelUntil(0);
        this.cancelLearntLiterals(n3);
        if (!bl && this.timeBasedTimeout && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.slistener.end(lbool);
        if (!this.undertimeout) {
            String string = " Timeout (" + this.timeout + (this.timeBasedTimeout ? "s" : " conflicts") + ") exceeded";
            throw new TimeoutException(string);
        }
        if (lbool == Lbool.UNDEFINED && !this.lastConflictMeansUnsat) {
            throw new TimeoutException("Cannot decide the satisfiability");
        }
        return lbool == Lbool.TRUE;
    }

    @Override
    public void printInfos(PrintWriter printWriter, String string) {
        printWriter.print(string);
        printWriter.println("constraints type ");
        long l = 0L;
        for (Map.Entry<String, Counter> entry : this.constrTypes.entrySet()) {
            printWriter.println(string + entry.getKey() + " => " + entry.getValue());
            l += (long)entry.getValue().getValue();
        }
        printWriter.print(string);
        printWriter.print(l);
        printWriter.println(" constraints processed.");
    }

    public void printLearntClausesInfos(PrintWriter printWriter, String string) {
        HashMap<String, Counter> hashMap = new HashMap<String, Counter>();
        Iterator<Object> iterator = this.learnts.iterator();
        while (iterator.hasNext()) {
            String object = iterator.next().getClass().getName();
            Counter counter = (Counter)hashMap.get(object);
            if (counter == null) {
                hashMap.put(object, new Counter());
                continue;
            }
            counter.inc();
        }
        printWriter.print(string);
        printWriter.println("learnt constraints type ");
        for (Map.Entry entry : hashMap.entrySet()) {
            printWriter.println(string + (String)entry.getKey() + " => " + entry.getValue());
        }
    }

    public SolverStats getStats() {
        return this.stats;
    }

    protected void initStats(SolverStats solverStats) {
        this.stats = solverStats;
    }

    @Override
    public IOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IOrder iOrder) {
        this.order = iOrder;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.trail.clear();
        this.trailLim.clear();
        this.qhead = 0;
        Iterator<Constr> iterator = this.constrs.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove(this);
        }
        this.constrs.clear();
        this.clearLearntClauses();
        this.voc.resetPool();
        this.dsfactory.reset();
        this.stats.reset();
        this.constrTypes.clear();
    }

    @Override
    public int nVars() {
        if (this.declaredMaxVarId == 0) {
            return this.voc.nVars();
        }
        return this.declaredMaxVarId;
    }

    protected IConstr addConstr(Constr constr) {
        if (constr == null) {
            Counter counter = this.constrTypes.get("ignored satisfied constraints");
            if (counter == null) {
                this.constrTypes.put("ignored satisfied constraints", new Counter());
            } else {
                counter.inc();
            }
        } else {
            this.constrs.push(constr);
            String string = constr.getClass().getName();
            Counter counter = this.constrTypes.get(string);
            if (counter == null) {
                this.constrTypes.put(string, new Counter());
            } else {
                counter.inc();
            }
        }
        return constr;
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.moutLearnt;
    }

    public IConstr getIthConstr(int n) {
        return this.constrs.get(n);
    }

    @Override
    public void printStat(PrintStream printStream, String string) {
        this.printStat(new PrintWriter(printStream, true), string);
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
        this.stats.printStat(printWriter, string);
        double d = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        printWriter.println(string + "speed (assignments/second)\t: " + (double)this.stats.propagations / d);
        this.order.printStat(printWriter, string);
        this.printLearntClausesInfos(printWriter, string);
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new Object[]{this.dsfactory, this.learner, this.params, this.order, this.simplifier, this.restarter, this.learnedConstraintsDeletionStrategy};
        stringBuffer.append(string);
        stringBuffer.append("--- Begin Solver configuration ---");
        stringBuffer.append("\n");
        for (Object object : objectArray) {
            stringBuffer.append(string);
            stringBuffer.append(object.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("timeout=");
        if (this.timeBasedTimeout) {
            stringBuffer.append(this.timeout / 1000L);
            stringBuffer.append("s\n");
        } else {
            stringBuffer.append(this.timeout);
            stringBuffer.append(" conflicts\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("DB Simplification allowed=");
        stringBuffer.append(this.isDBSimplificationAllowed);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        if (this.isSolverKeptHot()) {
            stringBuffer.append("Heuristics kept accross calls (keep the solver \"hot\")\n");
            stringBuffer.append(string);
        }
        stringBuffer.append("--- End Solver configuration ---");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return (int)(this.timeBasedTimeout ? this.timeout / 1000L : this.timeout);
    }

    @Override
    public long getTimeoutMs() {
        if (!this.timeBasedTimeout) {
            throw new UnsupportedOperationException("The timeout is given in number of conflicts!");
        }
        return this.timeout;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.constrs.ensure(n);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.stats.toMap();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        if (this.isSatisfiable(iVecInt)) {
            return this.model();
        }
        return null;
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return this.isDBSimplificationAllowed;
    }

    @Override
    public void setDBSimplificationAllowed(boolean bl) {
        this.isDBSimplificationAllowed = bl;
    }

    @Override
    public int nextFreeVarId(boolean bl) {
        return this.voc.nextFreeVarId(bl);
    }

    @Override
    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        return this.addClause(iVecInt);
    }

    @Override
    public void unset(int n) {
        if (this.voc.isUnassigned(n) || this.trail.isEmpty()) {
            return;
        }
        int n2 = this.trail.last();
        while (n2 != n) {
            this.undoOne();
            if (this.trail.isEmpty()) {
                return;
            }
            n2 = this.trail.last();
        }
        this.undoOne();
        this.qhead = this.trail.size();
    }

    @Override
    public void setLogPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public String getLogPrefix() {
        return this.prefix;
    }

    @Override
    public IVecInt unsatExplanation() {
        VecInt vecInt = new VecInt(this.unsatExplanationInTermsOfAssumptions.size());
        this.unsatExplanationInTermsOfAssumptions.copyTo(vecInt);
        return vecInt;
    }

    @Override
    public int[] modelWithInternalVariables() {
        int[] nArray;
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        if (this.nVars() == this.realNumberOfVariables()) {
            nArray = new int[this.model.length];
            System.arraycopy(this.model, 0, nArray, 0, nArray.length);
        } else {
            nArray = new int[this.fullmodel.length];
            System.arraycopy(this.fullmodel, 0, nArray, 0, nArray.length);
        }
        return nArray;
    }

    @Override
    public int realNumberOfVariables() {
        return this.voc.nVars();
    }

    @Override
    public void stop() {
        this.expireTimeout();
    }

    @Override
    public void backtrack(int[] nArray) {
        VecInt vecInt = new VecInt(nArray.length);
        for (int n : nArray) {
            vecInt.push(LiteralsUtils.toInternal(n));
        }
        this.sharedConflict = this.dsfactory.createUnregisteredClause(vecInt);
        this.learn(this.sharedConflict);
    }

    @Override
    public Lbool truthValue(int n) {
        int n2 = LiteralsUtils.toInternal(n);
        if (this.voc.isFalsified(n2)) {
            return Lbool.FALSE;
        }
        if (this.voc.isSatisfied(n2)) {
            return Lbool.TRUE;
        }
        return Lbool.UNDEFINED;
    }

    @Override
    public int currentDecisionLevel() {
        return this.decisionLevel();
    }

    @Override
    public int[] getLiteralsPropagatedAt(int n) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void suggestNextLiteralToBranchOn(int n) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    protected boolean isNeedToReduceDB() {
        return this.needToReduceDB;
    }

    @Override
    public void setNeedToReduceDB(boolean bl) {
        this.needToReduceDB = bl;
    }

    @Override
    public void setLogger(ICDCLLogger iCDCLLogger) {
        this.out = iCDCLLogger;
    }

    @Override
    public ICDCLLogger getLogger() {
        return this.out;
    }

    @Override
    public double[] getVariableHeuristics() {
        return this.order.getVariableHeuristics();
    }

    public IVec<Constr> getLearnedConstraints() {
        return this.learnts;
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(ConflictTimer conflictTimer, LearnedConstraintsEvaluationType learnedConstraintsEvaluationType) {
        if (this.conflictCount != null) {
            this.conflictCount.add(conflictTimer);
            this.conflictCount.remove(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        switch (learnedConstraintsEvaluationType) {
            case ACTIVITY: {
                this.learnedConstraintsDeletionStrategy = this.activityBased(conflictTimer);
                break;
            }
            case LBD: {
                this.learnedConstraintsDeletionStrategy = new GlucoseLCDS(conflictTimer);
                break;
            }
            case LBD2: {
                this.learnedConstraintsDeletionStrategy = new Glucose2LCDS(conflictTimer);
            }
        }
        if (this.conflictCount != null) {
            this.learnedConstraintsDeletionStrategy.init();
        }
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(LearnedConstraintsEvaluationType learnedConstraintsEvaluationType) {
        ConflictTimer conflictTimer = this.learnedConstraintsDeletionStrategy.getTimer();
        switch (learnedConstraintsEvaluationType) {
            case ACTIVITY: {
                this.learnedConstraintsDeletionStrategy = this.activityBased(conflictTimer);
                break;
            }
            case LBD: {
                this.learnedConstraintsDeletionStrategy = new GlucoseLCDS(conflictTimer);
                break;
            }
            case LBD2: {
                this.learnedConstraintsDeletionStrategy = new Glucose2LCDS(conflictTimer);
            }
        }
        if (this.conflictCount != null) {
            this.learnedConstraintsDeletionStrategy.init();
        }
    }

    @Override
    public boolean isSolverKeptHot() {
        return this.keepHot;
    }

    @Override
    public void setKeepSolverHot(boolean bl) {
        this.keepHot = bl;
    }

    @Override
    public void addClause(int[] nArray) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    private class Glucose2LCDS
    extends GlucoseLCDS {
        private static final long serialVersionUID = 1L;

        Glucose2LCDS(ConflictTimer conflictTimer) {
            super(conflictTimer);
        }

        public String toString() {
            return "Glucose 2 learned constraints deletion strategy";
        }

        public void onPropagation(Constr constr) {
            int n;
            if (constr.getActivity() > 2.0 && (double)(n = this.computeLBD(constr)) < constr.getActivity()) {
                ++((Solver)Solver.this).stats.updateLBD;
                constr.setActivity(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlucoseLCDS
    implements LearnedConstraintsDeletionStrategy {
        private static final long serialVersionUID = 1L;
        private int[] flags = new int[0];
        private int flag = 0;
        private final ConflictTimer clauseManagement;

        GlucoseLCDS(ConflictTimer conflictTimer) {
            this.clauseManagement = conflictTimer;
        }

        @Override
        public void reduce(IVec<Constr> iVec) {
            int n;
            Solver.this.sortOnActivity();
            for (int i = n = iVec.size() / 2; i < iVec.size(); ++i) {
                Constr constr = iVec.get(i);
                if (constr.locked() || constr.getActivity() <= 2.0) {
                    iVec.set(n++, Solver.this.learnts.get(i));
                    continue;
                }
                constr.remove(Solver.this);
            }
            if (Solver.this.verbose) {
                Solver.this.out.log(Solver.this.getLogPrefix() + "cleaning " + (iVec.size() - n) + " clauses out of " + iVec.size() + " with flag " + this.flag + "/" + ((Solver)Solver.this).stats.conflicts);
            }
            Solver.this.learnts.shrinkTo(n);
        }

        @Override
        public ConflictTimer getTimer() {
            return this.clauseManagement;
        }

        public String toString() {
            return "Glucose learned constraints deletion strategy";
        }

        @Override
        public void init() {
            int n = Solver.this.voc.nVars();
            if (this.flags.length <= n) {
                this.flags = new int[n + 1];
            }
            this.flag = 0;
            this.clauseManagement.reset();
        }

        @Override
        public void onClauseLearning(Constr constr) {
            int n = this.computeLBD(constr);
            constr.incActivity(n);
        }

        protected int computeLBD(Constr constr) {
            int n = 1;
            ++this.flag;
            for (int i = 1; i < constr.size(); ++i) {
                int n2 = Solver.this.voc.getLevel(constr.get(i));
                if (this.flags[n2] == this.flag) continue;
                this.flags[n2] = this.flag;
                ++n;
            }
            return n;
        }

        @Override
        public void onConflictAnalysis(Constr constr) {
        }

        @Override
        public void onPropagation(Constr constr) {
        }
    }
}

