/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;

public final class LubyRestarts
implements RestartStrategy {
    public static final int DEFAULT_LUBY_FACTOR = 32;
    private static final long serialVersionUID = 1L;
    private int un = 1;
    private int vn = 1;
    private int factor;
    private int bound;
    private int conflictcount;

    public int luby() {
        return this.vn;
    }

    public int nextLuby() {
        if ((this.un & -this.un) == this.vn) {
            ++this.un;
            this.vn = 1;
        } else {
            this.vn <<= 1;
        }
        return this.vn;
    }

    public LubyRestarts() {
        this(32);
    }

    public LubyRestarts(int n) {
        this.setFactor(n);
    }

    public final void setFactor(int n) {
        this.factor = n;
    }

    public int getFactor() {
        return this.factor;
    }

    public void init(SearchParams searchParams) {
        this.un = 1;
        this.vn = 1;
        this.bound = this.luby() * this.factor;
    }

    public long nextRestartNumberOfConflict() {
        return this.bound;
    }

    public void onRestart() {
        this.bound = this.nextLuby() * this.factor;
        this.conflictcount = 0;
    }

    public String toString() {
        return "luby style (SATZ_rand, TiniSAT) restarts strategy with factor " + this.factor;
    }

    public boolean shouldRestart() {
        return this.conflictcount >= this.bound;
    }

    public void onBackjumpToRootLevel() {
        this.conflictcount = 0;
    }

    public void reset() {
        this.conflictcount = 0;
    }

    public void newConflict() {
        ++this.conflictcount;
    }

    public SearchParams getSearchParams() {
        return new SearchParams();
    }

    public void newLearnedClause(Constr constr, int n) {
    }
}

