/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectorVariablesDecorator
extends SolverDecorator<ISolver>
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int nbexpectedclauses;
    protected int[] prevfullmodel;
    protected int[] prevmodel;
    protected boolean[] prevboolmodel;
    protected boolean isSolutionOptimal;

    public AbstractSelectorVariablesDecorator(ISolver iSolver) {
        super(iSolver);
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
    }

    public int getExpectedNumberOfClauses() {
        return this.nbexpectedclauses;
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        this.isSolutionOptimal = false;
        boolean bl = super.isSatisfiable(iVecInt, true);
        if (bl) {
            this.prevboolmodel = new boolean[this.nVars()];
            for (int i = 0; i < this.nVars(); ++i) {
                this.prevboolmodel[i] = this.decorated().model(i + 1);
            }
            this.prevfullmodel = super.modelWithInternalVariables();
            this.prevmodel = super.model();
            this.calculateObjectiveValue();
        } else {
            this.isSolutionOptimal = true;
        }
        return bl;
    }

    abstract void calculateObjectiveValue();

    @Override
    public int[] model() {
        return this.prevmodel;
    }

    @Override
    public boolean model(int n) {
        return this.prevboolmodel[n - 1];
    }

    @Override
    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }
}

