/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.encoding.Binary;
import org.sat4j.tools.encoding.Binomial;
import org.sat4j.tools.encoding.Commander;
import org.sat4j.tools.encoding.EncodingStrategy;
import org.sat4j.tools.encoding.EncodingStrategyAdapter;
import org.sat4j.tools.encoding.Ladder;
import org.sat4j.tools.encoding.Product;
import org.sat4j.tools.encoding.Sequential;

public class Policy
extends EncodingStrategyAdapter {
    private final Sequential seq = new Sequential();
    private final Binary binary = new Binary();
    private final Product product = new Product();
    private final Commander commander = new Commander();
    private final Binomial binomial = new Binomial();
    private final Ladder ladder = new Ladder();
    private EncodingStrategyAdapter atMostOneEncoding;
    private EncodingStrategyAdapter atMostKEncoding;
    private EncodingStrategyAdapter exactlyOneEncoding;
    private EncodingStrategyAdapter exactlyKEncoding;
    private EncodingStrategyAdapter atLeastOneEncoding;
    private EncodingStrategyAdapter atLeastKEncoding;

    private EncodingStrategyAdapter getAdapterFromEncodingName(EncodingStrategy encodingStrategy) {
        switch (encodingStrategy) {
            case BINARY: {
                return this.binary;
            }
            case BINOMIAL: {
                return this.binomial;
            }
            case COMMANDER: {
                return this.commander;
            }
            case LADDER: {
                return this.ladder;
            }
            case PRODUCT: {
                return this.product;
            }
            case SEQUENTIAL: {
                return this.seq;
            }
        }
        return null;
    }

    public EncodingStrategyAdapter getAtMostOneEncoding() {
        return this.atMostOneEncoding;
    }

    public void setAtMostOneEncoding(EncodingStrategyAdapter encodingStrategyAdapter) {
        this.atMostOneEncoding = encodingStrategyAdapter;
    }

    public void setAtMostOneEncoding(EncodingStrategy encodingStrategy) {
        this.atMostOneEncoding = this.getAdapterFromEncodingName(encodingStrategy);
    }

    public EncodingStrategyAdapter getAtMostKEncoding() {
        return this.atMostKEncoding;
    }

    public void setAtMostKEncoding(EncodingStrategyAdapter encodingStrategyAdapter) {
        this.atMostKEncoding = encodingStrategyAdapter;
    }

    public void setAtMostKEncoding(EncodingStrategy encodingStrategy) {
        this.atMostKEncoding = this.getAdapterFromEncodingName(encodingStrategy);
    }

    public EncodingStrategyAdapter getExactlyOneEncoding() {
        return this.exactlyOneEncoding;
    }

    public void setExactlyOneEncoding(EncodingStrategyAdapter encodingStrategyAdapter) {
        this.exactlyOneEncoding = encodingStrategyAdapter;
    }

    public void setExactlyOneEncoding(EncodingStrategy encodingStrategy) {
        this.exactlyOneEncoding = this.getAdapterFromEncodingName(encodingStrategy);
    }

    public EncodingStrategyAdapter getExactlyKEncoding() {
        return this.exactlyKEncoding;
    }

    public void setExactlyKEncoding(EncodingStrategyAdapter encodingStrategyAdapter) {
        this.exactlyKEncoding = encodingStrategyAdapter;
    }

    public void setExactlyKEncoding(EncodingStrategy encodingStrategy) {
        this.exactlyKEncoding = this.getAdapterFromEncodingName(encodingStrategy);
    }

    public EncodingStrategyAdapter getAtLeastOneEncoding() {
        return this.atLeastOneEncoding;
    }

    public void setAtLeastOneEncoding(EncodingStrategyAdapter encodingStrategyAdapter) {
        this.atLeastOneEncoding = encodingStrategyAdapter;
    }

    public void setAtLeastOneEncoding(EncodingStrategy encodingStrategy) {
        this.atLeastOneEncoding = this.getAdapterFromEncodingName(encodingStrategy);
    }

    public EncodingStrategyAdapter getAtLeastKEncoding() {
        return this.atLeastKEncoding;
    }

    public void setAtLeastKEncoding(EncodingStrategyAdapter encodingStrategyAdapter) {
        this.atLeastKEncoding = encodingStrategyAdapter;
    }

    public void setAtLeastKEncoding(EncodingStrategy encodingStrategy) {
        this.atLeastKEncoding = this.getAdapterFromEncodingName(encodingStrategy);
    }

    public IConstr addAtMost(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        if (n == 0 || iVecInt.size() == 1) {
            return super.addAtMost(iSolver, iVecInt, n);
        }
        if (iVecInt.size() <= 1) {
            throw new UnsupportedOperationException("requires at least 2 literals");
        }
        if (n == 1 && this.atMostOneEncoding != null) {
            return this.atMostOneEncoding.addAtMostOne(iSolver, iVecInt);
        }
        if (this.atMostKEncoding != null) {
            if (n == 1) {
                return this.atMostKEncoding.addAtMostOne(iSolver, iVecInt);
            }
            return this.atMostKEncoding.addAtMost(iSolver, iVecInt, n);
        }
        return super.addAtMost(iSolver, iVecInt, n);
    }

    public IConstr addExactly(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        if (n == 1 && this.exactlyOneEncoding != null) {
            return this.exactlyOneEncoding.addExactlyOne(iSolver, iVecInt);
        }
        if (this.exactlyKEncoding != null) {
            if (n == 1) {
                return this.exactlyKEncoding.addExactlyOne(iSolver, iVecInt);
            }
            return this.exactlyKEncoding.addExactly(iSolver, iVecInt, n);
        }
        return super.addExactly(iSolver, iVecInt, n);
    }

    public IConstr addAtLeast(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        if (n == 1) {
            if (this.atLeastOneEncoding != null) {
                return this.atLeastOneEncoding.addAtLeastOne(iSolver, iVecInt);
            }
        } else if (this.atLeastKEncoding != null) {
            return this.atLeastKEncoding.addAtLeast(iSolver, iVecInt, n);
        }
        return super.addAtLeast(iSolver, iVecInt, n);
    }
}

