/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.card;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.constraints.cnf.UnitClauses;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;

public class AtLeast
implements Propagatable,
Constr,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    protected int maxUnsatisfied;
    private int counter;
    protected final int[] lits;
    protected final ILits voc;

    public AtLeast(ILits iLits, IVecInt iVecInt, int n) {
        this.maxUnsatisfied = iVecInt.size() - n;
        this.voc = iLits;
        this.counter = 0;
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
    }

    protected static int niceParameters(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, int n) throws ContradictionException {
        if (iVecInt.size() < n) {
            throw new ContradictionException();
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < iVecInt.size()) {
            if (iLits.isUnassigned(iVecInt.get(n3))) {
                ++n3;
                continue;
            }
            if (iLits.isSatisfied(iVecInt.get(n3))) {
                --n2;
            }
            iVecInt.delete(n3);
        }
        iVecInt.sortUnique();
        if (iVecInt.size() == n2) {
            for (n3 = 0; n3 < iVecInt.size(); ++n3) {
                if (unitPropagationListener.enqueue(iVecInt.get(n3))) continue;
                throw new ContradictionException();
            }
            return 0;
        }
        if (iVecInt.size() < n2) {
            throw new ContradictionException();
        }
        return n2;
    }

    public static Constr atLeastNew(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt, int n) throws ContradictionException {
        int n2 = AtLeast.niceParameters(unitPropagationListener, iLits, iVecInt, n);
        if (n2 == 0) {
            return new UnitClauses(iVecInt);
        }
        AtLeast atLeast = new AtLeast(iLits, iVecInt, n2);
        atLeast.register();
        return atLeast;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        for (int n : this.lits) {
            this.voc.watches(n ^ 1).remove(this);
        }
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        this.voc.watch(n, this);
        if (this.counter == this.maxUnsatisfied) {
            return false;
        }
        ++this.counter;
        this.voc.undos(n).push(this);
        if (this.counter == this.maxUnsatisfied) {
            for (int n2 : this.lits) {
                if (!this.voc.isUnassigned(n2) || unitPropagationListener.enqueue(n2, this)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean simplify() {
        return false;
    }

    public void undo(int n) {
        --this.counter;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int n2 = n == -1 ? -1 : 0;
        for (int n3 : this.lits) {
            if (!this.voc.isFalsified(n3)) continue;
            iVecInt.push(n3 ^ 1);
            if (++n2 <= this.maxUnsatisfied) continue;
            return;
        }
    }

    public boolean learnt() {
        return false;
    }

    public double getActivity() {
        return 0.0;
    }

    public void setActivity(double d) {
    }

    public void incActivity(double d) {
    }

    public boolean locked() {
        return true;
    }

    public void setLearnt() {
        throw new UnsupportedOperationException();
    }

    public void register() {
        this.counter = 0;
        for (int n : this.lits) {
            this.voc.watch(n ^ 1, this);
            if (!this.voc.isFalsified(n)) continue;
            ++this.counter;
            this.voc.undos(n ^ 1).push(this);
        }
    }

    public int size() {
        return this.lits.length;
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void rescaleBy(double d) {
        throw new UnsupportedOperationException();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Card (" + this.lits.length + ") : ");
        for (int n : this.lits) {
            stringBuffer.append(" + ");
            stringBuffer.append(Lits.toString(n));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(n));
            stringBuffer.append("@");
            stringBuffer.append(this.voc.getLevel(n));
            stringBuffer.append("]  ");
        }
        stringBuffer.append(">= ");
        stringBuffer.append(this.size() - this.maxUnsatisfied);
        return stringBuffer.toString();
    }

    public void forwardActivity(double d) {
    }

    public boolean canBePropagatedMultipleTimes() {
        return true;
    }

    public Constr toConstraint() {
        return this;
    }

    public void calcReasonOnTheFly(int n, IVecInt iVecInt, IVecInt iVecInt2) {
        int n2 = n == -1 ? -1 : 0;
        VecInt vecInt = new VecInt(this.lits);
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n3 = iteratorInt.next();
            if (!vecInt.contains(n3 ^ 1)) continue;
            iVecInt2.push(n3);
            if (++n2 <= this.maxUnsatisfied) continue;
            return;
        }
    }
}

