/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.AbstractClauseSelectorSolver;
import org.sat4j.tools.FullClauseSelectorSolver;
import org.sat4j.tools.GroupClauseSelectorSolver;
import org.sat4j.tools.Minimal4CardinalityModel;
import org.sat4j.tools.Minimal4InclusionModel;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMUSes {
    private AbstractClauseSelectorSolver<ISolver> css;
    private final List<IVecInt> mssList;
    private final List<IVecInt> secondPhaseClauses;
    private final List<IVecInt> musList;
    private final ASolverFactory<? extends ISolver> factory;

    public AllMUSes(boolean bl, ASolverFactory<? extends ISolver> aSolverFactory) {
        this.css = !bl ? new FullClauseSelectorSolver<ISolver>(aSolverFactory.defaultSolver(), false) : new GroupClauseSelectorSolver<ISolver>(aSolverFactory.defaultSolver());
        this.mssList = new ArrayList<IVecInt>();
        this.musList = new ArrayList<IVecInt>();
        this.secondPhaseClauses = new ArrayList<IVecInt>();
        this.factory = aSolverFactory;
    }

    public AllMUSes(ASolverFactory<? extends ISolver> aSolverFactory) {
        this(false, aSolverFactory);
    }

    public <T extends ISolver> T getSolverInstance() {
        return (T)this.css;
    }

    public List<IVecInt> computeAllMUSes() {
        return this.computeAllMUSes(SolutionFoundListener.VOID);
    }

    public List<IVecInt> computeAllMUSes(SolutionFoundListener solutionFoundListener) {
        if (this.secondPhaseClauses.isEmpty()) {
            this.computeAllMSS();
        }
        ISolver iSolver = this.factory.defaultSolver();
        for (IVecInt iVecInt : this.secondPhaseClauses) {
            try {
                iSolver.addClause(iVecInt);
            }
            catch (ContradictionException contradictionException) {
                return this.musList;
            }
        }
        Minimal4InclusionModel minimal4InclusionModel = new Minimal4InclusionModel(iSolver, Minimal4InclusionModel.positiveLiterals(iSolver));
        return this.computeAllMUSes(solutionFoundListener, minimal4InclusionModel);
    }

    public List<IVecInt> computeAllMUSesOrdered(SolutionFoundListener solutionFoundListener) {
        if (this.secondPhaseClauses.isEmpty()) {
            this.computeAllMSS();
        }
        ISolver iSolver = this.factory.defaultSolver();
        for (IVecInt iVecInt : this.secondPhaseClauses) {
            try {
                iSolver.addClause(iVecInt);
            }
            catch (ContradictionException contradictionException) {
                return this.musList;
            }
        }
        Minimal4CardinalityModel minimal4CardinalityModel = new Minimal4CardinalityModel(iSolver, Minimal4InclusionModel.positiveLiterals(iSolver));
        return this.computeAllMUSes(solutionFoundListener, minimal4CardinalityModel);
    }

    private List<IVecInt> computeAllMUSes(SolutionFoundListener solutionFoundListener, ISolver iSolver) {
        if (this.css.isVerbose()) {
            System.out.println(this.css.getLogPrefix() + "Computing all MUSes ...");
        }
        this.css.internalState();
        try {
            while (iSolver.isSatisfiable()) {
                VecInt vecInt = new VecInt();
                VecInt vecInt2 = new VecInt();
                int[] nArray = iSolver.model();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= 0) continue;
                    vecInt.push(-nArray[i]);
                    vecInt2.push(nArray[i]);
                }
                this.musList.add(vecInt2);
                solutionFoundListener.onSolutionFound(vecInt2);
                iSolver.addBlockingClause(vecInt);
            }
        }
        catch (ContradictionException contradictionException) {
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        if (this.css.isVerbose()) {
            System.out.println(this.css.getLogPrefix() + "... done.");
        }
        this.css.externalState();
        return this.musList;
    }

    public List<IVecInt> computeAllMSS() {
        return this.computeAllMSS(SolutionFoundListener.VOID);
    }

    public List<IVecInt> computeAllMSS(SolutionFoundListener solutionFoundListener) {
        VecInt vecInt = new VecInt();
        for (Integer n : this.css.getAddedVars()) {
            vecInt.push(n);
        }
        Minimal4InclusionModel minimal4InclusionModel = new Minimal4InclusionModel(this.css, vecInt);
        return this.computeAllMSS(solutionFoundListener, minimal4InclusionModel, vecInt);
    }

    public List<IVecInt> computeAllMSSOrdered(SolutionFoundListener solutionFoundListener) {
        VecInt vecInt = new VecInt();
        for (Integer n : this.css.getAddedVars()) {
            vecInt.push(n);
        }
        Minimal4CardinalityModel minimal4CardinalityModel = new Minimal4CardinalityModel(this.css, vecInt);
        return this.computeAllMSS(solutionFoundListener, minimal4CardinalityModel, vecInt);
    }

    private List<IVecInt> computeAllMSS(SolutionFoundListener solutionFoundListener, ISolver iSolver, IVecInt iVecInt) {
        if (this.css.isVerbose()) {
            System.out.println(this.css.getLogPrefix() + "Computing all MSSes ...");
        }
        this.css.internalState();
        int n = this.css.nVars();
        VecInt vecInt = new VecInt();
        for (int i = 0; i < this.css.getAddedVars().size(); ++i) {
            vecInt.push(i + 1);
        }
        try {
            while (iSolver.isSatisfiable()) {
                int[] nArray = iSolver.modelWithInternalVariables();
                VecInt vecInt2 = new VecInt();
                vecInt.copyTo(vecInt2);
                VecInt vecInt3 = new VecInt();
                VecInt vecInt4 = new VecInt();
                for (int i = 0; i < iVecInt.size(); ++i) {
                    int n2 = Math.abs(iVecInt.get(i));
                    if (nArray[n2 - 1] <= 0) continue;
                    vecInt3.push(-n2);
                    vecInt4.push(n2 - n);
                    vecInt2.remove(n2 - n);
                }
                this.mssList.add(vecInt2);
                solutionFoundListener.onSolutionFound(vecInt2);
                this.secondPhaseClauses.add(vecInt4);
                this.css.addBlockingClause(vecInt3);
            }
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            // empty catch block
        }
        if (this.css.isVerbose()) {
            System.out.println(this.css.getLogPrefix() + "... done.");
        }
        this.css.externalState();
        return this.mssList;
    }

    public List<IVecInt> getMssList() {
        return this.mssList;
    }
}

