/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Constr;
import org.sat4j.pb.constraints.AbstractPBClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.LearntBinaryClausePB;
import org.sat4j.pb.constraints.pb.LearntHTClausePB;
import org.sat4j.pb.constraints.pb.MinWatchCardPB;
import org.sat4j.pb.constraints.pb.MinWatchPb;
import org.sat4j.pb.constraints.pb.OriginalBinaryClausePB;
import org.sat4j.pb.constraints.pb.OriginalHTClausePB;
import org.sat4j.pb.constraints.pb.PuebloMinWatchPb;
import org.sat4j.pb.constraints.pb.UnitClausePB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PuebloPBMinClauseCardConstrDataStructure
extends AbstractPBClauseCardConstrDataStructure {
    private static final long serialVersionUID = 1L;

    @Override
    protected Constr constructClause(IVecInt iVecInt) {
        if (iVecInt.size() == 2) {
            return OriginalBinaryClausePB.brandNewClause(this.solver, this.getVocabulary(), iVecInt);
        }
        return OriginalHTClausePB.brandNewClause(this.solver, this.getVocabulary(), iVecInt);
    }

    @Override
    protected Constr constructCard(IVecInt iVecInt, int n) throws ContradictionException {
        return MinWatchCardPB.normalizedMinWatchCardPBNew(this.solver, this.getVocabulary(), iVecInt, n);
    }

    @Override
    protected Constr constructPB(IDataStructurePB iDataStructurePB) throws ContradictionException {
        return MinWatchPb.normalizedMinWatchPbNew(this.solver, this.getVocabulary(), iDataStructurePB);
    }

    @Override
    protected Constr constructPB(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        return MinWatchPb.normalizedMinWatchPbNew(this.solver, this.getVocabulary(), nArray, bigIntegerArray, bigInteger);
    }

    @Override
    protected Constr constructLearntClause(IVecInt iVecInt) {
        if (iVecInt.size() == 1) {
            return new UnitClausePB(iVecInt.last(), this.getVocabulary());
        }
        if (iVecInt.size() == 2) {
            return new LearntBinaryClausePB(iVecInt, this.getVocabulary());
        }
        return new LearntHTClausePB(iVecInt, this.getVocabulary());
    }

    @Override
    protected Constr constructLearntCard(IVecInt iVecInt, int n) {
        return new MinWatchCardPB(this.getVocabulary(), iVecInt, true, n);
    }

    @Override
    protected Constr constructLearntPB(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        return PuebloMinWatchPb.watchPbNew(this.getVocabulary(), iVecInt, iVec, true, bigInteger);
    }

    @Override
    protected Constr constructLearntClause(IDataStructurePB iDataStructurePB) {
        VecInt vecInt = new VecInt();
        Vec vec = new Vec();
        iDataStructurePB.buildConstraintFromConflict((IVecInt)vecInt, (IVec<BigInteger>)vec);
        if (vecInt.size() == 1) {
            return new UnitClausePB(vecInt.last(), this.getVocabulary());
        }
        if (vecInt.size() == 2) {
            return new LearntBinaryClausePB((IVecInt)vecInt, this.getVocabulary());
        }
        return new LearntHTClausePB((IVecInt)vecInt, this.getVocabulary());
    }

    @Override
    protected Constr constructLearntCard(IDataStructurePB iDataStructurePB) {
        VecInt vecInt = new VecInt();
        Vec vec = new Vec();
        iDataStructurePB.buildConstraintFromConflict((IVecInt)vecInt, (IVec<BigInteger>)vec);
        return new MinWatchCardPB(this.getVocabulary(), (IVecInt)vecInt, true, iDataStructurePB.getDegree().intValue());
    }

    @Override
    protected Constr constructLearntPB(IDataStructurePB iDataStructurePB) {
        return PuebloMinWatchPb.normalizedWatchPbNew(this.getVocabulary(), iDataStructurePB);
    }
}

