/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.tools.ImplicationNamer;
import org.sat4j.pb.tools.ImplicationRHS;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.pb.tools.XplainPB;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyHelper<T, C> {
    private static final long serialVersionUID = 1L;
    private final Map<T, Integer> mapToDimacs = new HashMap<T, Integer>();
    private final Map<Integer, T> mapToDomain = new HashMap<Integer, T>();
    final Map<IConstr, C> descs = new HashMap<IConstr, C>();
    final XplainPB xplain;

    public DependencyHelper(IPBSolver iPBSolver) {
        this.xplain = new XplainPB(iPBSolver);
    }

    int getIntValue(T t) {
        Integer n = this.mapToDimacs.get(t);
        if (n == null) {
            n = new Integer(this.xplain.nextFreeVarId(true));
            this.mapToDomain.put(n, t);
            this.mapToDimacs.put(t, n);
        }
        return n;
    }

    public IVec<T> getSolution() {
        int[] nArray = this.xplain.model();
        Vec vec = new Vec();
        for (int n : nArray) {
            if (n <= 0) continue;
            vec.push(this.mapToDomain.get(new Integer(n)));
        }
        return vec;
    }

    public boolean getBooleanValueFor(T t) {
        return this.xplain.model(this.getIntValue(t));
    }

    public boolean hasASolution() throws TimeoutException {
        return this.xplain.isSatisfiable();
    }

    public boolean hasASolution(IVec<T> iVec) throws TimeoutException {
        VecInt vecInt = new VecInt();
        Iterator iterator = iVec.iterator();
        while (iterator.hasNext()) {
            vecInt.push(this.getIntValue(iterator.next()));
        }
        return this.xplain.isSatisfiable((IVecInt)vecInt);
    }

    public boolean hasASolution(Collection<T> collection) throws TimeoutException {
        VecInt vecInt = new VecInt();
        for (T t : collection) {
            vecInt.push(this.getIntValue(t));
        }
        return this.xplain.isSatisfiable((IVecInt)vecInt);
    }

    public Set<C> why() throws TimeoutException {
        Collection collection = this.xplain.explain();
        TreeSet<C> treeSet = new TreeSet<C>();
        for (IConstr iConstr : collection) {
            C c = this.descs.get(iConstr);
            if (c == null) continue;
            treeSet.add(c);
        }
        return treeSet;
    }

    public Set<C> why(T t) throws TimeoutException {
        VecInt vecInt = new VecInt();
        vecInt.push(-this.getIntValue(t));
        return this.why((IVecInt)vecInt);
    }

    public Set<C> whyNot(T t) throws TimeoutException {
        VecInt vecInt = new VecInt();
        vecInt.push(this.getIntValue(t));
        return this.why((IVecInt)vecInt);
    }

    private Set<C> why(IVecInt iVecInt) throws TimeoutException {
        if (this.xplain.isSatisfiable(iVecInt)) {
            return Collections.emptySet();
        }
        return this.why();
    }

    public void setTrue(T t, C c) throws ContradictionException {
        VecInt vecInt = new VecInt();
        vecInt.push(this.getIntValue(t));
        this.descs.put(this.xplain.addClause((IVecInt)vecInt), c);
    }

    public void setFalse(T t, C c) throws ContradictionException {
        VecInt vecInt = new VecInt();
        vecInt.push(-this.getIntValue(t));
        this.descs.put(this.xplain.addClause((IVecInt)vecInt), c);
    }

    public ImplicationRHS<T, C> implication(T[] TArray) {
        VecInt vecInt = new VecInt();
        for (T t : TArray) {
            vecInt.push(-this.getIntValue(t));
        }
        return new ImplicationRHS(this, (IVecInt)vecInt);
    }

    public ImplicationNamer<T, C> atMost(int n, T[] TArray) throws ContradictionException {
        Vec vec = new Vec();
        VecInt vecInt = new VecInt();
        for (T t : TArray) {
            vecInt.push(this.getIntValue(t));
        }
        vec.push((Object)this.xplain.addAtMost((IVecInt)vecInt, n));
        return new ImplicationNamer(this, (IVec<IConstr>)vec);
    }

    public void setObjectiveFunction(WeightedObject<T>[] weightedObjectArray) {
        VecInt vecInt = new VecInt(weightedObjectArray.length);
        Vec vec = new Vec(weightedObjectArray.length);
        for (WeightedObject<T> weightedObject : weightedObjectArray) {
            vecInt.push(this.getIntValue(weightedObject.thing));
            vec.push((Object)weightedObject.getWeight());
        }
        ObjectiveFunction objectiveFunction = new ObjectiveFunction((IVecInt)vecInt, (IVec<BigInteger>)vec);
        this.xplain.setObjectiveFunction(objectiveFunction);
    }

    public void stopSolver() {
        this.xplain.expireTimeout();
    }

    public void stopExplanation() {
        this.xplain.cancelExplanation();
    }
}

