/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;

public class MinWatchPb
extends WatchPb {
    private static final long serialVersionUID = 1L;
    protected BigInteger watchCumul = BigInteger.ZERO;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.constraints.pb.MinWatchPb");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected MinWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.watchingCount = 0;
    }

    protected MinWatchPb(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        super(nArray, bigIntegerArray, bigInteger);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        this.watchingCount = 0;
    }

    protected void computeWatches() throws ContradictionException {
        if (!$assertionsDisabled && this.watchCumul.signum() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount != 0) {
            throw new AssertionError();
        }
        int n = 0;
        while (n < this.lits.length && this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0) {
            if (!this.voc.isFalsified(this.lits[n])) {
                this.voc.watch(this.lits[n] ^ 1, this);
                this.watching[this.watchingCount++] = n;
                this.watched[n] = true;
                this.watchCumul = this.watchCumul.add(this.coefs[n]);
            }
            ++n;
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
    }

    private void watchMoreForLearntConstraint() {
        int n = 1;
        while (this.watchCumul.subtract(this.coefs[0]).compareTo(this.degree) < 0 && n > 0) {
            n = 0;
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.lits.length) {
                if (this.voc.isFalsified(this.lits[n4]) && !this.watched[n4]) {
                    ++n;
                    int n5 = this.voc.getLevel(this.lits[n4]);
                    if (n5 > n2) {
                        n3 = n4;
                        n2 = n5;
                    }
                }
                ++n4;
            }
            if (n <= 0) continue;
            if (!$assertionsDisabled && n3 < 0) {
                throw new AssertionError();
            }
            this.voc.watch(this.lits[n3] ^ 1, this);
            this.watching[this.watchingCount++] = n3;
            this.watched[n3] = true;
            this.watchCumul = this.watchCumul.add(this.coefs[n3]);
            if (!$assertionsDisabled && --n < 0) {
                throw new AssertionError();
            }
        }
        if (!$assertionsDisabled && this.lits.length != 1 && this.watchingCount <= 1) {
            throw new AssertionError();
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < this.lits.length && this.watchCumul.subtract(this.coefs[this.watching[n]]).compareTo(this.degree) < 0) {
            if (this.voc.isUnassigned(this.lits[n]) && !unitPropagationListener.enqueue(this.lits[n], this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++n;
        }
    }

    public static MinWatchPb normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        MinWatchPb minWatchPb = new MinWatchPb(iLits, nArray, bigIntegerArray, bigInteger);
        if (minWatchPb.degree.signum() <= 0) {
            return null;
        }
        minWatchPb.computeWatches();
        minWatchPb.computePropagation(unitPropagationListener);
        return minWatchPb;
    }

    protected int nbOfWatched() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.watched.length) {
            int n3 = 0;
            while (n3 < this.watchingCount) {
                if (this.watching[n3] == n2 && !$assertionsDisabled && !this.watched[n2]) {
                    throw new AssertionError();
                }
                ++n3;
            }
            n += this.watched[n2] ? 1 : 0;
            ++n2;
        }
        return n;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.watchingCount <= 1) {
            throw new AssertionError();
        }
        int n2 = 0;
        while (n2 < this.watchingCount && (this.lits[this.watching[n2]] ^ 1) != n) {
            ++n2;
        }
        int n3 = this.watching[n2];
        if (!$assertionsDisabled && n != (this.lits[n3] ^ 1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.watched[n3]) {
            throw new AssertionError();
        }
        BigInteger bigInteger = this.maximalCoefficient(n3);
        bigInteger = this.updateWatched(bigInteger, n3);
        BigInteger bigInteger2 = this.watchCumul.subtract(this.coefs[n3]);
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        if (bigInteger2.compareTo(this.degree) < 0) {
            this.voc.watch(n, this);
            if (!$assertionsDisabled && !this.watched[n3]) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.isSatisfiable()) {
                throw new AssertionError();
            }
            return false;
        }
        if (bigInteger2.compareTo(this.degree.add(bigInteger)) < 0) {
            if (!$assertionsDisabled && this.watchingCount == 0) {
                throw new AssertionError();
            }
            BigInteger bigInteger3 = bigInteger2.subtract(this.degree);
            int n4 = 0;
            while (n4 < this.watchingCount) {
                if (bigInteger3.compareTo(this.coefs[this.watching[n4]]) < 0 && n4 != n2 && !this.voc.isSatisfied(this.lits[this.watching[n4]]) && !unitPropagationListener.enqueue(this.lits[this.watching[n4]], this)) {
                    this.voc.watch(n, this);
                    if (!$assertionsDisabled && this.isSatisfiable()) {
                        throw new AssertionError();
                    }
                    return false;
                }
                ++n4;
            }
            this.voc.undos(n).push(this);
        }
        this.watched[n3] = false;
        this.watchCumul = bigInteger2;
        this.watching[n2] = this.watching[--this.watchingCount];
        if (!$assertionsDisabled && this.watchingCount == 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.watchingCount) {
            this.voc.removeWatch(this.lits[this.watching[n]] ^ 1, this);
            this.watched[this.watching[n]] = false;
            ++n;
        }
        this.watchingCount = 0;
        if (!$assertionsDisabled && this.nbOfWatched() != this.watchingCount) {
            throw new AssertionError();
        }
    }

    public void undo(int n) {
        this.voc.watch(n, this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        if (!$assertionsDisabled && n2 >= this.lits.length) {
            throw new AssertionError();
        }
        this.watchCumul = this.watchCumul.add(this.coefs[n2]);
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
        if (!$assertionsDisabled && this.watchingCount != this.nbOfWatched()) {
            throw new AssertionError();
        }
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MinWatchPb(iLits, iDataStructurePB);
    }

    protected BigInteger maximalCoefficient(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n2 = 0;
        while (n2 < this.watchingCount) {
            if (this.coefs[this.watching[n2]].compareTo(bigInteger) > 0 && this.watching[n2] != n) {
                bigInteger = this.coefs[this.watching[n2]];
            }
            ++n2;
        }
        if (!$assertionsDisabled && !this.learnt && bigInteger.signum() == 0) {
            throw new AssertionError();
        }
        return bigInteger;
    }

    protected BigInteger updateWatched(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = bigInteger;
        if (this.watchingCount < this.size()) {
            BigInteger bigInteger3 = this.watchCumul.subtract(this.coefs[n]);
            BigInteger bigInteger4 = this.degree.add(bigInteger2);
            int n2 = 0;
            while (n2 < this.lits.length) {
                if (bigInteger3.compareTo(bigInteger4) >= 0) break;
                if (!this.voc.isFalsified(this.lits[n2]) && !this.watched[n2]) {
                    bigInteger3 = bigInteger3.add(this.coefs[n2]);
                    this.watched[n2] = true;
                    if (!$assertionsDisabled && this.watchingCount >= this.size()) {
                        throw new AssertionError();
                    }
                    this.watching[this.watchingCount++] = n2;
                    this.voc.watch(this.lits[n2] ^ 1, this);
                    if (this.coefs[n2].compareTo(bigInteger2) > 0) {
                        bigInteger2 = this.coefs[n2];
                        bigInteger4 = this.degree.add(bigInteger2);
                    }
                }
                ++n2;
            }
            this.watchCumul = bigInteger3.add(this.coefs[n]);
        }
        return bigInteger2;
    }
}

