/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.ReadOnlyVec;
import org.sat4j.core.ReadOnlyVecInt;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;

    public ObjectiveFunction(IVecInt iVecInt, IVec<BigInteger> iVec) {
        this.vars = new ReadOnlyVecInt(iVecInt);
        this.coeffs = new ReadOnlyVec(iVec);
    }

    public BigInteger calculateDegree(int[] nArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.vars.size()) {
            BigInteger bigInteger2 = (BigInteger)this.coeffs.get(n);
            if (this.varInModel(this.vars.get(n), nArray)) {
                bigInteger = bigInteger.add(bigInteger2);
            } else if (bigInteger2.signum() < 0 && !this.varInModel(-this.vars.get(n), nArray)) {
                bigInteger = bigInteger.add(bigInteger2);
            }
            ++n;
        }
        return bigInteger;
    }

    private boolean varInModel(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            if (n == nArray[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IVec<BigInteger> getCoeffs() {
        return this.coeffs;
    }

    public IVecInt getVars() {
        return this.vars;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        IVecInt iVecInt = this.getVars();
        IVec<BigInteger> iVec = this.getCoeffs();
        int n = 0;
        while (n < iVecInt.size()) {
            BigInteger bigInteger = (BigInteger)iVec.get(n);
            int n2 = iVecInt.get(n);
            if (n2 < 0) {
                n2 = -n2;
                bigInteger = bigInteger.negate();
            }
            stringBuffer.append(new StringBuffer(String.valueOf(bigInteger.signum() < 0 ? "" : "+")).append(bigInteger).append(" x").append(n2).append(" ").toString());
            ++n;
        }
        return stringBuffer.toString();
    }
}

