/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.ConflictTimerContainer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.Counter;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ICDCL;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.ISimplifier;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.LearnedConstraintsEvaluationType;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SimplificationType;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.VoidTracing;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.Lbool;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.UnitClauseProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver<D extends DataStructureFactory>
implements ISolverService,
ICDCL<D> {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    protected ILogAble out;
    protected final IVec<Constr> constrs = new Vec<Constr>();
    protected final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected ILits voc;
    private IOrder order;
    private final ActivityComparator comparator = new ActivityComparator();
    private SolverStats stats = new SolverStats();
    private LearningStrategy<D> learner;
    protected volatile boolean undertimeout;
    private long timeout = Integer.MAX_VALUE;
    private boolean timeBasedTimeout = true;
    protected D dsfactory;
    private SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    protected SearchListener slistener = new VoidTracing();
    private RestartStrategy restarter;
    private final Map<String, Counter> constrTypes = new HashMap<String, Counter>();
    private boolean isDBSimplificationAllowed = false;
    private final IVecInt learnedLiterals = new VecInt();
    private boolean verbose = false;
    private boolean keepHot = false;
    private String prefix = "c ";
    private int declaredMaxVarId = 0;
    private UnitClauseProvider unitClauseProvider = UnitClauseProvider.VOID;
    private boolean[] mseen = new boolean[0];
    private final IVecInt mpreason = new VecInt();
    private final IVecInt moutLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
        }

        public String toString() {
            return "No reason simplification";
        }
    };
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.simpleSimplification(iVecInt);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.expensiveSimplification(iVecInt);
        }

        public String toString() {
            return "Expensive reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION_WLONLY = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.expensiveSimplificationWLOnly(iVecInt);
        }

        public String toString() {
            return "Expensive reason simplification specific for WL data structure";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final IVecInt analyzetoclear = new VecInt();
    private final IVecInt analyzestack = new VecInt();
    private final IVec<Propagatable> watched = new Vec<Propagatable>();
    private final Pair analysisResult = new Pair();
    private boolean[] userbooleanmodel;
    private IVecInt unsatExplanationInTermsOfAssumptions;
    private final IVecInt implied = new VecInt();
    private final IVecInt decisions = new VecInt();
    private int[] fullmodel;
    private int[] prime;
    private double timebegin = 0.0;
    private boolean needToReduceDB;
    private ConflictTimerContainer conflictCount;
    private transient Timer timer;
    private final ConflictTimer memoryTimer = new ConflictTimerAdapter(500){
        private static final long serialVersionUID = 1L;
        final long memorybound;
        {
            this.memorybound = Runtime.getRuntime().freeMemory() / 10L;
        }

        public void run() {
            long l = Runtime.getRuntime().freeMemory();
            if (l < this.memorybound) {
                Solver.this.needToReduceDB = true;
            }
        }
    };
    public final LearnedConstraintsDeletionStrategy memory_based = this.activityBased(this.memoryTimer);
    private final ConflictTimer lbdTimer = new ConflictTimerAdapter(1000){
        private static final long serialVersionUID = 1L;
        private int nbconflict;
        private static final int MAX_CLAUSE = 5000;
        private static final int INC_CLAUSE = 1000;
        private int nextbound;
        {
            this.nbconflict = 0;
            this.nextbound = 5000;
        }

        public void run() {
            this.nbconflict += this.bound();
            if (this.nbconflict >= this.nextbound) {
                this.nextbound += 1000;
                this.nbconflict = 0;
                Solver.this.needToReduceDB = true;
            }
        }

        public void reset() {
            super.reset();
            this.nextbound = 5000;
            if (this.nbconflict >= this.nextbound) {
                this.nbconflict = 0;
                Solver.this.needToReduceDB = true;
            }
        }
    };
    public final LearnedConstraintsDeletionStrategy glucose;
    protected LearnedConstraintsDeletionStrategy learnedConstraintsDeletionStrategy = this.glucose = new Glucose2LCDS(this.lbdTimer);
    private boolean lastConflictMeansUnsat;
    protected Constr sharedConflict;
    private final Comparator<Integer> dimacsLevel = new Comparator<Integer>(){

        @Override
        public int compare(Integer n, Integer n2) {
            return Solver.this.voc.getLevel(Math.abs(n2)) - Solver.this.voc.getLevel(Math.abs(n));
        }
    };

    protected IVecInt dimacs2internal(IVecInt iVecInt) {
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(iVecInt.size());
        int n = 0;
        while (n < iVecInt.size()) {
            int n2 = iVecInt.get(n);
            if (n2 == 0) {
                throw new IllegalArgumentException("0 is not a valid variable identifier");
            }
            this.__dimacs_out.unsafePush(this.voc.getFromPool(n2));
            ++n;
        }
        return this.__dimacs_out;
    }

    @Override
    public void registerLiteral(int n) {
        this.voc.getFromPool(n);
    }

    public Solver(LearningStrategy<D> learningStrategy, D d, IOrder iOrder, RestartStrategy restartStrategy) {
        this(learningStrategy, d, new SearchParams(), iOrder, restartStrategy);
    }

    public Solver(LearningStrategy<D> learningStrategy, D d, SearchParams searchParams, IOrder iOrder, RestartStrategy restartStrategy) {
        this(learningStrategy, d, searchParams, iOrder, restartStrategy, ILogAble.CONSOLE);
    }

    public Solver(LearningStrategy<D> learningStrategy, D d, SearchParams searchParams, IOrder iOrder, RestartStrategy restartStrategy, ILogAble iLogAble) {
        this.order = iOrder;
        this.params = searchParams;
        this.restarter = restartStrategy;
        this.out = iLogAble;
        this.setDataStructureFactory(d);
        this.setLearningStrategy(learningStrategy);
    }

    @Override
    public final void setDataStructureFactory(D d) {
        this.dsfactory = d;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.voc = d.getVocabulary();
        this.order.setLits(this.voc);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    @Override
    public <S extends ISolverService> void setSearchListener(SearchListener<S> searchListener) {
        this.slistener = searchListener;
    }

    @Override
    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        return this.slistener;
    }

    @Override
    public void setLearner(LearningStrategy<D> learningStrategy) {
        this.setLearningStrategy(learningStrategy);
    }

    @Override
    public void setLearningStrategy(LearningStrategy<D> learningStrategy) {
        if (this.learner != null) {
            this.learner.setSolver(null);
        }
        this.learner = learningStrategy;
        learningStrategy.setSolver(this);
    }

    @Override
    public void setTimeout(int n) {
        this.timeout = (long)n * 1000L;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutMs(long l) {
        this.timeout = l;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
        this.timeout = n;
        this.timeBasedTimeout = false;
    }

    @Override
    public void setSearchParams(SearchParams searchParams) {
        this.params = searchParams;
    }

    @Override
    public SearchParams getSearchParams() {
        return this.params;
    }

    @Override
    public void setRestartStrategy(RestartStrategy restartStrategy) {
        this.restarter = restartStrategy;
    }

    @Override
    public RestartStrategy getRestartStrategy() {
        return this.restarter;
    }

    @Override
    public void expireTimeout() {
        this.undertimeout = false;
        if (this.timeBasedTimeout) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
        } else if (this.conflictCount != null) {
            this.conflictCount = null;
        }
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size();
    }

    @Override
    public void learn(Constr constr) {
        this.slistener.learn(constr);
        this.learnts.push(constr);
        constr.setLearnt();
        constr.register();
        ++this.stats.learnedclauses;
        switch (constr.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
            }
        }
    }

    public final int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    @Deprecated
    public int newVar() {
        int n = this.voc.nVars() + 1;
        this.voc.ensurePool(n);
        return n;
    }

    @Override
    public int newVar(int n) {
        this.voc.ensurePool(n);
        this.declaredMaxVarId = n;
        return n;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createClause(iVecInt2));
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        if (iConstr == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        Constr constr = (Constr)iConstr;
        constr.remove(this);
        this.constrs.remove(constr);
        this.clearLearntClauses();
        String string = constr.getClass().getName();
        this.constrTypes.get(string).dec();
        return true;
    }

    @Override
    public boolean removeSubsumedConstr(IConstr iConstr) {
        if (iConstr == null) {
            throw new IllegalArgumentException("Reference to the constraint to remove needed!");
        }
        if (this.constrs.last() != iConstr) {
            throw new IllegalArgumentException("Can only remove latest added constraint!!!");
        }
        Constr constr = (Constr)iConstr;
        constr.remove(this);
        this.constrs.pop();
        String string = constr.getClass().getName();
        this.constrTypes.get(string).dec();
        return true;
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        Iterator<IVecInt> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            this.addClause(iterator.next());
        }
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        int n2 = iVecInt.size();
        VecInt vecInt = new VecInt(n2);
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            vecInt.push(-iteratorInt.next());
        }
        return this.addAtLeast(vecInt, n2 - n);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(iVecInt2, n));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        constrGroup.add(this.addAtMost(iVecInt, n));
        constrGroup.add(this.addAtLeast(iVecInt, n));
        return constrGroup;
    }

    public boolean simplifyDB() {
        IVec[] iVecArray = new IVec[]{this.constrs, this.learnts};
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < iVecArray[n].size()) {
                if (((Constr)iVecArray[n].get(n3)).simplify()) {
                    ((Constr)iVecArray[n].get(n3)).remove(this);
                } else {
                    iVecArray[n].moveTo(n2++, n3);
                }
                ++n3;
            }
            iVecArray[n].shrinkTo(n2);
            ++n;
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nArray = new int[this.model.length];
        System.arraycopy(this.model, 0, nArray, 0, this.model.length);
        return nArray;
    }

    @Override
    public boolean enqueue(int n) {
        return this.enqueue(n, null);
    }

    @Override
    public boolean enqueue(int n, Constr constr) {
        assert (n > 1);
        if (this.voc.isSatisfied(n)) {
            return true;
        }
        if (this.voc.isFalsified(n)) {
            return false;
        }
        this.voc.satisfies(n);
        this.voc.setLevel(n, this.decisionLevel());
        this.voc.setReason(n, constr);
        this.trail.push(n);
        if (constr != null && constr.learnt()) {
            this.learnedConstraintsDeletionStrategy.onPropagation(constr);
        }
        return true;
    }

    public void analyze(Constr constr, Pair pair) throws TimeoutException {
        assert (constr != null);
        boolean[] blArray = this.mseen;
        IVecInt iVecInt = this.moutLearnt;
        IVecInt iVecInt2 = this.mpreason;
        iVecInt.clear();
        assert (iVecInt.size() == 0);
        int n = 0;
        while (n < blArray.length) {
            blArray[n] = false;
            ++n;
        }
        n = 0;
        int n2 = -1;
        iVecInt.push(-1);
        int n3 = 0;
        Constr constr2 = null;
        do {
            iVecInt2.clear();
            assert (constr != null);
            if (constr2 != constr) {
                constr.calcReason(n2, iVecInt2);
                this.learnedConstraintsDeletionStrategy.onConflictAnalysis(constr);
                int n4 = 0;
                while (n4 < iVecInt2.size()) {
                    int n5 = iVecInt2.get(n4);
                    this.order.updateVar(n5);
                    if (!blArray[n5 >> 1]) {
                        blArray[n5 >> 1] = true;
                        if (this.voc.getLevel(n5) == this.decisionLevel()) {
                            ++n;
                            this.order.updateVarAtDecisionLevel(n5);
                        } else if (this.voc.getLevel(n5) > 0) {
                            iVecInt.push(n5 ^ 1);
                            n3 = Math.max(n3, this.voc.getLevel(n5));
                        }
                    }
                    ++n4;
                }
            }
            constr2 = constr;
            do {
                n2 = this.trail.last();
                constr = this.voc.getReason(n2);
                this.undoOne();
            } while (!blArray[n2 >> 1]);
        } while (--n > 0);
        iVecInt.set(0, n2 ^ 1);
        this.simplifier.simplify(iVecInt);
        Constr constr3 = this.dsfactory.createUnregisteredClause(iVecInt);
        this.learnedConstraintsDeletionStrategy.onClauseLearning(constr3);
        pair.reason = constr3;
        assert (n3 > -1);
        pair.backtrackLevel = n3;
    }

    /*
     * Unable to fully structure code
     */
    public IVecInt analyzeFinalConflictInTermsOfAssumptions(Constr var1_1, IVecInt var2_2, int var3_3) {
        if (var2_2.size() != 0) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            this.trailLim.pop();
lbl5:
            // 2 sources

            ** while (!this.trailLim.isEmpty() && this.trailLim.last() == this.trail.size())
        }
lbl6:
        // 1 sources

        var4_4 = this.mseen;
        var5_5 = this.moutLearnt;
        var6_6 = this.mpreason;
        var5_5.clear();
        if (this.trailLim.size() == 0) {
            return var5_5;
        }
        if (!Solver.$assertionsDisabled && var5_5.size() != 0) {
            throw new AssertionError();
        }
        var7_7 = 0;
        while (var7_7 < var4_4.length) {
            var4_4[var7_7] = false;
            ++var7_7;
        }
        if (var1_1 == null) {
            var4_4[var3_3 >> 1] = true;
        }
        var7_7 = -1;
        while (var1_1 == null && this.trail.size() > 0 && this.trailLim.size() > 0) {
            var7_7 = this.trail.last();
            var1_1 = this.voc.getReason(var7_7);
            this.undoOne();
            if (var1_1 == null && var7_7 == (var3_3 ^ 1)) {
                var5_5.push(LiteralsUtils.toDimacs(var7_7));
            }
            if (this.trail.size() > this.trailLim.last()) continue;
            this.trailLim.pop();
        }
        if (var1_1 == null) {
            return var5_5;
        }
        do {
            var6_6.clear();
            var1_1.calcReason(var7_7, var6_6);
            var8_8 = 0;
            while (var8_8 < var6_6.size()) {
                var9_9 = var6_6.get(var8_8);
                if (!var4_4[var9_9 >> 1]) {
                    var4_4[var9_9 >> 1] = true;
                    if (this.voc.getReason(var9_9) == null && this.voc.getLevel(var9_9) > 0) {
                        if (!Solver.$assertionsDisabled && !var2_2.contains(LiteralsUtils.toDimacs(var9_9))) {
                            throw new AssertionError();
                        }
                        var5_5.push(LiteralsUtils.toDimacs(var9_9));
                    }
                }
                ++var8_8;
            }
            do {
                var7_7 = this.trail.last();
                var1_1 = this.voc.getReason(var7_7);
                this.undoOne();
                if (this.decisionLevel() <= 0 || this.trail.size() > this.trailLim.last()) continue;
                this.trailLim.pop();
            } while (this.trail.size() > 0 && this.decisionLevel() > 0 && (!var4_4[var7_7 >> 1] || var1_1 == null));
        } while (this.decisionLevel() > 0);
        return var5_5;
    }

    @Override
    public void setSimplifier(SimplificationType simplificationType) {
        try {
            Field field = Solver.class.getDeclaredField(simplificationType.toString());
            this.simplifier = (ISimplifier)field.get(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.simplifier = NO_SIMPLIFICATION;
        }
    }

    @Override
    public void setSimplifier(ISimplifier iSimplifier) {
        this.simplifier = iSimplifier;
    }

    @Override
    public ISimplifier getSimplifier() {
        return this.simplifier;
    }

    private void simpleSimplification(IVecInt iVecInt) {
        boolean[] blArray = this.mseen;
        int n = 1;
        int n2 = 1;
        while (n2 < iVecInt.size()) {
            Constr constr = this.voc.getReason(iVecInt.get(n2));
            if (constr == null || constr.canBePropagatedMultipleTimes()) {
                iVecInt.moveTo(n++, n2);
            } else {
                int n3 = 0;
                while (n3 < constr.size()) {
                    int n4 = constr.get(n3);
                    if (!blArray[n4 >> 1] && this.voc.isFalsified(n4) && this.voc.getLevel(n4) != 0) {
                        iVecInt.moveTo(n++, n2);
                        break;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        iVecInt.shrink(n2 - n);
        this.stats.reducedliterals += (long)(n2 - n);
    }

    private void expensiveSimplification(IVecInt iVecInt) {
        this.analyzetoclear.clear();
        iVecInt.copyTo(this.analyzetoclear);
        int n = 1;
        int n2 = 1;
        while (n < iVecInt.size()) {
            if (this.voc.getReason(iVecInt.get(n)) == null || !this.analyzeRemovable(iVecInt.get(n))) {
                iVecInt.moveTo(n2++, n);
            }
            ++n;
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    private boolean analyzeRemovable(int n) {
        assert (this.voc.getReason(n) != null);
        ILits iLits = this.voc;
        IVecInt iVecInt = this.analyzestack;
        IVecInt iVecInt2 = this.analyzetoclear;
        iVecInt.clear();
        iVecInt.push(n);
        boolean[] blArray = this.mseen;
        int n2 = iVecInt2.size();
        while (iVecInt.size() > 0) {
            int n3;
            int n4 = iVecInt.last();
            assert (iLits.getReason(n4) != null);
            Constr constr = iLits.getReason(n4);
            iVecInt.pop();
            if (constr.canBePropagatedMultipleTimes()) {
                n3 = n2;
                while (n3 < iVecInt2.size()) {
                    blArray[iVecInt2.get((int)n3) >> 1] = false;
                    ++n3;
                }
                iVecInt2.shrink(iVecInt2.size() - n2);
                return false;
            }
            n3 = 0;
            while (n3 < constr.size()) {
                int n5 = constr.get(n3);
                if (!blArray[LiteralsUtils.var(n5)] && iLits.isFalsified(n5) && iLits.getLevel(n5) != 0) {
                    if (iLits.getReason(n5) == null) {
                        int n6 = n2;
                        while (n6 < iVecInt2.size()) {
                            blArray[iVecInt2.get((int)n6) >> 1] = false;
                            ++n6;
                        }
                        iVecInt2.shrink(iVecInt2.size() - n2);
                        return false;
                    }
                    blArray[n5 >> 1] = true;
                    iVecInt.push(n5);
                    iVecInt2.push(n5);
                }
                ++n3;
            }
        }
        return true;
    }

    private void expensiveSimplificationWLOnly(IVecInt iVecInt) {
        this.analyzetoclear.clear();
        iVecInt.copyTo(this.analyzetoclear);
        int n = 1;
        int n2 = 1;
        while (n < iVecInt.size()) {
            if (this.voc.getReason(iVecInt.get(n)) == null || !this.analyzeRemovableWLOnly(iVecInt.get(n))) {
                iVecInt.moveTo(n2++, n);
            }
            ++n;
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    private boolean analyzeRemovableWLOnly(int n) {
        assert (this.voc.getReason(n) != null);
        this.analyzestack.clear();
        this.analyzestack.push(n);
        boolean[] blArray = this.mseen;
        int n2 = this.analyzetoclear.size();
        while (this.analyzestack.size() > 0) {
            int n3 = this.analyzestack.last();
            assert (this.voc.getReason(n3) != null);
            Constr constr = this.voc.getReason(n3);
            this.analyzestack.pop();
            int n4 = 1;
            while (n4 < constr.size()) {
                int n5 = constr.get(n4);
                if (!blArray[LiteralsUtils.var(n5)] && this.voc.getLevel(n5) != 0) {
                    if (this.voc.getReason(n5) == null) {
                        int n6 = n2;
                        while (n6 < this.analyzetoclear.size()) {
                            blArray[this.analyzetoclear.get((int)n6) >> 1] = false;
                            ++n6;
                        }
                        this.analyzetoclear.shrink(this.analyzetoclear.size() - n2);
                        return false;
                    }
                    blArray[n5 >> 1] = true;
                    this.analyzestack.push(n5);
                    this.analyzetoclear.push(n5);
                }
                ++n4;
            }
        }
        return true;
    }

    protected void undoOne() {
        int n = this.trail.last();
        assert (n > 1);
        assert (this.voc.getLevel(n) >= 0);
        int n2 = n >> 1;
        this.voc.unassign(n);
        this.voc.setReason(n, null);
        this.voc.setLevel(n, -1);
        this.order.undo(n2);
        this.trail.pop();
        IVec<Undoable> iVec = this.voc.undos(n);
        assert (iVec != null);
        int n3 = iVec.size();
        while (n3 > 0) {
            iVec.last().undo(n);
            iVec.pop();
            --n3;
        }
    }

    @Override
    public void claBumpActivity(Constr constr) {
        constr.incActivity(this.claInc);
        if (constr.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int n) {
        this.order.updateVar(n);
    }

    private void claRescalActivity() {
        int n = 0;
        while (n < this.learnts.size()) {
            this.learnts.get(n).rescaleBy(1.0E-20);
            ++n;
        }
        this.claInc *= 1.0E-20;
    }

    public final Constr propagate() {
        IVecInt iVecInt = this.trail;
        SolverStats solverStats = this.stats;
        IOrder iOrder = this.order;
        SearchListener searchListener = this.slistener;
        while (this.qhead < iVecInt.size()) {
            ++solverStats.propagations;
            int n = iVecInt.get(this.qhead++);
            searchListener.propagating(LiteralsUtils.toDimacs(n), null);
            iOrder.assignLiteral(n);
            Constr constr = this.reduceClausesForFalsifiedLiteral(n);
            if (constr == null) continue;
            return constr;
        }
        return null;
    }

    private Constr reduceClausesForFalsifiedLiteral(int n) {
        assert (n > 1);
        IVec<Propagatable> iVec = this.watched;
        iVec.clear();
        this.voc.watches(n).moveTo(iVec);
        int n2 = iVec.size();
        int n3 = 0;
        while (n3 < n2) {
            ++this.stats.inspects;
            if (!iVec.get(n3).propagate(this, n)) {
                int n4 = iVec.size();
                int n5 = n3 + 1;
                while (n5 < n4) {
                    this.voc.watch(n, iVec.get(n5));
                    ++n5;
                }
                this.qhead = this.trail.size();
                return iVec.get(n3).toConstraint();
            }
            ++n3;
        }
        return null;
    }

    void record(Constr constr) {
        constr.assertConstraint(this);
        int n = LiteralsUtils.toDimacs(constr.get(0));
        this.slistener.adding(n);
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
            this.slistener.learnUnit(n);
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int n) {
        assert (this.trail.size() == this.qhead);
        assert (!this.trailLim.contains(this.trail.size()));
        this.trailLim.push(this.trail.size());
        return this.enqueue(n);
    }

    private void cancel() {
        int n = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(LiteralsUtils.toDimacs(n));
        int n2 = this.trail.size() - this.trailLim.last();
        while (n2 > 0) {
            this.undoOne();
            --n2;
        }
        this.trailLim.pop();
        this.qhead = this.trail.size();
    }

    private void cancelLearntLiterals(int n) {
        this.learnedLiterals.clear();
        while (this.trail.size() > n) {
            this.learnedLiterals.push(this.trail.last());
            this.undoOne();
        }
    }

    protected void cancelUntil(int n) {
        while (this.decisionLevel() > n) {
            this.cancel();
        }
    }

    Lbool search(IVecInt iVecInt) {
        assert (this.rootLevel == this.decisionLevel());
        ++this.stats.starts;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            int n;
            this.slistener.beginLoop();
            Constr constr = this.propagate();
            assert (this.trail.size() == this.qhead);
            if (constr == null) {
                if (this.decisionLevel() == 0 && this.isDBSimplificationAllowed) {
                    ++this.stats.rootSimplifications;
                    n = this.simplifyDB();
                    assert (n != 0);
                }
                assert (this.nAssigns() <= this.voc.realnVars());
                if (this.nAssigns() == this.voc.realnVars()) {
                    this.modelFound();
                    this.slistener.solutionFound(this.fullmodel != null ? this.fullmodel : this.model, this);
                    if (this.sharedConflict == null) {
                        this.cancelUntil(this.rootLevel);
                        return Lbool.TRUE;
                    }
                    constr = this.sharedConflict;
                } else {
                    if (this.restarter.shouldRestart()) {
                        this.cancelUntil(this.rootLevel);
                        return Lbool.UNDEFINED;
                    }
                    if (this.needToReduceDB) {
                        this.reduceDB();
                        this.needToReduceDB = false;
                    }
                    if (this.sharedConflict == null) {
                        ++this.stats.decisions;
                        n = this.order.select();
                        if (n == -1) {
                            constr = this.preventTheSameDecisionsToBeMade();
                            this.lastConflictMeansUnsat = false;
                        } else {
                            assert (n > 1);
                            this.slistener.assuming(LiteralsUtils.toDimacs(n));
                            boolean bl = this.assume(n);
                            assert (bl);
                        }
                    } else {
                        constr = this.sharedConflict;
                    }
                }
            }
            if (constr == null) continue;
            ++this.stats.conflicts;
            this.slistener.conflictFound(constr, this.decisionLevel(), this.trail.size());
            this.conflictCount.newConflict();
            if (this.decisionLevel() == this.rootLevel) {
                if (this.lastConflictMeansUnsat) {
                    this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(constr, iVecInt, -1);
                    return Lbool.FALSE;
                }
                return Lbool.UNDEFINED;
            }
            n = this.trail.size();
            try {
                this.analyze(constr, this.analysisResult);
            }
            catch (TimeoutException timeoutException) {
                return Lbool.UNDEFINED;
            }
            assert (this.analysisResult.backtrackLevel < this.decisionLevel());
            int n2 = Math.max(this.analysisResult.backtrackLevel, this.rootLevel);
            this.slistener.backjump(n2);
            this.cancelUntil(n2);
            if (n2 == this.rootLevel) {
                this.restarter.onBackjumpToRootLevel();
            }
            if (constr == this.sharedConflict) {
                this.sharedConflict.assertConstraintIfNeeded(this);
                this.sharedConflict = null;
            }
            assert (this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= this.analysisResult.backtrackLevel);
            if (this.analysisResult.reason == null) {
                return Lbool.FALSE;
            }
            this.record(this.analysisResult.reason);
            this.restarter.newLearnedClause(this.analysisResult.reason, n);
            this.analysisResult.reason = null;
            this.decayActivities();
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    private Constr preventTheSameDecisionsToBeMade() {
        VecInt vecInt = new VecInt(this.nVars());
        int n = this.trail.size() - 1;
        while (n >= this.rootLevel) {
            int n2 = this.trail.get(n);
            if (this.voc.getReason(n2) == null) {
                vecInt.push(n2 ^ 1);
            }
            --n;
        }
        return this.dsfactory.createUnregisteredClause(vecInt);
    }

    protected void analyzeAtRootLevel(Constr constr) {
    }

    void modelFound() {
        int n;
        VecInt vecInt = new VecInt(this.nVars());
        this.userbooleanmodel = new boolean[this.realNumberOfVariables()];
        this.fullmodel = null;
        int n2 = 1;
        while (n2 <= this.nVars()) {
            if (this.voc.belongsToPool(n2) && !this.voc.isUnassigned(n = this.voc.getFromPool(n2))) {
                vecInt.push(this.voc.isSatisfied(n) ? n2 : -n2);
                this.userbooleanmodel[n2 - 1] = this.voc.isSatisfied(n);
                if (this.voc.getReason(n) == null && this.voc.getLevel(n) > 0) {
                    this.decisions.push(vecInt.last());
                } else {
                    this.implied.push(vecInt.last());
                }
            }
            ++n2;
        }
        this.model = new int[vecInt.size()];
        vecInt.copyTo(this.model);
        if (this.realNumberOfVariables() > this.nVars()) {
            n2 = this.nVars() + 1;
            while (n2 <= this.realNumberOfVariables()) {
                if (this.voc.belongsToPool(n2) && !this.voc.isUnassigned(n = this.voc.getFromPool(n2))) {
                    vecInt.push(this.voc.isSatisfied(n) ? n2 : -n2);
                    this.userbooleanmodel[n2 - 1] = this.voc.isSatisfied(n);
                    if (this.voc.getReason(n) == null) {
                        this.decisions.push(vecInt.last());
                    } else {
                        this.implied.push(vecInt.last());
                    }
                }
                ++n2;
            }
            this.fullmodel = new int[vecInt.size()];
            vecInt.moveTo(this.fullmodel);
        } else {
            this.fullmodel = this.model;
        }
    }

    private Constr forget(int n) {
        boolean bl = this.voc.isSatisfied(LiteralsUtils.toInternal(n));
        this.voc.forgets(n);
        Constr constr = bl ? this.reduceClausesForFalsifiedLiteral(LiteralsUtils.toInternal(-n)) : this.reduceClausesForFalsifiedLiteral(LiteralsUtils.toInternal(n));
        return constr;
    }

    private boolean setAndPropagate(int n) {
        if (this.voc.isUnassigned(n)) {
            assert (!this.trail.contains(n));
            assert (!this.trail.contains(LiteralsUtils.neg(n)));
            return this.assume(n) && this.propagate() == null;
        }
        return this.voc.isSatisfied(n);
    }

    @Override
    public int[] primeImplicant() {
        int n;
        assert (this.qhead == this.trail.size() + this.learnedLiterals.size());
        if (this.learnedLiterals.size() > 0) {
            this.qhead = this.trail.size();
        }
        if (this.isVerbose()) {
            System.out.printf("%s implied: %d, decision: %d %n", this.getLogPrefix(), this.implied.size(), this.decisions.size());
        }
        this.prime = new int[this.realNumberOfVariables() + 1];
        int n2 = 0;
        while (n2 < this.prime.length) {
            this.prime[n2] = 0;
            ++n2;
        }
        IteratorInt iteratorInt = this.implied.iterator();
        while (iteratorInt.hasNext()) {
            n = iteratorInt.next();
            int n3 = LiteralsUtils.toInternal(n);
            this.prime[Math.abs((int)n)] = n;
            n2 = this.setAndPropagate(n3) ? 1 : 0;
            assert (n2 != 0);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.decisions.size()) {
            n = this.decisions.get(n8);
            assert (!this.voc.isFalsified(LiteralsUtils.toInternal(n)));
            if (this.voc.isSatisfied(LiteralsUtils.toInternal(n))) {
                this.prime[Math.abs((int)n)] = n;
                ++n5;
            } else if (this.setAndPropagate(LiteralsUtils.toInternal(-n))) {
                boolean bl = true;
                ++n6;
                int n9 = this.currentDecisionLevel();
                int n10 = n8 + 1;
                while (n10 < this.decisions.size()) {
                    ++n7;
                    if (!this.setAndPropagate(LiteralsUtils.toInternal(this.decisions.get(n10)))) {
                        bl = false;
                        break;
                    }
                    ++n10;
                }
                this.cancelUntil(n9);
                if (bl) {
                    this.forget(Math.abs(n));
                    Constr constr = this.propagate();
                    assert (constr == null);
                    ++n4;
                } else {
                    this.prime[Math.abs((int)n)] = n;
                    this.cancel();
                    assert (this.voc.isUnassigned(LiteralsUtils.toInternal(n)));
                    n2 = this.setAndPropagate(LiteralsUtils.toInternal(n)) ? 1 : 0;
                    assert (n2 != 0);
                }
            } else {
                this.prime[Math.abs((int)n)] = n;
                this.cancel();
                n2 = this.setAndPropagate(LiteralsUtils.toInternal(n)) ? 1 : 0;
                assert (n2 != 0);
            }
            ++n8;
        }
        this.cancelUntil(0);
        int[] nArray = new int[this.prime.length - n4 - 1];
        int n11 = 0;
        int[] nArray2 = this.prime;
        int n12 = this.prime.length;
        int n13 = 0;
        while (n13 < n12) {
            int n14 = nArray2[n13];
            if (n14 != 0) {
                nArray[n11++] = n14;
            }
            ++n13;
        }
        if (this.isVerbose()) {
            System.out.printf("%s prime implicant computation statistics%n", this.getLogPrefix());
            System.out.printf("%s implied: %d, decision: %d (removed %d, tested %d, propagated %d), l2 propagation:%d%n", this.getLogPrefix(), this.implied.size(), this.decisions.size(), n4, n6, n5, n7);
        }
        return nArray;
    }

    @Override
    public boolean primeImplicant(int n) {
        if (n == 0 || Math.abs(n) > this.realNumberOfVariables()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.prime == null) {
            throw new UnsupportedOperationException("Call the primeImplicant method first!!!");
        }
        return this.prime[Math.abs(n)] == n;
    }

    @Override
    public boolean model(int n) {
        if (n <= 0 || n > this.realNumberOfVariables()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.userbooleanmodel == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        return this.userbooleanmodel[n - 1];
    }

    @Override
    public void clearLearntClauses() {
        Iterator<Constr> iterator = this.learnts.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove(this);
        }
        this.learnts.clear();
        this.learnedLiterals.clear();
    }

    protected final void reduceDB() {
        ++this.stats.reduceddb;
        this.slistener.cleaning();
        this.learnedConstraintsDeletionStrategy.reduce(this.learnts);
        System.gc();
    }

    protected void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.isSatisfiable(iVecInt, false);
    }

    public final LearnedConstraintsDeletionStrategy fixedSize(final int n) {
        return new LearnedConstraintsDeletionStrategy(){
            private static final long serialVersionUID = 1L;
            private final ConflictTimer aTimer;
            {
                this.aTimer = new ConflictTimerAdapter(n2){
                    private static final long serialVersionUID = 1L;

                    public void run() {
                        Solver.this.needToReduceDB = true;
                    }
                };
            }

            @Override
            public void reduce(IVec<Constr> iVec) {
                int n4 = 0;
                int n2 = 0;
                int n3 = 0;
                while (n3 < Solver.this.learnts.size() && Solver.this.learnts.size() - n4 > n) {
                    Constr constr = Solver.this.learnts.get(n3);
                    if (constr.locked() || constr.size() == 2) {
                        Solver.this.learnts.set(n2++, Solver.this.learnts.get(n3));
                    } else {
                        constr.remove(Solver.this);
                        ++n4;
                    }
                    ++n3;
                }
                while (n3 < Solver.this.learnts.size()) {
                    Solver.this.learnts.set(n2++, Solver.this.learnts.get(n3));
                    ++n3;
                }
                if (Solver.this.verbose) {
                    Solver.this.out.log(String.valueOf(Solver.this.getLogPrefix()) + "cleaning " + (Solver.this.learnts.size() - n2) + " clauses out of " + Solver.this.learnts.size());
                }
                Solver.this.learnts.shrinkTo(n2);
            }

            @Override
            public void onConflictAnalysis(Constr constr) {
            }

            @Override
            public void onClauseLearning(Constr constr) {
            }

            public String toString() {
                return "Fixed size (" + n + ") learned constraints deletion strategy";
            }

            @Override
            public void init() {
            }

            @Override
            public ConflictTimer getTimer() {
                return this.aTimer;
            }

            @Override
            public void onPropagation(Constr constr) {
            }
        };
    }

    private LearnedConstraintsDeletionStrategy activityBased(ConflictTimer conflictTimer) {
        return new LearnedConstraintsDeletionStrategy(conflictTimer){
            private static final long serialVersionUID = 1L;
            private final ConflictTimer freeMem;
            {
                this.freeMem = conflictTimer;
            }

            @Override
            public void reduce(IVec<Constr> iVec) {
                Solver.this.sortOnActivity();
                int n = 0;
                int n2 = 0;
                while (n2 < Solver.this.learnts.size() / 2) {
                    Constr constr = Solver.this.learnts.get(n2);
                    if (constr.locked() || constr.size() == 2) {
                        Solver.this.learnts.set(n++, Solver.this.learnts.get(n2));
                    } else {
                        constr.remove(Solver.this);
                    }
                    ++n2;
                }
                while (n2 < Solver.this.learnts.size()) {
                    Solver.this.learnts.set(n++, Solver.this.learnts.get(n2));
                    ++n2;
                }
                if (Solver.this.verbose) {
                    Solver.this.out.log(String.valueOf(Solver.this.getLogPrefix()) + "cleaning " + (Solver.this.learnts.size() - n) + " clauses out of " + Solver.this.learnts.size());
                }
                Solver.this.learnts.shrinkTo(n);
            }

            @Override
            public ConflictTimer getTimer() {
                return this.freeMem;
            }

            public String toString() {
                return "Memory based learned constraints deletion strategy";
            }

            @Override
            public void init() {
            }

            @Override
            public void onClauseLearning(Constr constr) {
            }

            @Override
            public void onConflictAnalysis(Constr constr) {
                if (constr.learnt()) {
                    Solver.this.claBumpActivity(constr);
                }
            }

            @Override
            public void onPropagation(Constr constr) {
            }
        };
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(LearnedConstraintsDeletionStrategy learnedConstraintsDeletionStrategy) {
        if (this.conflictCount != null) {
            this.conflictCount.add(learnedConstraintsDeletionStrategy.getTimer());
            assert (this.learnedConstraintsDeletionStrategy != null);
            this.conflictCount.remove(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        this.learnedConstraintsDeletionStrategy = learnedConstraintsDeletionStrategy;
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        int n;
        Object object;
        Lbool lbool = Lbool.UNDEFINED;
        boolean bl2 = this.conflictCount != null;
        int n2 = this.voc.nVars();
        if (this.mseen.length <= n2) {
            this.mseen = new boolean[n2 + 1];
        }
        this.trail.ensure(n2);
        this.trailLim.ensure(n2);
        this.learnedLiterals.ensure(n2);
        this.decisions.clear();
        this.implied.clear();
        this.slistener.init(this);
        this.slistener.start();
        this.model = null;
        this.userbooleanmodel = null;
        this.prime = null;
        this.unsatExplanationInTermsOfAssumptions = null;
        if (!bl2 || !this.keepHot) {
            this.order.init();
        }
        this.learnedConstraintsDeletionStrategy.init();
        int n3 = this.trail.size();
        this.qhead = 0;
        int n4 = n3 - 1;
        while (n4 >= 0) {
            int n5 = this.trail.get(n4);
            object = this.voc.undos(n5);
            assert (object != null);
            n = object.size();
            while (n > 0) {
                object.last().undo(n5);
                object.pop();
                --n;
            }
            --n4;
        }
        Object object2 = this.learnedLiterals.iterator();
        while (object2.hasNext()) {
            this.enqueue(object2.next());
        }
        object2 = this.propagate();
        if (object2 != null) {
            this.analyzeAtRootLevel((Constr)object2);
            this.slistener.conflictFound((IConstr)object2, 0, 0);
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(n3);
            return false;
        }
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n6 = iteratorInt.next();
            n = this.voc.getFromPool(n6);
            if ((this.voc.isSatisfied(n) || this.assume(n)) && (object2 = this.propagate()) == null) continue;
            if (object2 == null) {
                this.slistener.conflictFound(n);
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions(null, iVecInt, n);
                this.unsatExplanationInTermsOfAssumptions.push(n6);
            } else {
                this.slistener.conflictFound((IConstr)object2, this.decisionLevel(), this.trail.size());
                this.unsatExplanationInTermsOfAssumptions = this.analyzeFinalConflictInTermsOfAssumptions((Constr)object2, iVecInt, -1);
            }
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            this.cancelLearntLiterals(n3);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        if (!bl2 || !this.keepHot) {
            this.order.init();
        }
        this.learner.init();
        if (!bl2) {
            this.conflictCount = new ConflictTimerContainer();
            this.conflictCount.add(this.restarter);
            this.conflictCount.add(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        boolean bl3 = false;
        if (this.timeBasedTimeout) {
            if (!bl || this.timer == null) {
                bl3 = true;
                this.undertimeout = true;
                object = new TimerTask(){

                    public void run() {
                        Solver.this.undertimeout = false;
                    }
                };
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)object, this.timeout);
            }
        } else if (!bl || !bl2) {
            bl3 = true;
            this.undertimeout = true;
            object = new ConflictTimerAdapter((int)this.timeout){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Solver.this.undertimeout = false;
                }
            };
            this.conflictCount.add((ConflictTimer)object);
        }
        if (!bl || bl3) {
            this.restarter.init(this.params, this.stats);
            this.timebegin = System.currentTimeMillis();
        }
        this.needToReduceDB = false;
        this.lastConflictMeansUnsat = true;
        while (lbool == Lbool.UNDEFINED && this.undertimeout && this.lastConflictMeansUnsat) {
            int n7 = this.trail.size();
            this.unitClauseProvider.provideUnitClauses(this);
            this.stats.importedUnits += this.trail.size() - n7;
            lbool = this.search(iVecInt);
            if (lbool != Lbool.UNDEFINED) continue;
            this.restarter.onRestart();
            this.slistener.restarting();
        }
        this.cancelUntil(0);
        this.cancelLearntLiterals(n3);
        if (!bl && this.timeBasedTimeout && this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.slistener.end(lbool);
        if (!this.undertimeout) {
            String string = " Timeout (" + this.timeout + (this.timeBasedTimeout ? "s" : " conflicts") + ") exceeded";
            throw new TimeoutException(string);
        }
        if (lbool == Lbool.UNDEFINED && !this.lastConflictMeansUnsat) {
            throw new TimeoutException("Cannot decide the satisfiability");
        }
        return this.model != null;
    }

    @Override
    public void printInfos(PrintWriter printWriter) {
        this.printInfos(printWriter, this.prefix);
    }

    @Override
    public void printInfos(PrintWriter printWriter, String string) {
        printWriter.print(string);
        printWriter.println("constraints type ");
        long l = 0L;
        for (Map.Entry<String, Counter> entry : this.constrTypes.entrySet()) {
            printWriter.println(String.valueOf(string) + entry.getKey() + " => " + entry.getValue());
            l += (long)entry.getValue().getValue();
        }
        printWriter.print(string);
        printWriter.print(l);
        printWriter.println(" constraints processed.");
    }

    public void printLearntClausesInfos(PrintWriter printWriter, String string) {
        HashMap<Object, Counter> hashMap = new HashMap<Object, Counter>();
        Iterator<Constr> object2 = this.learnts.iterator();
        while (object2.hasNext()) {
            String string2 = object2.next().getClass().getName();
            Counter counter = (Counter)hashMap.get(string2);
            if (counter == null) {
                hashMap.put(string2, new Counter());
                continue;
            }
            counter.inc();
        }
        printWriter.print(string);
        printWriter.println("learnt constraints type ");
        for (Map.Entry entry : hashMap.entrySet()) {
            printWriter.println(String.valueOf(string) + (String)entry.getKey() + " => " + entry.getValue());
        }
    }

    @Override
    public SolverStats getStats() {
        return this.stats;
    }

    protected void initStats(SolverStats solverStats) {
        this.stats = solverStats;
    }

    @Override
    public IOrder getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(IOrder iOrder) {
        this.order = iOrder;
        this.order.setLits(this.voc);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.trail.clear();
        this.trailLim.clear();
        this.qhead = 0;
        Iterator<Constr> iterator = this.constrs.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove(this);
        }
        this.constrs.clear();
        this.clearLearntClauses();
        this.voc.resetPool();
        this.dsfactory.reset();
        this.stats.reset();
        this.constrTypes.clear();
    }

    @Override
    public int nVars() {
        if (this.declaredMaxVarId == 0) {
            return this.voc.nVars();
        }
        return this.declaredMaxVarId;
    }

    protected IConstr addConstr(Constr constr) {
        if (constr == null) {
            Counter counter = this.constrTypes.get("ignored satisfied constraints");
            if (counter == null) {
                this.constrTypes.put("ignored satisfied constraints", new Counter());
            } else {
                counter.inc();
            }
        } else {
            this.constrs.push(constr);
            String string = constr.getClass().getName();
            Counter counter = this.constrTypes.get(string);
            if (counter == null) {
                this.constrTypes.put(string, new Counter());
            } else {
                counter.inc();
            }
        }
        return constr;
    }

    public DataStructureFactory getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.moutLearnt;
    }

    public IConstr getIthConstr(int n) {
        return this.constrs.get(n);
    }

    @Override
    public void printStat(PrintStream printStream, String string) {
        this.printStat(new PrintWriter(printStream, true), string);
    }

    @Override
    public void printStat(PrintWriter printWriter) {
        this.printStat(printWriter, this.prefix);
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
        this.stats.printStat(printWriter, string);
        double d = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        printWriter.println(String.valueOf(string) + "speed (assignments/second)\t: " + (double)this.stats.propagations / d);
        this.order.printStat(printWriter, string);
        this.printLearntClausesInfos(printWriter, string);
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new Object[]{this.dsfactory, this.learner, this.params, this.order, this.simplifier, this.restarter, this.learnedConstraintsDeletionStrategy};
        stringBuffer.append(string);
        stringBuffer.append("--- Begin Solver configuration ---");
        stringBuffer.append("\n");
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            stringBuffer.append(string);
            stringBuffer.append(object.toString());
            stringBuffer.append("\n");
            ++n2;
        }
        stringBuffer.append(string);
        stringBuffer.append("timeout=");
        if (this.timeBasedTimeout) {
            stringBuffer.append(this.timeout / 1000L);
            stringBuffer.append("s\n");
        } else {
            stringBuffer.append(this.timeout);
            stringBuffer.append(" conflicts\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("DB Simplification allowed=");
        stringBuffer.append(this.isDBSimplificationAllowed);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        if (this.isSolverKeptHot()) {
            stringBuffer.append("Heuristics kept accross calls (keep the solver \"hot\")\n");
            stringBuffer.append(string);
        }
        stringBuffer.append("Listener: ");
        stringBuffer.append(this.slistener);
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("--- End Solver configuration ---");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return (int)(this.timeBasedTimeout ? this.timeout / 1000L : this.timeout);
    }

    @Override
    public long getTimeoutMs() {
        if (!this.timeBasedTimeout) {
            throw new UnsupportedOperationException("The timeout is given in number of conflicts!");
        }
        return this.timeout;
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.constrs.ensure(n);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.stats.toMap();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        if (this.isSatisfiable(iVecInt)) {
            return this.model();
        }
        return null;
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return this.isDBSimplificationAllowed;
    }

    @Override
    public void setDBSimplificationAllowed(boolean bl) {
        this.isDBSimplificationAllowed = bl;
    }

    @Override
    public int nextFreeVarId(boolean bl) {
        return this.voc.nextFreeVarId(bl);
    }

    @Override
    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        return this.addClause(iVecInt);
    }

    @Override
    public void unset(int n) {
        if (this.voc.isUnassigned(n) || this.trail.isEmpty()) {
            return;
        }
        int n2 = this.trail.last();
        while (n2 != n) {
            this.undoOne();
            if (this.trail.isEmpty()) {
                return;
            }
            n2 = this.trail.last();
        }
        this.undoOne();
        this.qhead = this.trail.size();
    }

    @Override
    public void setLogPrefix(String string) {
        this.prefix = string;
    }

    @Override
    public String getLogPrefix() {
        return this.prefix;
    }

    @Override
    public IVecInt unsatExplanation() {
        VecInt vecInt = new VecInt(this.unsatExplanationInTermsOfAssumptions.size());
        this.unsatExplanationInTermsOfAssumptions.copyTo(vecInt);
        return vecInt;
    }

    @Override
    public int[] modelWithInternalVariables() {
        int[] nArray;
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        if (this.nVars() == this.realNumberOfVariables()) {
            nArray = new int[this.model.length];
            System.arraycopy(this.model, 0, nArray, 0, nArray.length);
        } else {
            nArray = new int[this.fullmodel.length];
            System.arraycopy(this.fullmodel, 0, nArray, 0, nArray.length);
        }
        return nArray;
    }

    @Override
    public int realNumberOfVariables() {
        return this.voc.nVars();
    }

    @Override
    public void stop() {
        this.expireTimeout();
    }

    @Override
    public void backtrack(int[] nArray) {
        VecInt vecInt = new VecInt(nArray.length);
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            vecInt.push(LiteralsUtils.toInternal(n3));
            ++n2;
        }
        this.sharedConflict = this.dsfactory.createUnregisteredClause(vecInt);
        this.learn(this.sharedConflict);
    }

    @Override
    public Lbool truthValue(int n) {
        int n2 = LiteralsUtils.toInternal(n);
        if (this.voc.isFalsified(n2)) {
            return Lbool.FALSE;
        }
        if (this.voc.isSatisfied(n2)) {
            return Lbool.TRUE;
        }
        return Lbool.UNDEFINED;
    }

    @Override
    public int currentDecisionLevel() {
        return this.decisionLevel();
    }

    @Override
    public int[] getLiteralsPropagatedAt(int n) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    @Override
    public void suggestNextLiteralToBranchOn(int n) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }

    protected boolean isNeedToReduceDB() {
        return this.needToReduceDB;
    }

    @Override
    public void setNeedToReduceDB(boolean bl) {
        this.needToReduceDB = bl;
    }

    @Override
    public void setLogger(ILogAble iLogAble) {
        this.out = iLogAble;
    }

    @Override
    public ILogAble getLogger() {
        return this.out;
    }

    @Override
    public double[] getVariableHeuristics() {
        return this.order.getVariableHeuristics();
    }

    public IVec<Constr> getLearnedConstraints() {
        return this.learnts;
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(ConflictTimer conflictTimer, LearnedConstraintsEvaluationType learnedConstraintsEvaluationType) {
        if (this.conflictCount != null) {
            this.conflictCount.add(conflictTimer);
            this.conflictCount.remove(this.learnedConstraintsDeletionStrategy.getTimer());
        }
        switch (learnedConstraintsEvaluationType) {
            case ACTIVITY: {
                this.learnedConstraintsDeletionStrategy = this.activityBased(conflictTimer);
                break;
            }
            case LBD: {
                this.learnedConstraintsDeletionStrategy = new GlucoseLCDS(conflictTimer);
                break;
            }
            case LBD2: {
                this.learnedConstraintsDeletionStrategy = new Glucose2LCDS(conflictTimer);
            }
        }
        if (this.conflictCount != null) {
            this.learnedConstraintsDeletionStrategy.init();
        }
    }

    @Override
    public void setLearnedConstraintsDeletionStrategy(LearnedConstraintsEvaluationType learnedConstraintsEvaluationType) {
        ConflictTimer conflictTimer = this.learnedConstraintsDeletionStrategy.getTimer();
        switch (learnedConstraintsEvaluationType) {
            case ACTIVITY: {
                this.learnedConstraintsDeletionStrategy = this.activityBased(conflictTimer);
                break;
            }
            case LBD: {
                this.learnedConstraintsDeletionStrategy = new GlucoseLCDS(conflictTimer);
                break;
            }
            case LBD2: {
                this.learnedConstraintsDeletionStrategy = new Glucose2LCDS(conflictTimer);
            }
        }
        if (this.conflictCount != null) {
            this.learnedConstraintsDeletionStrategy.init();
        }
    }

    @Override
    public boolean isSolverKeptHot() {
        return this.keepHot;
    }

    @Override
    public void setKeepSolverHot(boolean bl) {
        this.keepHot = bl;
    }

    @Override
    public IConstr addClauseOnTheFly(int[] nArray) {
        Serializable serializable;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            serializable = Integer.valueOf(nArray2[n2]);
            arrayList.add((Integer)serializable);
            ++n2;
        }
        Collections.sort(arrayList, this.dimacsLevel);
        serializable = new VecInt(nArray.length);
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            n2 = (Integer)object.next();
            serializable.push(LiteralsUtils.toInternal(n2));
        }
        this.sharedConflict = this.dsfactory.createUnregisteredClause((IVecInt)serializable);
        this.sharedConflict.register();
        this.addConstr(this.sharedConflict);
        VecInt vecInt = new VecInt();
        this.sharedConflict.calcReasonOnTheFly(-1, this.trail, vecInt);
        object = this.fromLastDecisionLevel(vecInt);
        while (!this.trail.isEmpty() && !object.contains(this.trail.last())) {
            this.undoOne();
            if (this.trailLim.isEmpty() || this.trailLim.last() != this.trail.size()) continue;
            this.trailLim.pop();
        }
        return this.sharedConflict;
    }

    @Override
    public ISolver getSolvingEngine() {
        return this;
    }

    @Override
    public IConstr addAtMostOnTheFly(int[] nArray, int n) {
        VecInt vecInt = new VecInt(nArray.length);
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            vecInt.push(LiteralsUtils.toInternal(-n4));
            ++n3;
        }
        VecInt vecInt2 = new VecInt(vecInt.size());
        vecInt.copyTo(vecInt2);
        this.sharedConflict = this.dsfactory.createUnregisteredCardinalityConstraint(vecInt2, nArray.length - n);
        this.sharedConflict.register();
        this.addConstr(this.sharedConflict);
        VecInt vecInt3 = new VecInt();
        this.sharedConflict.calcReasonOnTheFly(-1, this.trail, vecInt3);
        Set<Integer> set = this.fromLastDecisionLevel(vecInt3);
        while (!this.trail.isEmpty() && !set.contains(this.trail.last())) {
            this.undoOne();
            if (this.trailLim.isEmpty() || this.trailLim.last() != this.trail.size()) continue;
            this.trailLim.pop();
        }
        return this.sharedConflict;
    }

    protected Set<Integer> fromLastDecisionLevel(IVecInt iVecInt) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n = -1;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            int n3 = iVecInt.get(n2);
            int n4 = this.voc.getLevel(n3);
            if (n4 > n) {
                hashSet.clear();
                hashSet.add(n3);
                n = n4;
            } else if (n4 == n) {
                hashSet.add(n3);
            }
            ++n2;
        }
        return hashSet;
    }

    @Override
    public void setUnitClauseProvider(UnitClauseProvider unitClauseProvider) {
        this.unitClauseProvider = unitClauseProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Glucose2LCDS
    extends GlucoseLCDS {
        private static final long serialVersionUID = 1L;

        Glucose2LCDS(ConflictTimer conflictTimer) {
            super(conflictTimer);
        }

        @Override
        public String toString() {
            return "Glucose 2 learned constraints deletion strategy";
        }

        @Override
        public void onPropagation(Constr constr) {
            int n;
            if (constr.getActivity() > 2.0 && (double)(n = this.computeLBD(constr)) < constr.getActivity()) {
                ++((Solver)Solver.this).stats.updateLBD;
                constr.setActivity(n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GlucoseLCDS
    implements LearnedConstraintsDeletionStrategy {
        private static final long serialVersionUID = 1L;
        private int[] flags = new int[0];
        private int flag = 0;
        private final ConflictTimer clauseManagement;

        GlucoseLCDS(ConflictTimer conflictTimer) {
            this.clauseManagement = conflictTimer;
        }

        @Override
        public void reduce(IVec<Constr> iVec) {
            int n;
            Solver.this.sortOnActivity();
            int n2 = n = iVec.size() / 2;
            while (n2 < iVec.size()) {
                Constr constr = iVec.get(n2);
                if (constr.locked() || constr.getActivity() <= 2.0) {
                    iVec.set(n++, Solver.this.learnts.get(n2));
                } else {
                    constr.remove(Solver.this);
                }
                ++n2;
            }
            if (Solver.this.verbose) {
                Solver.this.out.log(String.valueOf(Solver.this.getLogPrefix()) + "cleaning " + (iVec.size() - n) + " clauses out of " + iVec.size() + " with flag " + this.flag + "/" + ((Solver)Solver.this).stats.conflicts);
            }
            Solver.this.learnts.shrinkTo(n);
        }

        @Override
        public ConflictTimer getTimer() {
            return this.clauseManagement;
        }

        public String toString() {
            return "Glucose learned constraints deletion strategy";
        }

        @Override
        public void init() {
            int n = Solver.this.voc.nVars();
            if (this.flags.length <= n) {
                this.flags = new int[n + 1];
            }
            this.flag = 0;
            this.clauseManagement.reset();
        }

        @Override
        public void onClauseLearning(Constr constr) {
            int n = this.computeLBD(constr);
            constr.incActivity(n);
        }

        protected int computeLBD(Constr constr) {
            int n = 1;
            ++this.flag;
            int n2 = 1;
            while (n2 < constr.size()) {
                int n3 = Solver.this.voc.getLevel(constr.get(n2));
                if (this.flags[n3] != this.flag) {
                    this.flags[n3] = this.flag;
                    ++n;
                }
                ++n2;
            }
            return n;
        }

        @Override
        public void onConflictAnalysis(Constr constr) {
        }

        @Override
        public void onPropagation(Constr constr) {
        }
    }
}

