/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.InternalMapPBStructure;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPb
implements IDataStructurePB {
    protected InternalMapPBStructure weightedLits;
    protected BigInteger degree;
    protected int assertiveLiteral = -1;

    MapPb(PBConstr pBConstr) {
        this.weightedLits = new InternalMapPBStructure(pBConstr);
        this.degree = pBConstr.getDegree();
    }

    MapPb(int n) {
        this.weightedLits = new InternalMapPBStructure(n);
        this.degree = BigInteger.ZERO;
    }

    public MapPb(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        this.weightedLits = new InternalMapPBStructure(iVecInt, iVec);
        this.degree = bigInteger;
    }

    @Override
    public boolean isCardinality() {
        int n = 0;
        while (n < this.size()) {
            if (!this.weightedLits.getCoef(n).equals(BigInteger.ONE)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    @Override
    public boolean isLongSufficient() {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.size() && bigInteger.bitLength() < 64) {
            assert (this.weightedLits.getCoef(n).compareTo(BigInteger.ZERO) >= 0);
            bigInteger = bigInteger.add(this.weightedLits.getCoef(n));
            ++n;
        }
        return bigInteger.bitLength() < 64;
    }

    @Override
    public int getAssertiveLiteral() {
        return this.assertiveLiteral;
    }

    @Override
    public BigInteger saturation() {
        assert (this.degree.signum() > 0);
        BigInteger bigInteger = this.degree;
        int n = 0;
        while (n < this.size()) {
            assert (this.weightedLits.getCoef(n).signum() > 0);
            if (this.degree.compareTo(this.weightedLits.getCoef(n)) < 0) {
                this.changeCoef(n, this.degree);
            }
            assert (this.weightedLits.getCoef(n).signum() > 0);
            bigInteger = bigInteger.min(this.weightedLits.getCoef(n));
            ++n;
        }
        if (bigInteger.equals(this.degree) && bigInteger.compareTo(BigInteger.ONE) > 0) {
            this.degree = BigInteger.ONE;
            n = 0;
            while (n < this.size()) {
                this.changeCoef(n, BigInteger.ONE);
                ++n;
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(PBConstr pBConstr, BigInteger bigInteger, BigInteger[] bigIntegerArray, VarActivityListener varActivityListener) {
        return this.cuttingPlane(pBConstr, bigInteger, bigIntegerArray, BigInteger.ONE, varActivityListener);
    }

    @Override
    public BigInteger cuttingPlane(PBConstr pBConstr, BigInteger bigInteger, BigInteger[] bigIntegerArray, BigInteger bigInteger2, VarActivityListener varActivityListener) {
        this.degree = this.degree.add(bigInteger);
        assert (this.degree.signum() > 0);
        if (bigIntegerArray == null) {
            int n = 0;
            while (n < pBConstr.size()) {
                varActivityListener.varBumpActivity(pBConstr.get(n));
                this.cuttingPlaneStep(pBConstr.get(n), this.multiplyCoefficient(pBConstr.getCoef(n), bigInteger2));
                ++n;
            }
        } else {
            int n = 0;
            while (n < pBConstr.size()) {
                varActivityListener.varBumpActivity(pBConstr.get(n));
                this.cuttingPlaneStep(pBConstr.get(n), this.multiplyCoefficient(bigIntegerArray[n], bigInteger2));
                ++n;
            }
        }
        return this.degree;
    }

    @Override
    public BigInteger cuttingPlane(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.cuttingPlane(nArray, bigIntegerArray, bigInteger, BigInteger.ONE);
    }

    @Override
    public BigInteger cuttingPlane(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        this.degree = this.degree.add(bigInteger);
        assert (this.degree.signum() > 0);
        int n = 0;
        while (n < nArray.length) {
            this.cuttingPlaneStep(nArray[n], bigIntegerArray[n].multiply(bigInteger2));
            ++n;
        }
        return this.degree;
    }

    private void cuttingPlaneStep(int n, BigInteger bigInteger) {
        assert (bigInteger.signum() >= 0);
        int n2 = n ^ 1;
        if (bigInteger.signum() > 0) {
            if (this.weightedLits.containsKey(n2)) {
                assert (!this.weightedLits.containsKey(n));
                assert (this.weightedLits.get(n2) != null);
                if (this.weightedLits.get(n2).compareTo(bigInteger) < 0) {
                    BigInteger bigInteger2 = this.weightedLits.get(n2);
                    this.setCoef(n, bigInteger.subtract(bigInteger2));
                    assert (this.weightedLits.get(n).signum() > 0);
                    this.degree = this.degree.subtract(bigInteger2);
                    this.removeCoef(n2);
                } else if (this.weightedLits.get(n2).equals(bigInteger)) {
                    this.degree = this.degree.subtract(bigInteger);
                    this.removeCoef(n2);
                } else {
                    this.decreaseCoef(n2, bigInteger);
                    assert (this.weightedLits.get(n2).signum() > 0);
                    this.degree = this.degree.subtract(bigInteger);
                }
            } else {
                assert (!this.weightedLits.containsKey(n) || this.weightedLits.get(n).signum() > 0);
                if (this.weightedLits.containsKey(n)) {
                    this.increaseCoef(n, bigInteger);
                } else {
                    this.setCoef(n, bigInteger);
                }
                assert (this.weightedLits.get(n).signum() > 0);
            }
        }
        assert (!this.weightedLits.containsKey(n2) || !this.weightedLits.containsKey(n));
    }

    @Override
    public void buildConstraintFromConflict(IVecInt iVecInt, IVec<BigInteger> iVec) {
        iVecInt.clear();
        iVec.clear();
        this.weightedLits.copyCoefs(iVec);
        this.weightedLits.copyLits(iVecInt);
    }

    @Override
    public void buildConstraintFromMapPb(int[] nArray, BigInteger[] bigIntegerArray) {
        assert (nArray.length == bigIntegerArray.length);
        assert (nArray.length == this.size());
        this.weightedLits.copyCoefs(bigIntegerArray);
        this.weightedLits.copyLits(nArray);
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public int size() {
        return this.weightedLits.size();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            stringBuffer.append(this.weightedLits.getCoef(n));
            stringBuffer.append(".");
            stringBuffer.append(Lits.toString(this.weightedLits.getLit(n)));
            stringBuffer.append(" ");
            ++n;
        }
        return String.valueOf(stringBuffer.toString()) + " >= " + this.degree;
    }

    private BigInteger multiplyCoefficient(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.equals(BigInteger.ONE)) {
            return bigInteger2;
        }
        return bigInteger.multiply(bigInteger2);
    }

    void increaseCoef(int n, BigInteger bigInteger) {
        this.weightedLits.put(n, this.weightedLits.get(n).add(bigInteger));
    }

    void decreaseCoef(int n, BigInteger bigInteger) {
        this.weightedLits.put(n, this.weightedLits.get(n).subtract(bigInteger));
    }

    void setCoef(int n, BigInteger bigInteger) {
        this.weightedLits.put(n, bigInteger);
    }

    void changeCoef(int n, BigInteger bigInteger) {
        this.weightedLits.changeCoef(n, bigInteger);
    }

    void removeCoef(int n) {
        this.weightedLits.remove(n);
    }
}

