/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MinWatchPb;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.UnitPropagationListener;

public final class PuebloMinWatchPb
extends MinWatchPb {
    private static final long serialVersionUID = 1L;

    private PuebloMinWatchPb(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
    }

    private PuebloMinWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iLits, iDataStructurePB);
    }

    public static PuebloMinWatchPb normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) throws ContradictionException {
        Serializable serializable;
        BigInteger bigInteger2 = BigInteger.ZERO;
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        int n = bigIntegerArray.length;
        int n2 = 0;
        while (n2 < n) {
            serializable = bigIntegerArray2[n2];
            bigInteger2 = bigInteger2.add((BigInteger)serializable);
            ++n2;
        }
        serializable = new PuebloMinWatchPb(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (((PuebloMinWatchPb)serializable).degree.signum() <= 0) {
            return null;
        }
        ((MinWatchPb)serializable).computeWatches();
        ((MinWatchPb)serializable).computePropagation(unitPropagationListener);
        return serializable;
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new PuebloMinWatchPb(iLits, iDataStructurePB);
    }

    protected BigInteger maximalCoefficient(int n) {
        return this.coefs[0];
    }

    protected BigInteger updateWatched(BigInteger bigInteger, int n) {
        BigInteger bigInteger2 = bigInteger;
        if (this.watchingCount < this.size()) {
            BigInteger bigInteger3 = this.watchCumul.subtract(this.coefs[n]);
            BigInteger bigInteger4 = this.degree.add(bigInteger2);
            int n2 = 0;
            while (n2 < this.lits.length && bigInteger3.compareTo(bigInteger4) < 0) {
                if (!this.voc.isFalsified(this.lits[n2]) && !this.watched[n2]) {
                    bigInteger3 = bigInteger3.add(this.coefs[n2]);
                    this.watched[n2] = true;
                    assert (this.watchingCount < this.size());
                    this.watching[this.watchingCount++] = n2;
                    this.voc.watch(this.lits[n2] ^ 1, this);
                }
                ++n2;
            }
            this.watchCumul = bigInteger3.add(this.coefs[n]);
        }
        return bigInteger2;
    }
}

