/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IGroupSolver;

public class GroupedCNFReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    private int numberOfComponents;
    private final IGroupSolver groupSolver;
    private int currentComponentIndex;

    public GroupedCNFReader(IGroupSolver iGroupSolver) {
        super(iGroupSolver, "gcnf");
        this.groupSolver = iGroupSolver;
    }

    protected void readProblemLine() throws IOException, ParseFormatException {
        String string = this.scanner.nextLine();
        assert (string != null);
        String[] stringArray = (string = string.trim()).split("\\s+");
        if (stringArray.length < 5 || !"p".equals(stringArray[0]) || !this.formatString.equals(stringArray[1])) {
            throw new ParseFormatException("problem line expected (p " + this.formatString + " ...)");
        }
        int n = Integer.parseInt(stringArray[2]);
        assert (n > 0);
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringArray[3]);
        assert (this.expectedNbOfConstr > 0);
        this.numberOfComponents = Integer.parseInt(stringArray[4]);
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean handleLine() throws ContradictionException, IOException, ParseFormatException {
        var2_1 = false;
        var3_2 = this.scanner.next();
        if (!var3_2.startsWith("{") || !var3_2.endsWith("}")) {
            throw new ParseFormatException("Component index required at the beginning of the clause");
        }
        this.currentComponentIndex = Integer.valueOf(var3_2.substring(1, var3_2.length() - 1));
        if (this.currentComponentIndex >= 0 && this.currentComponentIndex <= this.numberOfComponents) ** GOTO lbl17
        throw new ParseFormatException("wrong component index: " + this.currentComponentIndex);
lbl-1000:
        // 1 sources

        {
            var1_3 = this.scanner.nextInt();
            if (var1_3 == 0) {
                if (this.literals.size() <= 0) break;
                this.flushConstraint();
                this.literals.clear();
                var2_1 = true;
                break;
            }
            this.literals.push(var1_3);
lbl17:
            // 2 sources

            ** while (!this.scanner.eof())
        }
lbl18:
        // 3 sources

        return var2_1;
    }

    protected void flushConstraint() throws ContradictionException {
        block4: {
            try {
                if (this.currentComponentIndex == 0) {
                    this.groupSolver.addClause(this.literals);
                } else {
                    this.groupSolver.addClause(this.literals, this.currentComponentIndex);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!this.isVerbose()) break block4;
                System.err.println("c Skipping constraint " + this.literals);
            }
        }
    }
}

