/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class Backbone {
    private Backbone() {
    }

    public static IVecInt compute(ISolver iSolver) throws TimeoutException {
        return Backbone.compute(iSolver, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver iSolver, IVecInt iVecInt) throws TimeoutException {
        boolean bl = iSolver.isSatisfiable(iVecInt);
        if (!bl) {
            return VecInt.EMPTY;
        }
        return Backbone.compute(iSolver, iSolver.primeImplicant(), iVecInt);
    }

    public static IVecInt compute(ISolver iSolver, int[] nArray) throws TimeoutException {
        return Backbone.compute(iSolver, nArray, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver iSolver, int[] nArray, IVecInt iVecInt) throws TimeoutException {
        VecInt vecInt = new VecInt();
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            if (!iVecInt.contains(n3)) {
                vecInt.push(-n3);
            }
            ++n2;
        }
        VecInt vecInt2 = new VecInt();
        iVecInt.copyTo(vecInt2);
        while (!vecInt.isEmpty()) {
            n2 = vecInt.last();
            vecInt2.push(n2);
            vecInt.pop();
            if (iSolver.isSatisfiable(vecInt2)) {
                vecInt2.pop();
                nArray = iSolver.primeImplicant();
                Backbone.removeVarNotPresentAndSatisfiedLits(nArray, vecInt, iSolver.nVars());
                continue;
            }
            vecInt2.pop().push(-n2);
        }
        return vecInt2;
    }

    private static void removeVarNotPresentAndSatisfiedLits(int[] nArray, IVecInt iVecInt, int n) {
        int n2;
        int[] nArray2 = new int[n + 1];
        int[] nArray3 = nArray;
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            nArray2[(n2 = nArray3[n4]) > 0 ? n2 : -n2] = n2;
            ++n4;
        }
        n3 = 0;
        while (n3 < iVecInt.size()) {
            n2 = iVecInt.get(n3);
            n4 = nArray2[n2 > 0 ? n2 : -n2];
            if (n4 == 0 || n4 == n2) {
                iVecInt.delete(n3);
                continue;
            }
            ++n3;
        }
    }
}

