/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexicoDecorator<T extends ISolver>
extends SolverDecorator<T>
implements IOptimizationProblem {
    protected final List<IVecInt> criteria = new ArrayList<IVecInt>();
    protected int currentCriterion = 0;
    protected IConstr prevConstr;
    private Number currentValue = -1;
    protected int[] prevfullmodel;
    protected int[] prevmodelwithinternalvars;
    protected boolean[] prevboolmodel;
    protected boolean isSolutionOptimal;
    private static final long serialVersionUID = 1L;

    public LexicoDecorator(T t) {
        super(t);
    }

    public void addCriterion(IVecInt iVecInt) {
        VecInt vecInt = new VecInt(iVecInt.size());
        iVecInt.copyTo(vecInt);
        this.criteria.add(vecInt);
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    @Override
    public boolean admitABetterSolution(IVecInt iVecInt) throws TimeoutException {
        this.isSolutionOptimal = false;
        if (this.decorated().isSatisfiable(iVecInt, true)) {
            this.prevboolmodel = new boolean[this.nVars()];
            int n = 0;
            while (n < this.nVars()) {
                this.prevboolmodel[n] = this.decorated().model(n + 1);
                ++n;
            }
            this.prevfullmodel = this.decorated().model();
            this.prevmodelwithinternalvars = this.decorated().modelWithInternalVariables();
            this.calculateObjective();
            return true;
        }
        return this.manageUnsatCase();
    }

    protected boolean manageUnsatCase() {
        if (this.prevfullmodel == null) {
            return false;
        }
        if (this.currentCriterion < this.numberOfCriteria() - 1) {
            if (this.prevConstr != null) {
                super.removeConstr(this.prevConstr);
                this.prevConstr = null;
            }
            try {
                this.fixCriterionValue();
            }
            catch (ContradictionException contradictionException) {
                throw new IllegalStateException(contradictionException);
            }
            if (this.isVerbose()) {
                System.out.println(String.valueOf(this.getLogPrefix()) + "Found optimal criterion number " + (this.currentCriterion + 1));
            }
            ++this.currentCriterion;
            this.calculateObjective();
            return true;
        }
        if (this.isVerbose()) {
            System.out.println(String.valueOf(this.getLogPrefix()) + "Found optimal solution for the last criterion ");
        }
        this.isSolutionOptimal = true;
        if (this.prevConstr != null) {
            super.removeConstr(this.prevConstr);
            this.prevConstr = null;
        }
        return false;
    }

    public int numberOfCriteria() {
        return this.criteria.size();
    }

    protected void fixCriterionValue() throws ContradictionException {
        super.addExactly(this.criteria.get(this.currentCriterion), this.currentValue.intValue());
    }

    @Override
    public int[] model() {
        return this.prevfullmodel;
    }

    @Override
    public boolean model(int n) {
        return this.prevboolmodel[n - 1];
    }

    @Override
    public int[] modelWithInternalVariables() {
        return this.prevmodelwithinternalvars;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    @Override
    public Number calculateObjective() {
        this.currentValue = this.evaluate();
        return this.currentValue;
    }

    @Override
    public Number getObjectiveValue() {
        return this.currentValue;
    }

    public Number getObjectiveValue(int n) {
        return this.evaluate(n);
    }

    @Override
    public void forceObjectiveValueTo(Number number) throws ContradictionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void discard() throws ContradictionException {
        this.discardCurrentSolution();
    }

    @Override
    public void discardCurrentSolution() throws ContradictionException {
        block3: {
            if (this.prevConstr != null) {
                super.removeSubsumedConstr(this.prevConstr);
            }
            try {
                this.prevConstr = this.discardSolutionsForOptimizing();
            }
            catch (ContradictionException contradictionException) {
                this.prevConstr = null;
                if (this.manageUnsatCase()) break block3;
                throw contradictionException;
            }
        }
    }

    protected IConstr discardSolutionsForOptimizing() throws ContradictionException {
        return super.addAtMost(this.criteria.get(this.currentCriterion), this.currentValue.intValue() - 1);
    }

    protected Number evaluate() {
        return this.evaluate(this.currentCriterion);
    }

    protected Number evaluate(int n) {
        int n2 = 0;
        IteratorInt iteratorInt = this.criteria.get(this.currentCriterion).iterator();
        while (iteratorInt.hasNext()) {
            int n3 = iteratorInt.next();
            if ((n3 <= 0 || !this.prevboolmodel[n3 - 1]) && (n3 >= 0 || this.prevboolmodel[-n3 - 1])) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public boolean isOptimal() {
        return this.isSolutionOptimal;
    }

    @Override
    public void setTimeoutForFindingBetterSolution(int n) {
        throw new UnsupportedOperationException("No implemented yet");
    }
}

