/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Counter;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.UnitClauseProvider;
import org.sat4j.specs.UnitPropagationListener;
import org.sat4j.tools.OutcomeListener;
import org.sat4j.tools.RunnableSolver;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyCore<S extends ISolver>
extends SearchListenerAdapter<ISolverService>
implements ISolver,
OutcomeListener,
UnitClauseProvider {
    private static final int NORMAL_SLEEP = 500;
    private static final int FAST_SLEEP = 50;
    private static final long serialVersionUID = 1L;
    private final String[] availableSolvers;
    protected final List<S> solvers;
    protected final int numberOfSolvers;
    private int winnerId;
    private boolean resultFound;
    private AtomicInteger remainingSolvers;
    private volatile int sleepTime;
    private volatile boolean solved;
    private final IVecInt sharedUnitClauses = new VecInt();
    private final IVec<Counter> solversStats = new Vec<Counter>();

    public ManyCore(ASolverFactory<S> aSolverFactory, String ... stringArray) {
        this.availableSolvers = stringArray;
        this.numberOfSolvers = stringArray.length;
        this.solvers = new ArrayList<S>(this.numberOfSolvers);
        int n = 0;
        while (n < this.numberOfSolvers) {
            ISolverService iSolverService = aSolverFactory.createSolverByName(this.availableSolvers[n]);
            iSolverService.setSearchListener(this);
            iSolverService.setUnitClauseProvider(this);
            this.solvers.add(iSolverService);
            this.solversStats.push(new Counter(0));
            ++n;
        }
    }

    public ManyCore(String[] stringArray, S ... SArray) {
        this((ISolver[])SArray);
        int n = 0;
        while (n < stringArray.length) {
            this.availableSolvers[n] = stringArray[n];
            ++n;
        }
    }

    public ManyCore(S ... SArray) {
        this.availableSolvers = new String[SArray.length];
        int n = 0;
        while (n < SArray.length) {
            this.availableSolvers[n] = "solver" + n;
            ++n;
        }
        this.numberOfSolvers = SArray.length;
        this.solvers = new ArrayList<S>(this.numberOfSolvers);
        n = 0;
        while (n < this.numberOfSolvers) {
            this.solvers.add(SArray[n]);
            SArray[n].setSearchListener(this);
            SArray[n].setUnitClauseProvider(this);
            this.solversStats.push(new Counter(0));
            ++n;
        }
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).addAllClauses(iVec);
            ++n;
        }
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n2)).addAtLeast(iVecInt, n));
            ++n2;
        }
        return constrGroup;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n2)).addAtMost(iVecInt, n));
            ++n2;
        }
        return constrGroup;
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n2)).addExactly(iVecInt, n));
            ++n2;
        }
        return constrGroup;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n = 0;
        while (n < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n)).addClause(iVecInt));
            ++n;
        }
        return constrGroup;
    }

    @Override
    public void clearLearntClauses() {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).clearLearntClauses();
            ++n;
        }
    }

    @Override
    public void expireTimeout() {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).expireTimeout();
            ++n;
        }
        this.sleepTime = 50;
    }

    @Override
    public Map<String, Number> getStat() {
        return ((ISolver)this.solvers.get(this.winnerId)).getStat();
    }

    @Override
    public int getTimeout() {
        return ((ISolver)this.solvers.get(0)).getTimeout();
    }

    @Override
    public long getTimeoutMs() {
        return ((ISolver)this.solvers.get(0)).getTimeoutMs();
    }

    @Override
    public int newVar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int newVar(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.numberOfSolvers) {
            n2 = ((ISolver)this.solvers.get(n3)).newVar(n);
            ++n3;
        }
        return n2;
    }

    @Override
    @Deprecated
    public void printStat(PrintStream printStream, String string) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            printStream.printf("%s>>>>>>>>>> Solver number %d (%d answers) <<<<<<<<<<<<<<<<<<%n", string, n, this.solversStats.get(n).getValue());
            ((ISolver)this.solvers.get(n)).printStat(printStream, string);
            ++n;
        }
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            printWriter.printf("%s>>>>>>>>>> Solver number %d (%d answers) <<<<<<<<<<<<<<<<<<%n", string, n, this.solversStats.get(n).getValue());
            ((ISolver)this.solvers.get(n)).printStat(printWriter, string);
            ++n;
        }
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        if (iConstr instanceof ConstrGroup) {
            ConstrGroup constrGroup = (ConstrGroup)iConstr;
            boolean bl = true;
            int n = 0;
            while (n < this.numberOfSolvers) {
                IConstr iConstr2 = constrGroup.getConstr(n);
                if (iConstr2 != null) {
                    bl &= ((ISolver)this.solvers.get(n)).removeConstr(iConstr2);
                }
                ++n;
            }
            return bl;
        }
        throw new IllegalArgumentException("Can only remove a group of constraints!");
    }

    @Override
    public void reset() {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).reset();
            ++n;
        }
        this.sharedUnitClauses.clear();
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n2)).setExpectedNumberOfClauses(n);
            ++n2;
        }
    }

    @Override
    public void setTimeout(int n) {
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n2)).setTimeout(n);
            ++n2;
        }
    }

    @Override
    public void setTimeoutMs(long l) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setTimeoutMs(l);
            ++n;
        }
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n2)).setTimeoutOnConflicts(n);
            ++n2;
        }
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("ManyCore solver with ");
        stringBuffer.append(this.numberOfSolvers);
        stringBuffer.append(" solvers running in parallel");
        stringBuffer.append("\n");
        int n = 0;
        while (n < this.numberOfSolvers) {
            stringBuffer.append(string);
            stringBuffer.append(">>>>>>>>>> Solver number ");
            stringBuffer.append(n);
            stringBuffer.append(" <<<<<<<<<<<<<<<<<<\n");
            stringBuffer.append(((ISolver)this.solvers.get(n)).toString(string));
            if (n < this.numberOfSolvers - 1) {
                stringBuffer.append("\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        if (this.isSatisfiable(iVecInt)) {
            return this.model();
        }
        return null;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, false);
    }

    @Override
    public synchronized boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.remainingSolvers = new AtomicInteger(this.numberOfSolvers);
        this.solved = false;
        int n = 0;
        while (n < this.numberOfSolvers) {
            new Thread(new RunnableSolver(n, (ISolver)this.solvers.get(n), iVecInt, bl, this)).start();
            ++n;
        }
        try {
            this.sleepTime = 500;
            do {
                this.wait(this.sleepTime);
            } while (this.remainingSolvers.get() > 0);
        }
        catch (InterruptedException interruptedException) {}
        if (!this.solved) {
            assert (this.remainingSolvers.get() == 0);
            throw new TimeoutException();
        }
        return this.resultFound;
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] model() {
        return ((ISolver)this.solvers.get(this.winnerId)).model();
    }

    @Override
    public boolean model(int n) {
        return ((ISolver)this.solvers.get(this.winnerId)).model(n);
    }

    @Override
    public int nConstraints() {
        return ((ISolver)this.solvers.get(0)).nConstraints();
    }

    @Override
    public int nVars() {
        return ((ISolver)this.solvers.get(0)).nVars();
    }

    @Override
    public void printInfos(PrintWriter printWriter, String string) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            printWriter.printf("%s>>>>>>>>>> Solver number %d <<<<<<<<<<<<<<<<<<%n", string, n);
            ((ISolver)this.solvers.get(n)).printInfos(printWriter, string);
            ++n;
        }
    }

    @Override
    public synchronized void onFinishWithAnswer(boolean bl, boolean bl2, int n) {
        if (bl && !this.solved) {
            this.winnerId = n;
            this.solversStats.get(n).inc();
            this.solved = true;
            this.resultFound = bl2;
            int n2 = 0;
            while (n2 < this.numberOfSolvers) {
                if (n2 != this.winnerId) {
                    ((ISolver)this.solvers.get(n2)).expireTimeout();
                }
                ++n2;
            }
            this.sleepTime = 50;
            System.out.println(String.valueOf(this.getLogPrefix()) + "And the winner is " + this.availableSolvers[this.winnerId]);
        }
        this.remainingSolvers.getAndDecrement();
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        return ((ISolver)this.solvers.get(0)).isDBSimplificationAllowed();
    }

    @Override
    public void setDBSimplificationAllowed(boolean bl) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(0)).setDBSimplificationAllowed(bl);
            ++n;
        }
    }

    public <I extends ISolverService> void setSearchListener(SearchListener<I> searchListener) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setSearchListener(searchListener);
            ++n;
        }
    }

    public <I extends ISolverService> SearchListener<I> getSearchListener() {
        return ((ISolver)this.solvers.get(0)).getSearchListener();
    }

    @Override
    public int nextFreeVarId(boolean bl) {
        int n = -1;
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            n = ((ISolver)this.solvers.get(n2)).nextFreeVarId(bl);
            ++n2;
        }
        return n;
    }

    @Override
    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        ConstrGroup constrGroup = new ConstrGroup(false);
        int n = 0;
        while (n < this.numberOfSolvers) {
            constrGroup.add(((ISolver)this.solvers.get(n)).addBlockingClause(iVecInt));
            ++n;
        }
        return constrGroup;
    }

    @Override
    public boolean removeSubsumedConstr(IConstr iConstr) {
        if (iConstr instanceof ConstrGroup) {
            ConstrGroup constrGroup = (ConstrGroup)iConstr;
            boolean bl = true;
            int n = 0;
            while (n < this.numberOfSolvers) {
                IConstr iConstr2 = constrGroup.getConstr(n);
                if (iConstr2 != null) {
                    bl &= ((ISolver)this.solvers.get(n)).removeSubsumedConstr(iConstr2);
                }
                ++n;
            }
            return bl;
        }
        throw new IllegalArgumentException("Can only remove a group of constraints!");
    }

    @Override
    public boolean isVerbose() {
        return ((ISolver)this.solvers.get(0)).isVerbose();
    }

    @Override
    public void setVerbose(boolean bl) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setVerbose(bl);
            ++n;
        }
    }

    @Override
    public void setLogPrefix(String string) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setLogPrefix(string);
            ++n;
        }
    }

    @Override
    public String getLogPrefix() {
        return ((ISolver)this.solvers.get(0)).getLogPrefix();
    }

    @Override
    public IVecInt unsatExplanation() {
        return ((ISolver)this.solvers.get(this.winnerId)).unsatExplanation();
    }

    @Override
    public int[] primeImplicant() {
        return ((ISolver)this.solvers.get(this.winnerId)).primeImplicant();
    }

    @Override
    public boolean primeImplicant(int n) {
        return ((ISolver)this.solvers.get(this.winnerId)).primeImplicant(n);
    }

    public List<S> getSolvers() {
        return new ArrayList<S>(this.solvers);
    }

    @Override
    public int[] modelWithInternalVariables() {
        return ((ISolver)this.solvers.get(this.winnerId)).modelWithInternalVariables();
    }

    @Override
    public int realNumberOfVariables() {
        return ((ISolver)this.solvers.get(0)).realNumberOfVariables();
    }

    @Override
    public void registerLiteral(int n) {
        int n2 = 0;
        while (n2 < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n2)).registerLiteral(n);
            ++n2;
        }
    }

    @Override
    public boolean isSolverKeptHot() {
        return ((ISolver)this.solvers.get(0)).isSolverKeptHot();
    }

    @Override
    public void setKeepSolverHot(boolean bl) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            ((ISolver)this.solvers.get(n)).setKeepSolverHot(bl);
            ++n;
        }
    }

    @Override
    public ISolver getSolvingEngine() {
        throw new UnsupportedOperationException("Not supported yet in ManyCore");
    }

    @Override
    public void printStat(PrintWriter printWriter) {
        this.printStat(printWriter, this.getLogPrefix());
    }

    @Override
    public void printInfos(PrintWriter printWriter) {
        int n = 0;
        while (n < this.numberOfSolvers) {
            printWriter.printf("%s>>>>>>>>>> Solver number %d <<<<<<<<<<<<<<<<<<%n", this.getLogPrefix(), n);
            ((ISolver)this.solvers.get(n)).printInfos(printWriter);
            ++n;
        }
    }

    @Override
    public synchronized void learnUnit(int n) {
        this.sharedUnitClauses.push(LiteralsUtils.toInternal(n));
    }

    @Override
    public synchronized void provideUnitClauses(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.sharedUnitClauses.size()) {
            unitPropagationListener.enqueue(this.sharedUnitClauses.get(n));
            ++n;
        }
    }

    @Override
    public void setUnitClauseProvider(UnitClauseProvider unitClauseProvider) {
        throw new UnsupportedOperationException("Does not make sense in the parallel context");
    }
}

