/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.xplain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.FullClauseSelectorSolver;
import org.sat4j.tools.SolverDecorator;
import org.sat4j.tools.xplain.DeletionStrategy;
import org.sat4j.tools.xplain.Explainer;
import org.sat4j.tools.xplain.MinimizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xplain<T extends ISolver>
extends FullClauseSelectorSolver<T>
implements Explainer {
    private IVecInt assump;
    private MinimizationStrategy xplainStrategy = new DeletionStrategy();
    private static final long serialVersionUID = 1L;

    public Xplain(T t, boolean bl) {
        super(t, bl);
    }

    public Xplain(T t) {
        this(t, true);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException("Explanation requires Pseudo Boolean support. See XplainPB class instead.");
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException("Explanation requires Pseudo Boolean support. See XplainPB class instead.");
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException("Explanation requires Pseudo Boolean support. See XplainPB class instead.");
    }

    private IVecInt explanationKeys() throws TimeoutException {
        assert (!this.isSatisfiable(this.assump));
        Object t = this.decorated();
        if (t instanceof SolverDecorator) {
            t = ((SolverDecorator)t).decorated();
        }
        return this.xplainStrategy.explain((ISolver)t, this.getConstrs(), this.assump);
    }

    @Override
    public int[] minimalExplanation() throws TimeoutException {
        IVecInt iVecInt = this.explanationKeys();
        iVecInt.sort();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getConstrs().keySet());
        Collections.sort(arrayList);
        int[] nArray = new int[iVecInt.size()];
        int n = 0;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            nArray[n++] = arrayList.indexOf(iteratorInt.next()) + 1;
        }
        return nArray;
    }

    public Collection<IConstr> explain() throws TimeoutException {
        IVecInt iVecInt = this.explanationKeys();
        ArrayList<IConstr> arrayList = new ArrayList<IConstr>(iVecInt.size());
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            arrayList.add(this.getConstrs().get(iteratorInt.next()));
        }
        return arrayList;
    }

    public void cancelExplanation() {
        this.xplainStrategy.cancelExplanationComputation();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        return super.findModel();
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        return super.findModel(iVecInt);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        this.assump = VecInt.EMPTY;
        return super.isSatisfiable();
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        this.assump = VecInt.EMPTY;
        return super.isSatisfiable(bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        this.assump = iVecInt;
        return super.isSatisfiable(iVecInt);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        this.assump = iVecInt;
        return super.isSatisfiable(iVecInt, bl);
    }

    @Override
    public String toString(String string) {
        System.out.println(String.valueOf(string) + "Explanation (MUS) enabled solver");
        System.out.println(String.valueOf(string) + this.xplainStrategy);
        return super.toString(string);
    }

    @Override
    public void setMinimizationStrategy(MinimizationStrategy minimizationStrategy) {
        this.xplainStrategy = minimizationStrategy;
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        if (this.getLastConstr() == iConstr) {
            this.getLastClause().clear();
            this.setLastConstr(null);
        }
        return super.removeConstr(iConstr);
    }

    @Override
    public boolean removeSubsumedConstr(IConstr iConstr) {
        if (this.getLastConstr() == iConstr) {
            this.getLastClause().clear();
            this.setLastConstr(null);
        }
        return super.removeSubsumedConstr(iConstr);
    }
}

