/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.IOException;
import org.sat4j.AbstractLauncher;
import org.sat4j.ILauncherMode;
import org.sat4j.core.ASolverFactory;
import org.sat4j.pb.ConstraintRelaxingPseudoOptDecorator;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.SolverFactory;
import org.sat4j.pb.core.ObjectiveReducerPBSolverDecorator;
import org.sat4j.pb.reader.OPBReader2006;
import org.sat4j.pb.tools.SearchOptimizerListener;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ILogAble;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.SearchListener;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanceurPseudo2005
extends AbstractLauncher
implements ILogAble {
    ASolverFactory<IPBSolver> factory;
    private static final long serialVersionUID = 1L;
    protected ObjectiveFunction obfct;

    public LanceurPseudo2005() {
        this(SolverFactory.instance());
    }

    LanceurPseudo2005(ASolverFactory<IPBSolver> aSolverFactory) {
        this.factory = aSolverFactory;
        this.setLauncherMode(ILauncherMode.OPTIMIZATION);
    }

    public static void main(String[] stringArray) {
        LanceurPseudo2005 lanceurPseudo2005 = new LanceurPseudo2005();
        lanceurPseudo2005.run(stringArray);
        System.exit(lanceurPseudo2005.getExitCode().value());
    }

    protected Reader createReader(ISolver iSolver, String string) {
        return new OPBReader2006((IPBSolver)iSolver);
    }

    protected ISolver configureSolver(String[] stringArray) {
        String string = stringArray[0];
        boolean bl = false;
        if (string.startsWith("Lower")) {
            bl = true;
            string = string.substring("Lower".length());
        }
        IPBSolver iPBSolver = stringArray.length > 1 ? (IPBSolver)this.factory.createSolverByName(string) : (IPBSolver)this.factory.defaultSolver();
        if (System.getProperty("OBJREDUCER") != null) {
            iPBSolver = bl ? new ConstraintRelaxingPseudoOptDecorator(new ObjectiveReducerPBSolverDecorator(iPBSolver)) : new PseudoOptDecorator(new ObjectiveReducerPBSolverDecorator(iPBSolver));
        } else if (System.getProperty("INTERNAL") != null) {
            iPBSolver.setSearchListener((SearchListener)new SearchOptimizerListener((SolutionFoundListener)ILauncherMode.DECISION));
            this.setLauncherMode(ILauncherMode.DECISION);
        } else {
            iPBSolver = bl ? new ConstraintRelaxingPseudoOptDecorator(iPBSolver) : new PseudoOptDecorator(iPBSolver);
        }
        if (stringArray.length == 3) {
            iPBSolver.setTimeout(Integer.valueOf(stringArray[1]));
        }
        this.out.println(iPBSolver.toString("c "));
        return iPBSolver;
    }

    public void usage() {
        this.out.println("java -jar sat4j-pb.jar [solvername [timeout]] instancename.opb");
        this.showAvailableSolvers(SolverFactory.instance());
    }

    protected String getInstanceName(String[] stringArray) {
        assert (stringArray.length == 1 || stringArray.length == 2 || stringArray.length == 3);
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray[stringArray.length - 1];
    }

    protected IProblem readProblem(String string) throws ParseFormatException, IOException, ContradictionException {
        IProblem iProblem = super.readProblem(string);
        ObjectiveFunction objectiveFunction = ((IPBSolver)iProblem).getObjectiveFunction();
        if (objectiveFunction != null) {
            this.out.println("c objective function length is " + objectiveFunction.getVars().size() + " literals");
        }
        return iProblem;
    }
}

