/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final String FAKE_I_CONSTR_MSG = "Fake IConstr";
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;
    private static final IConstr FAKE_CONSTR = new IConstr(){

        public int size() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public boolean learnt() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public double getActivity() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public int get(int n) {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }

        public boolean canBePropagatedMultipleTimes() {
            throw new UnsupportedOperationException(OPBStringSolver.FAKE_I_CONSTR_MSG);
        }
    };

    public OPBStringSolver() {
    }

    public OPBStringSolver(int n) {
        super(n);
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        for (int n : iVecInt) {
            if (n > 0) {
                this.getOut().append("+1 x" + n + " >= 1 ;\n");
            } else {
                this.getOut().append("-1 x" + -n + " >= 0 ;\n");
            }
            ++this.nbOfConstraints;
        }
        throw new TimeoutException();
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return super.isSatisfiable(iVecInt, bl);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        if (bl) {
            return this.addAtLeast(iVecInt, iVec, bigInteger);
        }
        return this.addAtMost(iVecInt, iVec, bigInteger);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n2 = 0;
        for (int n3 : iVecInt) {
            assert (n3 != 0);
            if (n3 > 0) {
                stringBuffer.append("+1 x" + n3 + " ");
                continue;
            }
            stringBuffer.append("-1 x" + -n3 + " ");
            ++n2;
        }
        stringBuffer.append(">= " + (n - n2) + " ;\n");
        return FAKE_CONSTR;
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n2 = 0;
        for (int n3 : iVecInt) {
            assert (n3 != 0);
            if (n3 > 0) {
                stringBuffer.append("-1 x" + n3 + " ");
                continue;
            }
            stringBuffer.append("+1 x" + -n3 + " ");
            ++n2;
        }
        stringBuffer.append(">= " + (-n + n2) + " ;\n");
        return FAKE_CONSTR;
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n = 0;
        for (int n2 : iVecInt) {
            if (n2 > 0) {
                stringBuffer.append("+1 x" + n2 + " ");
                continue;
            }
            stringBuffer.append("-1 x" + -n2 + " ");
            ++n;
        }
        stringBuffer.append(">=" + (1 - n) + ";\n");
        return FAKE_CONSTR;
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt iVecInt) {
    }

    public String toString() {
        StringBuffer stringBuffer = this.getOut();
        if (!this.inserted) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("* #variable= ");
            stringBuffer2.append(this.nVars());
            stringBuffer2.append(" #constraint= ");
            stringBuffer2.append(this.nbOfConstraints);
            if (this.obj != null) {
                stringBuffer2.append("\n");
                stringBuffer2.append("min: ");
                stringBuffer2.append(this.obj);
                stringBuffer2.append(";");
            }
            stringBuffer.insert(this.indxConstrObj, stringBuffer2.toString());
            this.inserted = true;
        }
        return stringBuffer.toString();
    }

    public String toString(String string) {
        return "OPB output solver";
    }

    public int newVar(int n) {
        StringBuffer stringBuffer = this.getOut();
        this.setNbVars(n);
        this.indxConstrObj = stringBuffer.length();
        stringBuffer.append("\n");
        return n;
    }

    public void setExpectedNumberOfClauses(int n) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }

    public int nConstraints() {
        return this.nbOfConstraints;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVecInt2.size());
        ++this.nbOfConstraints;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            stringBuffer.append(-iVecInt2.get(n2));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(-n);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVec.size());
        ++this.nbOfConstraints;
        int n = 0;
        while (n < iVecInt.size()) {
            stringBuffer.append(((BigInteger)iVec.get(n)).negate());
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n));
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(bigInteger.negate());
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVecInt2.size());
        ++this.nbOfConstraints;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            stringBuffer.append(iVecInt2.get(n2));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(n);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVec.size());
        ++this.nbOfConstraints;
        int n = 0;
        while (n < iVecInt.size()) {
            stringBuffer.append(iVec.get(n));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n));
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(">= ");
        stringBuffer.append(bigInteger);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        int n2 = 0;
        for (int n3 : iVecInt) {
            assert (n3 != 0);
            if (n3 > 0) {
                stringBuffer.append("+1 x" + n3 + " ");
                continue;
            }
            stringBuffer.append("-1 x" + -n3 + " ");
            ++n2;
        }
        stringBuffer.append("= " + (n - n2) + " ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVecInt2.size());
        ++this.nbOfConstraints;
        int n2 = 0;
        while (n2 < iVecInt.size()) {
            stringBuffer.append(iVecInt2.get(n2));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n2));
            stringBuffer.append(" ");
            ++n2;
        }
        stringBuffer.append("= ");
        stringBuffer.append(n);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        assert (iVecInt.size() == iVec.size());
        ++this.nbOfConstraints;
        int n = 0;
        while (n < iVecInt.size()) {
            stringBuffer.append(iVec.get(n));
            stringBuffer.append(" x");
            stringBuffer.append(iVecInt.get(n));
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append("= ");
        stringBuffer.append(bigInteger);
        stringBuffer.append(" ;\n");
        return FAKE_CONSTR;
    }
}

