/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.ReadOnlyVec;
import org.sat4j.core.ReadOnlyVecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coeffs;
    private final IVecInt vars;
    private BigInteger correction = BigInteger.ZERO;

    public ObjectiveFunction(IVecInt iVecInt, IVec<BigInteger> iVec) {
        this.vars = new ReadOnlyVecInt(iVecInt);
        this.coeffs = new ReadOnlyVec(iVec);
    }

    public BigInteger calculateDegree(RandomAccessModel randomAccessModel) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.vars.size()) {
            BigInteger bigInteger2 = (BigInteger)this.coeffs.get(n);
            if (this.varInModel(this.vars.get(n), randomAccessModel)) {
                bigInteger = bigInteger.add(bigInteger2);
            } else if (bigInteger2.signum() < 0 && !this.varInModel(-this.vars.get(n), randomAccessModel)) {
                bigInteger = bigInteger.add(bigInteger2);
            }
            ++n;
        }
        return bigInteger;
    }

    public BigInteger calculateDegreeImplicant(ISolver iSolver) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.vars.size()) {
            BigInteger bigInteger2 = (BigInteger)this.coeffs.get(n);
            if (iSolver.primeImplicant(this.vars.get(n))) {
                bigInteger = bigInteger.add(bigInteger2);
            } else if (bigInteger2.signum() < 0 && !iSolver.primeImplicant(-this.vars.get(n))) {
                bigInteger = bigInteger.add(bigInteger2);
            }
            ++n;
        }
        return bigInteger;
    }

    private boolean varInModel(int n, RandomAccessModel randomAccessModel) {
        if (n > 0) {
            return randomAccessModel.model(n);
        }
        return !randomAccessModel.model(-n);
    }

    public IVec<BigInteger> getCoeffs() {
        return this.coeffs;
    }

    public IVecInt getVars() {
        return this.vars;
    }

    public void setCorrection(BigInteger bigInteger) {
        this.correction = bigInteger;
    }

    public BigInteger getCorrection() {
        return this.correction;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        IVecInt iVecInt = this.getVars();
        IVec<BigInteger> iVec = this.getCoeffs();
        int n = 0;
        while (n < iVecInt.size()) {
            BigInteger bigInteger = (BigInteger)iVec.get(n);
            int n2 = iVecInt.get(n);
            if (n2 < 0) {
                n2 = -n2;
                bigInteger = bigInteger.negate();
            }
            stringBuffer.append(String.valueOf(bigInteger.signum() < 0 ? "" : "+") + bigInteger + " x" + n2 + " ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public BigInteger minValue() {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.vars.size()) {
            BigInteger bigInteger2 = (BigInteger)this.coeffs.get(n);
            if (bigInteger2.signum() < 0) {
                bigInteger = bigInteger.add(bigInteger2);
            }
            ++n;
        }
        return bigInteger;
    }

    public int hashCode() {
        return this.coeffs.hashCode() / 3 + this.vars.hashCode() / 3 + this.correction.hashCode() / 3;
    }

    public boolean equals(Object object) {
        if (object instanceof ObjectiveFunction) {
            ObjectiveFunction objectiveFunction = (ObjectiveFunction)object;
            return objectiveFunction.correction.equals(this.correction) && objectiveFunction.coeffs.equals(this.coeffs) && objectiveFunction.vars.equals(this.vars);
        }
        return false;
    }
}

