/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.pb.constraints.pb.IConflict;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;

public class ConflictMap
extends MapPb
implements IConflict {
    private final ILits voc;
    protected boolean hasBeenReduced = false;
    protected long numberOfReductions = 0L;
    protected BigInteger currentSlack;
    protected int currentLevel;
    protected VecInt[] byLevel;
    protected BigInteger coefMult = BigInteger.ZERO;
    protected BigInteger coefMultCons = BigInteger.ZERO;
    private BigInteger possReducedCoefs = BigInteger.ZERO;

    public static IConflict createConflict(PBConstr pBConstr, int n) {
        return new ConflictMap(pBConstr, n);
    }

    ConflictMap(PBConstr pBConstr, int n) {
        super(pBConstr);
        this.voc = pBConstr.getVocabulary();
        this.currentLevel = n;
        this.initStructures();
    }

    private void initStructures() {
        this.currentSlack = BigInteger.ZERO;
        this.byLevel = new VecInt[ConflictMap.levelToIndex(this.currentLevel) + 1];
        int n = 0;
        while (n < this.size()) {
            int n2;
            int n3 = this.weightedLits.getLit(n);
            int n4 = this.voc.getLevel(n3);
            BigInteger bigInteger = this.weightedLits.getCoef(n);
            if (!(bigInteger.signum() <= 0 || this.voc.isFalsified(n3) && n4 != this.currentLevel)) {
                this.currentSlack = this.currentSlack.add(bigInteger);
            }
            if (this.byLevel[n2 = ConflictMap.levelToIndex(n4)] == null) {
                this.byLevel[n2] = new VecInt();
            }
            this.byLevel[n2].push(n3);
            ++n;
        }
    }

    private static int levelToIndex(int n) {
        return n + 1;
    }

    private static int indexToLevel(int n) {
        return n - 1;
    }

    public BigInteger resolve(PBConstr pBConstr, int n, VarActivityListener varActivityListener) {
        assert (n > 1);
        int n2 = n ^ 1;
        if (pBConstr == null || !this.weightedLits.containsKey(n2)) {
            int n3 = ConflictMap.levelToIndex(this.voc.getLevel(n));
            int n4 = 0;
            if (this.byLevel[n3] != null) {
                if (this.byLevel[n3].contains(n)) {
                    n4 = n;
                    assert (this.weightedLits.containsKey(n));
                } else if (this.byLevel[n3].contains(n2)) {
                    n4 = n2;
                    assert (this.weightedLits.containsKey(n2));
                }
            }
            if (n4 > 0) {
                this.byLevel[n3].remove(n4);
                if (this.byLevel[0] == null) {
                    this.byLevel[0] = new VecInt();
                }
                this.byLevel[0].push(n4);
            }
            return this.degree;
        }
        assert (this.slackConflict().signum() <= 0);
        assert (this.degree.signum() >= 0);
        BigInteger[] bigIntegerArray = null;
        BigInteger bigInteger = pBConstr.getDegree();
        int n5 = 0;
        while (pBConstr.get(n5) != n) {
            ++n5;
        }
        assert (pBConstr.get(n5) == n);
        assert (pBConstr.getCoef(n5) != BigInteger.ZERO);
        if (pBConstr.getCoef(n5).equals(BigInteger.ONE)) {
            this.coefMultCons = this.weightedLits.get(n2);
            this.coefMult = BigInteger.ONE;
            bigInteger = bigInteger.multiply(this.coefMultCons);
        } else {
            if (this.weightedLits.get(n2).equals(BigInteger.ONE)) {
                this.coefMult = pBConstr.getCoef(n5);
                this.coefMultCons = BigInteger.ONE;
                this.degree = this.degree.multiply(this.coefMult);
            } else {
                IWatchPb iWatchPb = (IWatchPb)pBConstr;
                bigIntegerArray = iWatchPb.getCoefs();
                assert (ConflictMap.positiveCoefs(bigIntegerArray));
                bigInteger = this.reduceUntilConflict(n, n5, bigIntegerArray, iWatchPb);
                bigInteger = bigInteger.multiply(this.coefMultCons);
                this.degree = this.degree.multiply(this.coefMult);
            }
            if (!this.coefMult.equals(BigInteger.ONE)) {
                int n6 = 0;
                while (n6 < this.size()) {
                    this.changeCoef(n6, this.weightedLits.getCoef(n6).multiply(this.coefMult));
                    ++n6;
                }
            }
        }
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.cuttingPlane(pBConstr, bigInteger, bigIntegerArray, this.coefMultCons, varActivityListener);
        assert (!this.weightedLits.containsKey(n));
        assert (!this.weightedLits.containsKey(n2));
        assert (this.getLevelByLevel(n) == -1);
        assert (this.getLevelByLevel(n2) == -1);
        assert (this.degree.signum() > 0);
        assert (this.slackConflict().signum() <= 0);
        this.degree = this.saturation();
        assert (this.slackConflict().signum() <= 0);
        return this.degree;
    }

    protected BigInteger reduceUntilConflict(int n, int n2, BigInteger[] bigIntegerArray, IWatchPb iWatchPb) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = BigInteger.ONE.negate();
        BigInteger bigInteger3 = BigInteger.ZERO;
        BigInteger bigInteger4 = this.slackConflict();
        BigInteger bigInteger5 = iWatchPb.getDegree();
        BigInteger bigInteger6 = BigInteger.ZERO;
        BigInteger bigInteger7 = this.weightedLits.get(n ^ 1);
        this.possReducedCoefs = this.possConstraint(iWatchPb, bigIntegerArray);
        do {
            if (bigInteger2.signum() >= 0) {
                assert (bigInteger3.signum() > 0);
                BigInteger bigInteger8 = this.reduceInConstraint(iWatchPb, bigIntegerArray, n2, bigInteger5);
                assert (bigInteger8.compareTo(bigInteger5) < 0 && bigInteger8.compareTo(BigInteger.ONE) >= 0);
                bigInteger5 = bigInteger8;
            }
            assert (this.weightedLits.get(n ^ 1).signum() > 0);
            assert (bigIntegerArray[n2].signum() > 0);
            if (!bigIntegerArray[n2].equals(bigInteger6)) {
                assert (bigInteger7.equals(this.weightedLits.get(n ^ 1)));
                BigInteger bigInteger9 = ConflictMap.ppcm(bigIntegerArray[n2], bigInteger7);
                assert (bigInteger9.signum() > 0);
                this.coefMult = bigInteger9.divide(bigInteger7);
                this.coefMultCons = bigInteger9.divide(bigIntegerArray[n2]);
                assert (this.coefMultCons.signum() > 0);
                assert (this.coefMult.signum() > 0);
                assert (this.coefMult.multiply(bigInteger7).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
                bigInteger6 = bigIntegerArray[n2];
            }
            bigInteger3 = this.possReducedCoefs.subtract(bigInteger5).multiply(this.coefMultCons);
            assert (bigInteger3.equals(iWatchPb.slackConstraint(bigIntegerArray, bigInteger5).multiply(this.coefMultCons)));
            assert (bigInteger4.equals(this.slackConflict()));
            bigInteger = bigInteger4.multiply(this.coefMult);
            assert (bigInteger.signum() <= 0);
        } while ((bigInteger2 = bigInteger3.add(bigInteger)).signum() >= 0);
        assert (this.coefMult.multiply(this.weightedLits.get(n ^ 1)).equals(this.coefMultCons.multiply(bigIntegerArray[n2])));
        return bigInteger5;
    }

    private BigInteger possConstraint(IWatchPb iWatchPb, BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < iWatchPb.size()) {
            if (!this.voc.isFalsified(iWatchPb.get(n))) {
                assert (bigIntegerArray[n].signum() >= 0);
                bigInteger = bigInteger.add(bigIntegerArray[n]);
            }
            ++n;
        }
        return bigInteger;
    }

    public BigInteger slackConflict() {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.size()) {
            BigInteger bigInteger2 = this.weightedLits.getCoef(n);
            if (bigInteger2.signum() != 0 && !this.voc.isFalsified(this.weightedLits.getLit(n))) {
                assert (bigInteger2.signum() > 0);
                bigInteger = bigInteger.add(bigInteger2);
            }
            ++n;
        }
        return bigInteger.subtract(this.degree);
    }

    public boolean oldIsAssertive(int n) {
        BigInteger bigInteger = this.computeSlack(n).subtract(this.degree);
        if (bigInteger.signum() < 0) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.size()) {
            BigInteger bigInteger2 = this.weightedLits.getCoef(n2);
            int n3 = this.weightedLits.getLit(n2);
            if (bigInteger2.signum() > 0 && (this.voc.isUnassigned(n3) || this.voc.getLevel(n3) >= n) && bigInteger.compareTo(bigInteger2) < 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private BigInteger computeSlack(int n) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n2 = 0;
        while (n2 < this.size()) {
            BigInteger bigInteger2 = this.weightedLits.getCoef(n2);
            int n3 = this.weightedLits.getLit(n2);
            if (!(bigInteger2.signum() <= 0 || this.voc.isFalsified(n3) && this.voc.getLevel(n3) < n)) {
                bigInteger = bigInteger.add(bigInteger2);
            }
            ++n2;
        }
        return bigInteger;
    }

    public boolean isAssertive(int n) {
        assert (n <= this.currentLevel);
        assert (n <= this.currentLevel);
        this.currentLevel = n;
        BigInteger bigInteger = this.currentSlack.subtract(this.degree);
        if (bigInteger.signum() < 0) {
            return false;
        }
        return this.isImplyingLiteral(bigInteger);
    }

    private boolean isImplyingLiteral(BigInteger bigInteger) {
        int n;
        int n2 = ConflictMap.levelToIndex(-1);
        if (this.byLevel[n2] != null) {
            for (int n3 : this.byLevel[n2]) {
                if (bigInteger.compareTo(this.weightedLits.get(n3)) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(n3);
                return true;
            }
        }
        if (this.byLevel[n = ConflictMap.levelToIndex(this.currentLevel)] != null) {
            for (int n3 : this.byLevel[n]) {
                Object object = this.weightedLits.get(n3);
                if (object == null || bigInteger.compareTo((BigInteger)object) >= 0) continue;
                this.assertiveLiteral = this.weightedLits.getFromAllLits(n3);
                return true;
            }
        }
        return false;
    }

    private boolean isImplyingLiteralOrdered(int n, BigInteger bigInteger) {
        int n2 = 0;
        while (n2 < this.size()) {
            int n3 = this.weightedLits.getLit(n2);
            int n4 = this.voc.getLevel(n3);
            if ((n4 >= n || this.voc.isUnassigned(n3)) && bigInteger.compareTo(this.weightedLits.getCoef(n2)) < 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    public BigInteger reduceInConstraint(IWatchPb iWatchPb, BigInteger[] bigIntegerArray, int n, BigInteger bigInteger) {
        assert (bigInteger.compareTo(BigInteger.ONE) > 0);
        int n2 = -1;
        int n3 = iWatchPb.size();
        int n4 = 0;
        while (n4 < n3 && n2 == -1) {
            if (bigIntegerArray[n4].signum() != 0 && this.voc.isUnassigned(iWatchPb.get(n4))) {
                assert (bigIntegerArray[n4].compareTo(bigInteger) < 0);
                n2 = n4;
            }
            ++n4;
        }
        if (n2 == -1) {
            n4 = 0;
            while (n4 < n3 && n2 == -1) {
                if (bigIntegerArray[n4].signum() != 0 && this.voc.isSatisfied(iWatchPb.get(n4)) && n4 != n) {
                    n2 = n4;
                }
                ++n4;
            }
        }
        assert (n2 != -1);
        assert (n2 != n);
        BigInteger bigInteger2 = bigInteger.subtract(bigIntegerArray[n2]);
        this.possReducedCoefs = this.possReducedCoefs.subtract(bigIntegerArray[n2]);
        bigIntegerArray[n2] = BigInteger.ZERO;
        assert (this.possReducedCoefs.equals(this.possConstraint(iWatchPb, bigIntegerArray)));
        bigInteger2 = this.saturation(bigIntegerArray, bigInteger2, iWatchPb);
        assert (bigIntegerArray[n].signum() > 0);
        assert (bigInteger.compareTo(bigInteger2) > 0);
        assert (this.possReducedCoefs.equals(this.possConstraint(iWatchPb, bigIntegerArray)));
        return bigInteger2;
    }

    private BigInteger saturation(BigInteger[] bigIntegerArray, BigInteger bigInteger, IWatchPb iWatchPb) {
        assert (bigInteger.signum() > 0);
        BigInteger bigInteger2 = bigInteger;
        boolean bl = true;
        int n = 0;
        while (n < bigIntegerArray.length) {
            int n2 = bigIntegerArray[n].compareTo(bigInteger);
            if (n2 > 0) {
                if (!this.voc.isFalsified(iWatchPb.get(n))) {
                    this.possReducedCoefs = this.possReducedCoefs.subtract(bigIntegerArray[n]);
                    this.possReducedCoefs = this.possReducedCoefs.add(bigInteger);
                }
                bigIntegerArray[n] = bigInteger;
            } else if (n2 < 0 && bigIntegerArray[n].signum() > 0) {
                bl = false;
            }
            ++n;
        }
        if (bl && !bigInteger.equals(BigInteger.ONE)) {
            this.possReducedCoefs = BigInteger.ZERO;
            bigInteger2 = BigInteger.ONE;
            n = 0;
            while (n < bigIntegerArray.length) {
                if (bigIntegerArray[n].signum() > 0) {
                    bigIntegerArray[n] = BigInteger.ONE;
                    if (!this.voc.isFalsified(iWatchPb.get(n))) {
                        this.possReducedCoefs = this.possReducedCoefs.add(BigInteger.ONE);
                    }
                }
                ++n;
            }
        }
        return bigInteger2;
    }

    private static boolean positiveCoefs(BigInteger[] bigIntegerArray) {
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        int n = bigIntegerArray.length;
        int n2 = 0;
        while (n2 < n) {
            BigInteger bigInteger = bigIntegerArray2[n2];
            if (bigInteger.signum() <= 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public int getBacktrackLevel(int n) {
        int n2 = ConflictMap.levelToIndex(n) - 1;
        int n3 = ConflictMap.levelToIndex(0);
        BigInteger bigInteger = this.computeSlack(0).subtract(this.degree);
        int n4 = 0;
        int n5 = n3;
        while (n5 <= n2) {
            if (this.byLevel[n5] != null) {
                int n6 = ConflictMap.indexToLevel(n5);
                assert (this.computeSlack(n6).subtract(this.degree).equals(bigInteger));
                if (this.isImplyingLiteralOrdered(n6, bigInteger)) break;
                VecInt vecInt = this.byLevel[n5];
                for (int n7 : vecInt) {
                    if (!this.voc.isFalsified(n7) || this.voc.getLevel(n7) != ConflictMap.indexToLevel(n5)) continue;
                    bigInteger = bigInteger.subtract(this.weightedLits.get(n7));
                }
                if (!vecInt.isEmpty()) {
                    n4 = n6;
                }
            }
            ++n5;
        }
        assert (n4 == this.oldGetBacktrackLevel(n));
        return n4;
    }

    public int oldGetBacktrackLevel(int n) {
        int n2;
        int n3 = n;
        assert (this.oldIsAssertive(n3));
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.size()) {
            n2 = this.voc.getLevel(this.weightedLits.getLit(n5));
            if (n2 < n3 && n2 > n4 && this.oldIsAssertive(n2)) {
                n3 = n2;
            }
            ++n5;
        }
        n5 = 0;
        int n6 = 0;
        while (n6 < this.size()) {
            n2 = this.voc.getLevel(this.weightedLits.getLit(n6));
            if (n2 > n5 && n2 < n3) {
                n5 = n2;
            }
            ++n6;
        }
        return n5;
    }

    public void updateSlack(int n) {
        int n2 = ConflictMap.levelToIndex(n);
        if (this.byLevel[n2] != null) {
            for (int n3 : this.byLevel[n2]) {
                if (!this.voc.isFalsified(n3)) continue;
                this.currentSlack = this.currentSlack.add(this.weightedLits.get(n3));
            }
        }
    }

    void increaseCoef(int n, BigInteger bigInteger) {
        if (!this.voc.isFalsified(n) || this.voc.getLevel(n) == this.currentLevel) {
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n))].contains(n));
        super.increaseCoef(n, bigInteger);
    }

    void decreaseCoef(int n, BigInteger bigInteger) {
        if (!this.voc.isFalsified(n) || this.voc.getLevel(n) == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(bigInteger);
        }
        assert (this.byLevel[ConflictMap.levelToIndex(this.voc.getLevel(n))].contains(n));
        super.decreaseCoef(n, bigInteger);
    }

    void setCoef(int n, BigInteger bigInteger) {
        int n2 = this.voc.getLevel(n);
        if (!this.voc.isFalsified(n) || n2 == this.currentLevel) {
            if (this.weightedLits.containsKey(n)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(n));
            }
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        int n3 = ConflictMap.levelToIndex(n2);
        if (!this.weightedLits.containsKey(n)) {
            if (this.byLevel[n3] == null) {
                this.byLevel[n3] = new VecInt();
            }
            this.byLevel[n3].push(n);
        }
        assert (this.byLevel[n3] != null);
        assert (this.byLevel[n3].contains(n));
        super.setCoef(n, bigInteger);
    }

    void changeCoef(int n, BigInteger bigInteger) {
        int n2 = this.weightedLits.getLit(n);
        int n3 = this.voc.getLevel(n2);
        if (!this.voc.isFalsified(n2) || n3 == this.currentLevel) {
            if (this.weightedLits.containsKey(n2)) {
                this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(n2));
            }
            this.currentSlack = this.currentSlack.add(bigInteger);
        }
        int n4 = ConflictMap.levelToIndex(n3);
        assert (this.weightedLits.containsKey(n2));
        assert (this.byLevel[n4] != null);
        assert (this.byLevel[n4].contains(n2));
        super.changeCoef(n, bigInteger);
    }

    void removeCoef(int n) {
        int n2 = this.voc.getLevel(n);
        if (!this.voc.isFalsified(n) || n2 == this.currentLevel) {
            this.currentSlack = this.currentSlack.subtract(this.weightedLits.get(n));
        }
        int n3 = ConflictMap.levelToIndex(n2);
        assert (n3 < this.byLevel.length);
        assert (this.byLevel[n3] != null);
        assert (this.byLevel[n3].contains(n));
        this.byLevel[n3].remove(n);
        super.removeCoef(n);
    }

    private int getLevelByLevel(int n) {
        int n2 = 0;
        while (n2 < this.byLevel.length) {
            if (this.byLevel[n2] != null && this.byLevel[n2].contains(n)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean slackIsCorrect(int n) {
        return this.currentSlack.equals(this.computeSlack(n));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.size()) {
            int n2 = this.weightedLits.getLit(n);
            stringBuffer.append(this.weightedLits.getCoef(n));
            stringBuffer.append(".");
            stringBuffer.append(Lits.toString((int)n2));
            stringBuffer.append(" ");
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(n2));
            stringBuffer.append("@");
            stringBuffer.append(this.voc.getLevel(n2));
            stringBuffer.append("]");
            ++n;
        }
        return String.valueOf(stringBuffer.toString()) + " >= " + this.degree;
    }

    public boolean hasBeenReduced() {
        return this.hasBeenReduced;
    }

    public long getNumberOfReductions() {
        return this.numberOfReductions;
    }
}

