/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalMapPBStructure {
    private final IVecInt lits;
    private final IVec<BigInteger> coefs;
    private IVecInt allLits;

    InternalMapPBStructure(IVecInt iVecInt, IVec<BigInteger> iVec) {
        this.lits = iVecInt;
        this.coefs = iVec;
    }

    InternalMapPBStructure(int n) {
        assert (n > 0);
        this.allLits = new VecInt(n, -1);
        this.coefs = new Vec();
        this.lits = new VecInt();
    }

    InternalMapPBStructure(PBConstr pBConstr) {
        this.allLits = new VecInt(pBConstr.getVocabulary().nVars() * 2 + 2, -1);
        this.coefs = new Vec(pBConstr.size());
        this.lits = new VecInt(pBConstr.size());
        int n = 0;
        while (n < pBConstr.size()) {
            assert (pBConstr.get(n) != 0);
            assert (pBConstr.getCoef(n).signum() > 0);
            int n2 = pBConstr.get(n);
            this.lits.push(n2);
            assert (n + 1 == this.lits.size());
            this.allLits.set(n2, n);
            this.coefs.push((Object)pBConstr.getCoef(n));
            ++n;
        }
    }

    BigInteger get(int n) {
        assert (this.allLits.get(n) != -1);
        return (BigInteger)this.coefs.get(this.allLits.get(n));
    }

    int getFromAllLits(int n) {
        return this.allLits.get(n);
    }

    int getLit(int n) {
        assert (n < this.lits.size());
        return this.lits.get(n);
    }

    BigInteger getCoef(int n) {
        assert (n < this.coefs.size());
        return (BigInteger)this.coefs.get(n);
    }

    boolean containsKey(int n) {
        return this.allLits.get(n) != -1;
    }

    int size() {
        return this.lits.size();
    }

    void put(int n, BigInteger bigInteger) {
        int n2 = this.allLits.get(n);
        if (n2 != -1) {
            this.coefs.set(n2, (Object)bigInteger);
        } else {
            this.lits.push(n);
            this.coefs.push((Object)bigInteger);
            this.allLits.set(n, this.lits.size() - 1);
        }
    }

    void changeCoef(int n, BigInteger bigInteger) {
        assert (n <= this.coefs.size());
        this.coefs.set(n, (Object)bigInteger);
    }

    void remove(int n) {
        int n2 = this.allLits.get(n);
        if (n2 != -1) {
            int n3 = this.lits.last();
            this.coefs.delete(n2);
            this.lits.delete(n2);
            this.allLits.set(n3, n2);
            this.allLits.set(n, -1);
        }
    }

    void copyCoefs(IVec<BigInteger> iVec) {
        this.coefs.copyTo(iVec);
    }

    void copyCoefs(BigInteger[] bigIntegerArray) {
        this.coefs.copyTo((Object[])bigIntegerArray);
    }

    void copyLits(IVecInt iVecInt) {
        this.lits.copyTo(iVecInt);
    }

    void copyLits(int[] nArray) {
        this.lits.copyTo(nArray);
    }
}

