/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.UnitPropagationListener;

public final class MaxWatchPb
extends WatchPb {
    private static final long serialVersionUID = 1L;
    public static final int LIMIT_FOR_MAP = 100;
    private BigInteger watchCumul = BigInteger.ZERO;
    private final Map<Integer, BigInteger> litToCoeffs;

    private MaxWatchPb(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, BigInteger>(this.coefs.length);
            int n = 0;
            while (n < this.coefs.length) {
                this.litToCoeffs.put(this.lits[n], this.coefs[n]);
                ++n;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPb(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = BigInteger.ZERO;
        if (bigIntegerArray.length > 100) {
            this.litToCoeffs = new HashMap<Integer, BigInteger>(this.coefs.length);
            int n = 0;
            while (n < this.coefs.length) {
                this.litToCoeffs.put(this.lits[n], this.coefs[n]);
                ++n;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul.equals(BigInteger.ZERO));
        int n = 0;
        while (n < this.lits.length) {
            if (this.voc.isFalsified(this.lits[n])) {
                if (this.learnt) {
                    this.voc.undos(this.lits[n] ^ 1).push((Object)this);
                    this.voc.watch(this.lits[n] ^ 1, (Propagatable)this);
                }
            } else {
                this.voc.watch(this.lits[n] ^ 1, (Propagatable)this);
                this.watchCumul = this.watchCumul.add(this.coefs[n]);
            }
            ++n;
        }
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        if (!this.learnt && this.watchCumul.compareTo(this.degree) < 0) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < this.coefs.length && this.watchCumul.subtract(this.coefs[n]).compareTo(this.degree) < 0) {
            if (this.voc.isUnassigned(this.lits[n]) && !unitPropagationListener.enqueue(this.lits[n], (Constr)this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++n;
        }
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        BigInteger bigInteger;
        this.voc.watch(n, (Propagatable)this);
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0) : this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            bigInteger = this.coefs[n2];
        } else {
            bigInteger = this.litToCoeffs.get(n ^ 1);
        }
        BigInteger bigInteger2 = this.watchCumul.subtract(bigInteger);
        if (bigInteger2.compareTo(this.degree) < 0) {
            assert (!this.isSatisfiable());
            return false;
        }
        this.voc.undos(n).push((Object)this);
        this.watchCumul = bigInteger2;
        int n3 = 0;
        BigInteger bigInteger3 = this.watchCumul.subtract(this.degree);
        while (n3 < this.coefs.length && bigInteger3.compareTo(this.coefs[n3]) < 0) {
            if (this.voc.isUnassigned(this.lits[n3]) && !unitPropagationListener.enqueue(this.lits[n3], (Constr)this)) {
                assert (!this.isSatisfiable());
                return false;
            }
            ++n3;
        }
        assert (this.learnt || this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        assert (this.watchCumul.compareTo(this.computeLeftSide()) >= 0);
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[n])) {
                this.voc.watches(this.lits[n] ^ 1).remove((Object)this);
            }
            ++n;
        }
    }

    public void undo(int n) {
        BigInteger bigInteger;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            bigInteger = this.coefs[n2];
        } else {
            bigInteger = this.litToCoeffs.get(n ^ 1);
        }
        this.watchCumul = this.watchCumul.add(bigInteger);
    }

    public static MaxWatchPb normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MaxWatchPb maxWatchPb = new MaxWatchPb(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (maxWatchPb.degree.signum() <= 0) {
            return null;
        }
        maxWatchPb.computeWatches();
        maxWatchPb.computePropagation(unitPropagationListener);
        return maxWatchPb;
    }

    public static WatchPb normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MaxWatchPb(iLits, iDataStructurePB);
    }
}

