/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLongCP;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.UnitPropagationListener;

public final class MaxWatchPbLongCP
extends WatchPbLongCP {
    private static final long serialVersionUID = 1L;
    private long watchCumul = 0L;
    private final Map<Integer, Long> litToCoeffs;

    private MaxWatchPbLongCP(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (this.coefs.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(this.coefs.length);
            int n = 0;
            while (n < this.coefs.length) {
                this.litToCoeffs.put(this.lits[n], this.coefs[n]);
                ++n;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    private MaxWatchPbLongCP(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.activity = 0.0;
        this.watchCumul = 0L;
        if (bigIntegerArray.length > 100) {
            this.litToCoeffs = new HashMap<Integer, Long>(this.coefs.length);
            int n = 0;
            while (n < this.coefs.length) {
                this.litToCoeffs.put(this.lits[n], this.coefs[n]);
                ++n;
            }
        } else {
            this.litToCoeffs = null;
        }
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul == 0L);
        int n = 0;
        while (n < this.lits.length) {
            if (this.voc.isFalsified(this.lits[n])) {
                if (this.learnt) {
                    this.voc.undos(this.lits[n] ^ 1).push((Object)this);
                    this.voc.watch(this.lits[n] ^ 1, (Propagatable)this);
                }
            } else {
                this.voc.watch(this.lits[n] ^ 1, (Propagatable)this);
                this.watchCumul += this.coefs[n];
            }
            ++n;
        }
        assert (this.watchCumul >= this.computeLeftSide());
        if (!this.learnt && this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < this.coefs.length && this.watchCumul - this.coefs[n] < this.degree) {
            if (this.voc.isUnassigned(this.lits[n]) && !unitPropagationListener.enqueue(this.lits[n], (Constr)this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++n;
        }
        assert (this.watchCumul >= this.computeLeftSide());
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        long l;
        this.voc.watch(n, (Propagatable)this);
        assert (this.watchCumul >= this.computeLeftSide()) : this.watchCumul + "/" + this.computeLeftSide() + ":" + this.learnt;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            l = this.litToCoeffs.get(n ^ 1);
        }
        long l2 = this.watchCumul - l;
        if (l2 < this.degree) {
            assert (!this.isSatisfiable());
            return false;
        }
        this.voc.undos(n).push((Object)this);
        this.watchCumul = l2;
        int n3 = 0;
        long l3 = this.watchCumul - this.degree;
        while (n3 < this.coefs.length && l3 < this.coefs[n3]) {
            if (this.voc.isUnassigned(this.lits[n3]) && !unitPropagationListener.enqueue(this.lits[n3], (Constr)this)) {
                assert (!this.isSatisfiable());
                return false;
            }
            ++n3;
        }
        assert (this.learnt || this.watchCumul >= this.computeLeftSide());
        assert (this.watchCumul >= this.computeLeftSide());
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[n])) {
                this.voc.watches(this.lits[n] ^ 1).remove((Object)this);
            }
            ++n;
        }
    }

    public void undo(int n) {
        long l;
        if (this.litToCoeffs == null) {
            int n2 = 0;
            while ((this.lits[n2] ^ 1) != n) {
                ++n2;
            }
            l = this.coefs[n2];
        } else {
            Long l2 = this.litToCoeffs.get(n ^ 1);
            l = l2 != null ? this.litToCoeffs.get(n ^ 1) : 0L;
        }
        this.watchCumul += l;
    }

    public static MaxWatchPbLongCP normalizedMaxWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MaxWatchPbLongCP maxWatchPbLongCP = new MaxWatchPbLongCP(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (maxWatchPbLongCP.degree <= 0L) {
            return null;
        }
        maxWatchPbLongCP.computeWatches();
        maxWatchPbLongCP.computePropagation(unitPropagationListener);
        return maxWatchPbLongCP;
    }

    public static WatchPbLongCP normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MaxWatchPbLongCP(iLits, iDataStructurePB);
    }
}

