/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLong;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.UnitPropagationListener;

public class MinWatchPbLong
extends WatchPbLong {
    private static final long serialVersionUID = 1L;
    protected long watchCumul = 0L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;

    protected MinWatchPbLong(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected MinWatchPbLong(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul == 0L);
        assert (this.watchingCount == 0);
        int n = 0;
        while (n < this.lits.length && this.watchCumul - this.coefs[0] < this.degree) {
            if (!this.voc.isFalsified(this.lits[n])) {
                this.voc.watch(this.lits[n] ^ 1, (Propagatable)this);
                this.watching[this.watchingCount++] = n;
                this.watched[n] = true;
                this.watchCumul += this.coefs[n];
            }
            ++n;
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.nbOfWatched() == this.watchingCount);
    }

    private void watchMoreForLearntConstraint() {
        int n = 1;
        while (this.watchCumul - this.coefs[0] < this.degree && n > 0) {
            n = 0;
            int n2 = -1;
            int n3 = -1;
            int n4 = 0;
            while (n4 < this.lits.length) {
                if (this.voc.isFalsified(this.lits[n4]) && !this.watched[n4]) {
                    ++n;
                    int n5 = this.voc.getLevel(this.lits[n4]);
                    if (n5 > n2) {
                        n3 = n4;
                        n2 = n5;
                    }
                }
                ++n4;
            }
            if (n <= 0) continue;
            assert (n3 >= 0);
            this.voc.watch(this.lits[n3] ^ 1, (Propagatable)this);
            this.watching[this.watchingCount++] = n3;
            this.watched[n3] = true;
            this.watchCumul += this.coefs[n3];
            assert (--n >= 0);
        }
        assert (this.lits.length == 1 || this.watchingCount > 1);
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        int n = 0;
        while (n < this.lits.length && this.watchCumul - this.coefs[this.watching[n]] < this.degree) {
            if (this.voc.isUnassigned(this.lits[n]) && !unitPropagationListener.enqueue(this.lits[n], (Constr)this)) {
                throw new ContradictionException("non satisfiable constraint");
            }
            ++n;
        }
    }

    public static MinWatchPbLong normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MinWatchPbLong minWatchPbLong = new MinWatchPbLong(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (minWatchPbLong.degree <= 0L) {
            return null;
        }
        minWatchPbLong.computeWatches();
        minWatchPbLong.computePropagation(unitPropagationListener);
        return minWatchPbLong;
    }

    protected int nbOfWatched() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.watched.length) {
            int n3 = 0;
            while (n3 < this.watchingCount) {
                if (this.watching[n3] == n2) assert (this.watched[n2]);
                ++n3;
            }
            n += this.watched[n2] ? 1 : 0;
            ++n2;
        }
        return n;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        assert (this.nbOfWatched() == this.watchingCount);
        assert (this.watchingCount > 1);
        int n2 = 0;
        while (n2 < this.watchingCount && (this.lits[this.watching[n2]] ^ 1) != n) {
            ++n2;
        }
        int n3 = this.watching[n2];
        assert (n == (this.lits[n3] ^ 1));
        assert (this.watched[n3]);
        long l = this.maximalCoefficient(n3);
        l = this.updateWatched(l, n3);
        long l2 = this.watchCumul - this.coefs[n3];
        assert (this.nbOfWatched() == this.watchingCount);
        if (l2 < this.degree) {
            this.voc.watch(n, (Propagatable)this);
            assert (this.watched[n3]);
            assert (!this.isSatisfiable());
            return false;
        }
        if (l2 < this.degree + l) {
            assert (this.watchingCount != 0);
            long l3 = l2 - this.degree;
            int n4 = 0;
            while (n4 < this.watchingCount) {
                if (l3 < this.coefs[this.watching[n4]] && n4 != n2 && !this.voc.isSatisfied(this.lits[this.watching[n4]]) && !unitPropagationListener.enqueue(this.lits[this.watching[n4]], (Constr)this)) {
                    this.voc.watch(n, (Propagatable)this);
                    assert (!this.isSatisfiable());
                    return false;
                }
                ++n4;
            }
            this.voc.undos(n).push((Object)this);
        }
        this.watched[n3] = false;
        this.watchCumul = l2;
        this.watching[n2] = this.watching[--this.watchingCount];
        assert (this.watchingCount != 0);
        assert (this.nbOfWatched() == this.watchingCount);
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        int n = 0;
        while (n < this.watchingCount) {
            this.voc.watches(this.lits[this.watching[n]] ^ 1).remove((Object)this);
            this.watched[this.watching[n]] = false;
            ++n;
        }
        this.watchingCount = 0;
        assert (this.nbOfWatched() == this.watchingCount);
    }

    public void undo(int n) {
        this.voc.watch(n, (Propagatable)this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        assert (n2 < this.lits.length);
        this.watchCumul += this.coefs[n2];
        assert (this.watchingCount == this.nbOfWatched());
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
        assert (this.watchingCount == this.nbOfWatched());
    }

    public static WatchPbLong normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MinWatchPbLong(iLits, iDataStructurePB);
    }

    protected long maximalCoefficient(int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < this.watchingCount) {
            if (this.coefs[this.watching[n2]] > l && this.watching[n2] != n) {
                l = this.coefs[this.watching[n2]];
            }
            ++n2;
        }
        assert (this.learnt || l != 0L);
        return l;
    }

    protected long updateWatched(long l, int n) {
        long l2 = l;
        if (this.watchingCount < this.size()) {
            long l3 = this.watchCumul - this.coefs[n];
            long l4 = this.degree + l2;
            int n2 = 0;
            while (n2 < this.lits.length) {
                if (l3 >= l4) break;
                if (!this.voc.isFalsified(this.lits[n2]) && !this.watched[n2]) {
                    l3 += this.coefs[n2];
                    this.watched[n2] = true;
                    assert (this.watchingCount < this.size());
                    this.watching[this.watchingCount++] = n2;
                    this.voc.watch(this.lits[n2] ^ 1, (Propagatable)this);
                    if (this.coefs[n2] > l2) {
                        l2 = this.coefs[n2];
                        l4 = this.degree + l2;
                    }
                }
                ++n2;
            }
            this.watchCumul = l3 + this.coefs[n];
        }
        return l2;
    }
}

