/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ILits;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pseudos {
    public static IDataStructurePB niceCheckedParameters(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger, ILits iLits) {
        assert (iVecInt.size() != 0 && iVecInt.size() == iVec.size());
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        Object[] objectArray = new BigInteger[iVec.size()];
        iVec.copyTo(objectArray);
        BigInteger bigInteger2 = Pseudos.niceCheckedParametersForCompetition(nArray, (BigInteger[])objectArray, bl, bigInteger);
        MapPb mapPb = new MapPb(iLits.nVars() * 2 + 2);
        if (bigInteger2.signum() > 0) {
            bigInteger2 = mapPb.cuttingPlane(nArray, (BigInteger[])objectArray, bigInteger2);
        }
        if (bigInteger2.signum() > 0) {
            bigInteger2 = mapPb.saturation();
        }
        if (bigInteger2.signum() <= 0) {
            return null;
        }
        return mapPb;
    }

    public static BigInteger niceCheckedParametersForCompetition(int[] nArray, BigInteger[] bigIntegerArray, boolean bl, BigInteger bigInteger) {
        int n;
        BigInteger bigInteger2 = bigInteger;
        if (!bl) {
            n = 0;
            while (n < nArray.length) {
                bigIntegerArray[n] = bigIntegerArray[n].negate();
                ++n;
            }
            bigInteger2 = bigInteger2.negate();
        }
        n = 0;
        while (n < bigIntegerArray.length) {
            if (bigIntegerArray[n].signum() < 0) {
                nArray[n] = nArray[n] ^ 1;
                bigIntegerArray[n] = bigIntegerArray[n].negate();
                bigInteger2 = bigInteger2.add(bigIntegerArray[n]);
            }
            ++n;
        }
        n = 0;
        while (n < bigIntegerArray.length) {
            if (bigIntegerArray[n].compareTo(bigInteger2) > 0) {
                bigIntegerArray[n] = bigInteger2;
            }
            ++n;
        }
        return bigInteger2;
    }

    public static IDataStructurePB niceParameters(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger, ILits iLits) throws ContradictionException {
        if (iVecInt.size() == 0 && bigInteger.signum() > 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (iVecInt.size() != iVec.size()) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + iVecInt.size() + " coefs=" + iVec.size() + ".");
        }
        return Pseudos.niceCheckedParameters(iVecInt, iVec, bl, bigInteger, iLits);
    }

    public static BigInteger niceParametersForCompetition(int[] nArray, BigInteger[] bigIntegerArray, boolean bl, BigInteger bigInteger) throws ContradictionException {
        if (nArray.length == 0 && bigInteger.signum() > 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (nArray.length != bigIntegerArray.length) {
            throw new IllegalArgumentException("Contradiction dans la taille des tableaux ps=" + nArray.length + " coefs=" + bigIntegerArray.length + ".");
        }
        return Pseudos.niceCheckedParametersForCompetition(nArray, bigIntegerArray, bl, bigInteger);
    }

    public static IVec<BigInteger> toVecBigInt(IVecInt iVecInt) {
        Vec vec = new Vec(iVecInt.size());
        int n = 0;
        while (n < iVecInt.size()) {
            vec.push((Object)BigInteger.valueOf(iVecInt.get(n)));
            ++n;
        }
        return vec;
    }

    public static BigInteger toBigInt(int n) {
        return BigInteger.valueOf(n);
    }

    public static ObjectiveFunction normalizeObjective(ObjectiveFunction objectiveFunction) {
        BigInteger bigInteger;
        IVec<BigInteger> iVec = objectiveFunction.getCoeffs();
        IVecInt iVecInt = objectiveFunction.getVars();
        assert (iVec.size() == iVecInt.size());
        HashMap<Integer, BigInteger> hashMap = new HashMap<Integer, BigInteger>();
        int n = 0;
        while (n < iVecInt.size()) {
            int n2 = iVecInt.get(n);
            bigInteger = (BigInteger)hashMap.get(n2);
            if (bigInteger == null) {
                hashMap.put(n2, (BigInteger)iVec.get(n));
            } else {
                hashMap.put(n2, bigInteger.add((BigInteger)iVec.get(n)));
            }
            ++n;
        }
        assert (hashMap.size() <= iVecInt.size());
        if (hashMap.size() < iVecInt.size()) {
            VecInt vecInt = new VecInt(hashMap.size());
            bigInteger = new Vec(hashMap.size());
            for (Map.Entry entry : hashMap.entrySet()) {
                vecInt.push(((Integer)entry.getKey()).intValue());
                bigInteger.push((BigInteger)entry.getValue());
            }
            return new ObjectiveFunction((IVecInt)vecInt, (IVec<BigInteger>)bigInteger);
        }
        return objectiveFunction;
    }
}

