/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.IWatchPb;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.UnitPropagationListener;

public abstract class WatchPbLongCP
implements IWatchPb,
Propagatable,
Undoable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LIMIT_SELECTION_SORT = 15;
    protected double activity;
    protected BigInteger[] bigCoefs;
    protected BigInteger bigDegree;
    protected long[] coefs;
    protected long sumcoefs;
    protected long degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected ILits voc;

    WatchPbLongCP() {
    }

    WatchPbLongCP(IDataStructurePB iDataStructurePB) {
        int n = iDataStructurePB.size();
        this.lits = new int[n];
        this.bigCoefs = new BigInteger[n];
        iDataStructurePB.buildConstraintFromMapPb(this.lits, this.bigCoefs);
        assert (iDataStructurePB.isLongSufficient());
        this.coefs = WatchPbLongCP.toLong(this.bigCoefs);
        this.sumcoefs = 0L;
        long[] lArray = this.coefs;
        int n2 = this.coefs.length;
        int n3 = 0;
        while (n3 < n2) {
            long l = lArray[n3];
            this.sumcoefs += l;
            ++n3;
        }
        this.bigDegree = iDataStructurePB.getDegree();
        this.degree = this.bigDegree.longValue();
        this.learnt = true;
        this.sort();
    }

    WatchPbLongCP(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        this.lits = nArray;
        this.coefs = WatchPbLongCP.toLong(bigIntegerArray);
        this.degree = bigInteger.longValue();
        this.bigCoefs = bigIntegerArray;
        this.bigDegree = bigInteger;
        this.sumcoefs = bigInteger2.longValue();
        this.sort();
    }

    public static long[] toLong(BigInteger[] bigIntegerArray) {
        long[] lArray = new long[bigIntegerArray.length];
        int n = 0;
        while (n < lArray.length) {
            assert (bigIntegerArray[n].bitLength() < 64);
            lArray[n] = bigIntegerArray[n].longValue();
            assert (lArray[n] >= 0L);
            ++n;
        }
        return lArray;
    }

    public boolean isAssertive(int n) {
        long l = 0L;
        int n2 = 0;
        while (n2 < this.lits.length) {
            if (!(this.coefs[n2] <= 0L || this.voc.isFalsified(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n)) {
                l += this.coefs[n2];
            }
            ++n2;
        }
        if ((l -= this.degree) < 0L) {
            return false;
        }
        n2 = 0;
        while (n2 < this.lits.length) {
            if (this.coefs[n2] > 0L && (this.voc.isUnassigned(this.lits[n2]) || this.voc.getLevel(this.lits[n2]) >= n) && l < this.coefs[n2]) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        long l = 0L;
        int[] nArray = this.lits;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            if (this.voc.isFalsified(n3)) {
                iVecInt.push(n3 ^ 1);
                if (this.sumcoefs - (l += this.coefs[n2]) < this.degree) {
                    return;
                }
            }
            ++n2;
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    public int get(int n) {
        return this.lits[n];
    }

    public double getActivity() {
        return this.activity;
    }

    public void incActivity(double d) {
        if (this.learnt) {
            this.activity += d;
        }
    }

    public void setActivity(double d) {
        if (this.learnt) {
            this.activity = d;
        }
    }

    public long slackConstraint() {
        return this.computeLeftSide() - this.degree;
    }

    public long slackConstraint(long[] lArray, long l) {
        return this.computeLeftSide(lArray) - l;
    }

    public long computeLeftSide(long[] lArray) {
        long l = 0L;
        int n = 0;
        while (n < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[n])) {
                assert (lArray[n] >= 0L);
                l += lArray[n];
            }
            ++n;
        }
        return l;
    }

    public BigInteger computeLeftSide(BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = 0;
        while (n < this.lits.length) {
            if (!this.voc.isFalsified(this.lits[n])) {
                assert (bigIntegerArray[n].signum() >= 0);
                bigInteger = bigInteger.add(bigIntegerArray[n]);
            }
            ++n;
        }
        return bigInteger;
    }

    public long computeLeftSide() {
        return this.computeLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        return this.computeLeftSide() >= this.degree;
    }

    public boolean learnt() {
        return this.learnt;
    }

    public boolean locked() {
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (this.voc.getReason(n3) == this) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int n, int n2) {
        int n3 = n;
        while (n3 < n2 - 1) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n2) {
                if (this.coefs[n5] > this.coefs[n4] || this.coefs[n5] == this.coefs[n4] && this.lits[n5] > this.lits[n4]) {
                    n4 = n5;
                }
                ++n5;
            }
            long l = this.coefs[n3];
            this.coefs[n3] = this.coefs[n4];
            this.coefs[n4] = l;
            BigInteger bigInteger = this.bigCoefs[n3];
            this.bigCoefs[n3] = this.bigCoefs[n4];
            this.bigCoefs[n4] = bigInteger;
            int n6 = this.lits[n3];
            this.lits[n3] = this.lits[n4];
            this.lits[n4] = n6;
            assert (this.coefs[n3] >= 0L);
            assert (this.coefs[n4] >= 0L);
            ++n3;
        }
    }

    public void setLearnt() {
        this.learnt = true;
    }

    public boolean simplify() {
        long l = 0L;
        int n = 0;
        while (n < this.lits.length && l < this.degree) {
            if (this.voc.isSatisfied(this.lits[n])) {
                l += this.coefs[n];
            }
            ++n;
        }
        return l >= this.degree;
    }

    public final int size() {
        return this.lits.length;
    }

    protected final void sort() {
        assert (this.lits != null);
        if (this.coefs.length > 0) {
            this.sort(0, this.size());
        }
    }

    protected final void sort(int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 15) {
            this.selectionSort(n, n2);
        } else {
            int n4;
            block7: {
                assert (this.coefs.length == this.bigCoefs.length);
                int n5 = n3 / 2 + n;
                long l = this.coefs[n5];
                int n6 = this.lits[n5];
                n4 = n - 1;
                int n7 = n2;
                while (true) {
                    if (this.coefs[++n4] > l || this.coefs[n4] == l && this.lits[n4] > n6) {
                        continue;
                    }
                    while (l > this.coefs[--n7] || this.coefs[n7] == l && this.lits[n7] < n6) {
                    }
                    if (n4 >= n7) break block7;
                    long l2 = this.coefs[n4];
                    this.coefs[n4] = this.coefs[n7];
                    this.coefs[n7] = l2;
                    BigInteger bigInteger = this.bigCoefs[n4];
                    this.bigCoefs[n4] = this.bigCoefs[n7];
                    this.bigCoefs[n7] = bigInteger;
                    int n8 = this.lits[n4];
                    this.lits[n4] = this.lits[n7];
                    this.lits[n7] = n8;
                    assert (this.coefs[n4] >= 0L);
                    if (!$assertionsDisabled && this.coefs[n7] < 0L) break;
                }
                throw new AssertionError();
            }
            this.sort(n, n4);
            this.sort(n4, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lits.length > 0) {
            int n = 0;
            while (n < this.lits.length) {
                stringBuffer.append(" + ");
                stringBuffer.append(this.coefs[n]);
                stringBuffer.append(".");
                stringBuffer.append(Lits.toString((int)this.lits[n]));
                stringBuffer.append("[");
                stringBuffer.append(this.voc.valueToString(this.lits[n]));
                stringBuffer.append("@");
                stringBuffer.append(this.voc.getLevel(this.lits[n]));
                stringBuffer.append("]");
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append(">= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        long l = this.slackConstraint();
        int n = 0;
        while (n < this.lits.length) {
            if (this.voc.isUnassigned(this.lits[n]) && l < this.coefs[n]) {
                boolean bl = unitPropagationListener.enqueue(this.lits[n], (Constr)this);
                assert (bl);
            }
            ++n;
        }
    }

    public void assertConstraintIfNeeded(UnitPropagationListener unitPropagationListener) {
        this.assertConstraint(unitPropagationListener);
    }

    public void register() {
        block3: {
            assert (this.learnt);
            try {
                this.computeWatches();
            }
            catch (ContradictionException contradictionException) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public int[] getLits() {
        int[] nArray = new int[this.lits.length];
        System.arraycopy(this.lits, 0, nArray, 0, this.lits.length);
        return nArray;
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public IVecInt computeAnImpliedClause() {
        long l = 0L;
        int n = this.coefs.length;
        while (l > this.degree && n > 0) {
            l += this.coefs[--n];
        }
        if (n > 0 && n < this.size() / 2) {
            VecInt vecInt = new VecInt(n);
            int n2 = 0;
            while (n2 <= n) {
                vecInt.push(this.lits[n2]);
                ++n2;
            }
            return vecInt;
        }
        return null;
    }

    public boolean coefficientsEqualToOne() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            WatchPbLongCP watchPbLongCP = (WatchPbLongCP)object;
            if (this.degree != watchPbLongCP.degree || this.coefs.length != watchPbLongCP.coefs.length || this.lits.length != watchPbLongCP.lits.length) {
                return false;
            }
            int n = 0;
            while (true) {
                if (n >= this.coefs.length) {
                    return true;
                }
                int n2 = this.lits[n];
                boolean bl = false;
                int n3 = 0;
                while (n3 < this.coefs.length) {
                    if (watchPbLongCP.lits[n3] == n2) {
                        if (watchPbLongCP.coefs[n3] != this.coefs[n]) {
                            return false;
                        }
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    return false;
                }
                ++n;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 0L;
        int[] nArray = this.lits;
        int n = this.lits.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            l += (long)n3;
            ++n2;
        }
        return (int)l / this.lits.length;
    }

    public void forwardActivity(double d) {
        if (!this.learnt) {
            this.activity += d;
        }
    }

    public long[] getLongCoefs() {
        long[] lArray = new long[this.coefs.length];
        System.arraycopy(this.coefs, 0, lArray, 0, this.coefs.length);
        return lArray;
    }

    public BigInteger slackConstraint(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.computeLeftSide(bigIntegerArray).subtract(bigInteger);
    }

    public BigInteger getCoef(int n) {
        return this.bigCoefs[n];
    }

    public BigInteger[] getCoefs() {
        BigInteger[] bigIntegerArray = new BigInteger[this.coefs.length];
        System.arraycopy(this.bigCoefs, 0, bigIntegerArray, 0, this.coefs.length);
        return bigIntegerArray;
    }

    public BigInteger getDegree() {
        return this.bigDegree;
    }

    public boolean canBePropagatedMultipleTimes() {
        return true;
    }

    public Constr toConstraint() {
        return this;
    }

    public void calcReasonOnTheFly(int n, IVecInt iVecInt, IVecInt iVecInt2) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

