/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;
import org.sat4j.specs.UnitClauseProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectiveReducerPBSolverDecorator
implements IPBSolver {
    private static final long serialVersionUID = -1637773414229087105L;
    private final IPBSolver decorated;
    private final List<IVecInt> atMostOneCstrs = new ArrayList<IVecInt>();

    public ObjectiveReducerPBSolverDecorator(IPBSolver iPBSolver) {
        this.decorated = iPBSolver;
    }

    public int[] model() {
        return this.decorated.model();
    }

    public int newVar() {
        return this.decorated.newVar();
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        return this.decorated.addPseudoBoolean(iVecInt, iVec, bl, bigInteger);
    }

    public boolean model(int n) {
        return this.decorated.model(n);
    }

    public int nextFreeVarId(boolean bl) {
        return this.decorated.nextFreeVarId(bl);
    }

    public int[] primeImplicant() {
        return this.decorated.primeImplicant();
    }

    public boolean primeImplicant(int n) {
        return this.decorated.primeImplicant(n);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        IteratorInt iteratorInt = iVecInt2.iterator();
        while (iteratorInt.hasNext()) {
            if (iteratorInt.next() == n) continue;
            return this.decorated.addAtMost(iVecInt, iVecInt2, n);
        }
        this.atMostOneCstrs.add(iVecInt);
        return this.decorated.addAtMost(iVecInt, iVecInt2, n);
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.decorated.isSatisfiable();
    }

    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        return this.decorated.isSatisfiable(iVecInt, bl);
    }

    public void registerLiteral(int n) {
        this.decorated.registerLiteral(n);
    }

    public void setExpectedNumberOfClauses(int n) {
        this.decorated.setExpectedNumberOfClauses(n);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        Iterator iterator = iVec.iterator();
        while (iterator.hasNext()) {
            if (((BigInteger)iterator.next()).equals(bigInteger)) continue;
            return this.decorated.addAtMost(iVecInt, iVec, bigInteger);
        }
        this.atMostOneCstrs.add(iVecInt);
        return this.decorated.addAtMost(iVecInt, iVec, bigInteger);
    }

    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.decorated.isSatisfiable(bl);
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        return this.decorated.addClause(iVecInt);
    }

    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.decorated.isSatisfiable(iVecInt);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        return this.decorated.addAtLeast(iVecInt, iVecInt2, n);
    }

    public int[] findModel() throws TimeoutException {
        return this.decorated.findModel();
    }

    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        return this.decorated.addBlockingClause(iVecInt);
    }

    public boolean removeConstr(IConstr iConstr) {
        return this.decorated.removeConstr(iConstr);
    }

    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        return this.decorated.findModel(iVecInt);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        return this.decorated.addAtLeast(iVecInt, iVec, bigInteger);
    }

    public boolean removeSubsumedConstr(IConstr iConstr) {
        return this.decorated.removeSubsumedConstr(iConstr);
    }

    public int nConstraints() {
        return this.decorated.nConstraints();
    }

    public int newVar(int n) {
        return this.decorated.newVar(n);
    }

    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        Iterator iterator = iVec.iterator();
        while (iterator.hasNext()) {
            this.addClause((IVecInt)iterator.next());
        }
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        return this.decorated.addExactly(iVecInt, iVecInt2, n);
    }

    public int nVars() {
        return this.decorated.nVars();
    }

    public void printInfos(PrintWriter printWriter, String string) {
        this.decorated.printInfos(printWriter, string);
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        if (n == 1) {
            this.atMostOneCstrs.add(iVecInt);
        }
        return this.decorated.addAtMost(iVecInt, n);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        return this.decorated.addExactly(iVecInt, iVec, bigInteger);
    }

    public void printInfos(PrintWriter printWriter) {
        this.decorated.printInfos(printWriter);
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        return this.decorated.addAtLeast(iVecInt, n);
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        if (objectiveFunction != null) {
            VecInt vecInt = new VecInt();
            Vec vec = new Vec();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            IVecInt iVecInt = objectiveFunction.getVars();
            IVec<BigInteger> iVec = objectiveFunction.getCoeffs();
            int n = this.processAtMostOneCstrs(objectiveFunction, (IVecInt)vecInt, (IVec<BigInteger>)vec, hashSet);
            System.out.println("c " + n + " reductions due to atMostOne constraints");
            int n2 = 0;
            while (n2 < iVecInt.size()) {
                if (!hashSet.contains(iVecInt.get(n2))) {
                    vecInt.push(iVecInt.get(n2));
                    vec.push((Object)((BigInteger)iVec.get(n2)));
                }
                ++n2;
            }
            objectiveFunction = new ObjectiveFunction((IVecInt)vecInt, (IVec<BigInteger>)vec);
        }
        this.decorated.setObjectiveFunction(objectiveFunction);
    }

    private int processAtMostOneCstrs(ObjectiveFunction objectiveFunction, IVecInt iVecInt, IVec<BigInteger> iVec, Set<Integer> set) {
        System.out.println("c " + this.atMostOneCstrs.size() + " atMostOne constraints found");
        int n = 0;
        IVecInt iVecInt2 = objectiveFunction.getVars();
        IVec<BigInteger> iVec2 = objectiveFunction.getCoeffs();
        for (IVecInt iVecInt3 : this.atMostOneCstrs) {
            boolean bl = true;
            for (int n2 : iVecInt3) {
                if (set.contains(n2)) {
                    bl = false;
                    break;
                }
                int n3 = iVecInt2.indexOf(n2);
                if (n3 != -1 && ((BigInteger)iVec2.get(n3)).equals(BigInteger.ONE)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            int n4 = this.nextFreeVarId(true);
            try {
                for (int n3 : iVecInt3) {
                    this.decorated.addClause((IVecInt)new VecInt(new int[]{n3, n4}));
                    set.add(n3);
                    ++n;
                }
            }
            catch (ContradictionException contradictionException) {
                contradictionException.printStackTrace();
            }
            iVecInt.push(n4);
            iVec.push((Object)BigInteger.ONE);
            --n;
        }
        return n;
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.decorated.getObjectiveFunction();
    }

    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        return this.decorated.addExactly(iVecInt, n);
    }

    public void setTimeout(int n) {
        this.decorated.setTimeout(n);
    }

    public void setTimeoutOnConflicts(int n) {
        this.decorated.setTimeoutOnConflicts(n);
    }

    public void setTimeoutMs(long l) {
        this.decorated.setTimeoutMs(l);
    }

    public int getTimeout() {
        return this.decorated.getTimeout();
    }

    public long getTimeoutMs() {
        return this.decorated.getTimeoutMs();
    }

    public void expireTimeout() {
        this.decorated.expireTimeout();
    }

    public void reset() {
        this.decorated.reset();
    }

    public void printStat(PrintStream printStream, String string) {
        this.decorated.printStat(printStream, string);
    }

    public void printStat(PrintWriter printWriter, String string) {
        this.decorated.printStat(printWriter, string);
    }

    public void printStat(PrintWriter printWriter) {
        this.decorated.printStat(printWriter);
    }

    public Map<String, Number> getStat() {
        return this.decorated.getStat();
    }

    public String toString(String string) {
        return this.decorated.toString(string);
    }

    public void clearLearntClauses() {
        this.decorated.clearLearntClauses();
    }

    public void setDBSimplificationAllowed(boolean bl) {
        this.decorated.setDBSimplificationAllowed(bl);
    }

    public boolean isDBSimplificationAllowed() {
        return this.decorated.isDBSimplificationAllowed();
    }

    public <S extends ISolverService> void setSearchListener(SearchListener<S> searchListener) {
        this.decorated.setSearchListener(searchListener);
    }

    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        return this.decorated.getSearchListener();
    }

    public boolean isVerbose() {
        return this.decorated.isVerbose();
    }

    public void setVerbose(boolean bl) {
        this.decorated.setVerbose(bl);
    }

    public void setLogPrefix(String string) {
        this.decorated.setLogPrefix(string);
    }

    public String getLogPrefix() {
        return this.decorated.getLogPrefix();
    }

    public IVecInt unsatExplanation() {
        return this.decorated.unsatExplanation();
    }

    public int[] modelWithInternalVariables() {
        return this.decorated.modelWithInternalVariables();
    }

    public int realNumberOfVariables() {
        return this.decorated.realNumberOfVariables();
    }

    public boolean isSolverKeptHot() {
        return this.decorated.isSolverKeptHot();
    }

    public void setKeepSolverHot(boolean bl) {
        this.decorated.setKeepSolverHot(bl);
    }

    public ISolver getSolvingEngine() {
        return this.decorated.getSolvingEngine();
    }

    public void setUnitClauseProvider(UnitClauseProvider unitClauseProvider) {
        this.decorated.setUnitClauseProvider(unitClauseProvider);
    }
}

