/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.core;

import java.math.BigInteger;
import java.util.HashSet;
import org.sat4j.core.ConstrGroup;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.LearnedConstraintsDeletionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.IPBSolverService;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.core.IPBCDCLSolver;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverStats;
import org.sat4j.pb.orders.IOrderObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.UnitPropagationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PBSolver
extends Solver<PBDataStructureFactory>
implements IPBCDCLSolver<PBDataStructureFactory>,
IPBSolverService {
    private ObjectiveFunction objf;
    private static final long serialVersionUID = 1L;
    protected PBSolverStats stats;
    public final LearnedConstraintsDeletionStrategy objectiveFunctionBased = new LearnedConstraintsDeletionStrategy(){
        private static final long serialVersionUID = 1L;
        private boolean[] inObjectiveFunction;
        private final ConflictTimer clauseManagement = new ConflictTimerAdapter(1000){
            private static final long serialVersionUID = 1L;
            private int nbconflict;
            private static final int MAX_CLAUSE = 5000;
            private static final int INC_CLAUSE = 1000;
            private int nextbound;
            {
                this.nbconflict = 0;
                this.nextbound = 5000;
            }

            public void run() {
                this.nbconflict += this.bound();
                if (this.nbconflict >= this.nextbound) {
                    this.nextbound += 1000;
                    this.nbconflict = 0;
                    PBSolver.this.setNeedToReduceDB(true);
                }
            }

            public void reset() {
                super.reset();
                this.nextbound = 5000;
                if (this.nbconflict >= this.nextbound) {
                    this.nbconflict = 0;
                    PBSolver.this.setNeedToReduceDB(true);
                }
            }
        };

        public void reduce(IVec<Constr> iVec) {
            int n = 0;
            int n2 = 0;
            while (n2 < iVec.size()) {
                Constr constr = (Constr)iVec.get(n2);
                if (constr.locked() || constr.getActivity() <= 2.0) {
                    iVec.set(n++, (Object)((Constr)PBSolver.this.learnts.get(n2)));
                } else {
                    constr.remove((UnitPropagationListener)PBSolver.this);
                }
                ++n2;
            }
            if (PBSolver.this.isVerbose()) {
                System.out.println(String.valueOf(PBSolver.this.getLogPrefix()) + "cleaning " + (iVec.size() - n) + " clauses out of " + iVec.size() + "/" + PBSolver.this.stats.conflicts);
                System.out.flush();
            }
            PBSolver.this.learnts.shrinkTo(n);
        }

        public ConflictTimer getTimer() {
            return this.clauseManagement;
        }

        public String toString() {
            return "Objective function driven learned constraints deletion strategy";
        }

        public void init() {
            this.inObjectiveFunction = new boolean[PBSolver.this.nVars() + 1];
            if (PBSolver.this.objf == null) {
                throw new IllegalStateException("The strategy does not make sense if there is no objective function");
            }
            IteratorInt iteratorInt = PBSolver.this.objf.getVars().iterator();
            while (iteratorInt.hasNext()) {
                this.inObjectiveFunction[Math.abs((int)iteratorInt.next())] = true;
            }
            this.clauseManagement.reset();
        }

        public void onClauseLearning(Constr constr) {
            boolean bl = true;
            int n = 0;
            while (n < constr.size()) {
                bl = bl && this.inObjectiveFunction[LiteralsUtils.var((int)constr.get(n))];
                ++n;
            }
            if (bl) {
                constr.incActivity(1.0);
            } else {
                constr.incActivity((double)constr.size());
            }
        }

        public void onConflictAnalysis(Constr constr) {
        }

        public void onPropagation(Constr constr) {
        }
    };

    public PBSolver(LearningStrategy<PBDataStructureFactory> learningStrategy, PBDataStructureFactory pBDataStructureFactory, IOrder iOrder, RestartStrategy restartStrategy) {
        super(learningStrategy, (DataStructureFactory)pBDataStructureFactory, iOrder, restartStrategy);
        this.stats = new PBSolverStats();
        this.initStats(this.stats);
    }

    public PBSolver(LearningStrategy<PBDataStructureFactory> learningStrategy, PBDataStructureFactory pBDataStructureFactory, SearchParams searchParams, IOrder iOrder, RestartStrategy restartStrategy) {
        super(learningStrategy, (DataStructureFactory)pBDataStructureFactory, searchParams, iOrder, restartStrategy);
        this.stats = new PBSolverStats();
        this.initStats(this.stats);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        assert (iVecInt2.size() == iVecInt.size());
        assert (iVecInt.size() == iVec.size());
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, bl, bigInteger));
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objf = objectiveFunction;
        IOrder iOrder = this.getOrder();
        if (iOrder instanceof IOrderObjective) {
            ((IOrderObjective)iOrder).setObjectiveFunction(objectiveFunction);
        }
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.objf;
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec vec = new Vec(iVecInt2.size());
        int n2 = 0;
        while (n2 < iVecInt2.size()) {
            vec.push((Object)BigInteger.valueOf(iVecInt2.get(n2)));
            ++n2;
        }
        return this.addAtMost(iVecInt, (IVec<BigInteger>)vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        assert (iVecInt2.size() == iVecInt.size());
        assert (iVecInt.size() == iVec.size());
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, false, bigInteger));
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec vec = new Vec(iVecInt2.size());
        int n2 = 0;
        while (n2 < iVecInt2.size()) {
            vec.push((Object)BigInteger.valueOf(iVecInt2.get(n2)));
            ++n2;
        }
        return this.addAtLeast(iVecInt, (IVec<BigInteger>)vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        assert (iVecInt2.size() == iVecInt.size());
        assert (iVecInt.size() == iVec.size());
        return this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, true, bigInteger));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVecInt iVecInt2, int n) throws ContradictionException {
        Vec vec = new Vec(iVecInt2.size());
        int n2 = 0;
        while (n2 < iVecInt2.size()) {
            vec.push((Object)BigInteger.valueOf(iVecInt2.get(n2)));
            ++n2;
        }
        return this.addExactly(iVecInt, (IVec<BigInteger>)vec, BigInteger.valueOf(n));
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        assert (iVecInt2.size() == iVecInt.size());
        assert (iVecInt.size() == iVec.size());
        ConstrGroup constrGroup = new ConstrGroup(false);
        constrGroup.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, false, bigInteger)));
        constrGroup.add(this.addConstr(((PBDataStructureFactory)this.dsfactory).createPseudoBooleanConstraint(iVecInt2, iVec, true, bigInteger)));
        return constrGroup;
    }

    @Override
    public IConstr addAtMostOnTheFly(IVecInt iVecInt, IVec<BigInteger> iVec, BigInteger bigInteger) {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        this.sharedConflict = ((PBDataStructureFactory)this.dsfactory).createUnregisteredAtMostConstraint(iVecInt2, iVec, bigInteger);
        this.sharedConflict.register();
        this.addConstr(this.sharedConflict);
        VecInt vecInt = new VecInt();
        this.sharedConflict.calcReasonOnTheFly(-1, this.trail, (IVecInt)vecInt);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        IteratorInt iteratorInt = vecInt.iterator();
        while (iteratorInt.hasNext()) {
            hashSet.add(iteratorInt.next());
        }
        while (!this.trail.isEmpty() && !hashSet.contains(this.trail.last())) {
            this.undoOne();
            if (this.trailLim.isEmpty() || this.trailLim.last() != this.trail.size()) continue;
            this.trailLim.pop();
        }
        return this.sharedConflict;
    }

    @Override
    public IConstr addAtMostOnTheFly(IVecInt iVecInt, IVecInt iVecInt2, int n) {
        Vec vec = new Vec(iVecInt2.size());
        IteratorInt iteratorInt = iVecInt2.iterator();
        while (iteratorInt.hasNext()) {
            vec.push((Object)BigInteger.valueOf(iteratorInt.next()));
        }
        return this.addAtMostOnTheFly(iVecInt, (IVec<BigInteger>)vec, BigInteger.valueOf(n));
    }
}

